    -- create an instance of the filter and redirect .output to it
    .output~destination(.stream['STDOUT']~~command('open write nobuffer'))

::class stream subclass rexx:stream public

::method '[]' class
    forward message 'NEW'

::method say
    use strict arg line                 /* enforce zero or one argument      */
    if right(line, 1) = '00'x then
      return self~charout:super(line)
    else
      return self~lineout:super(line)

::method arrayIn
    if arg(1)~isA(.variableReference) then
        forward message "ARRAYINTO"
    use strict arg type="LINES"
    select  -- validate TYPE argument
        when type~caselessStartsWith("L") then
            doLines = 1                 -- line operation
        when type~caselessStartsWith("C") then
            doLines = 0                 -- character operation
        otherwise
            raise syntax 93.915 array ("CL", type)
    end
    allChars = self~charIn:super(, self~chars:super)
    if doLines then
        ans = allChars~makeArray
    else
        ans = allChars~makeArray("")
    return ans

::method arrayInto
    use arg varRef=''
    if \varRef~isA(.variableReference) then
        raise syntax 88.928 array ('First', varRef)
    varRef~value = self~sendWith("ARRAYIN", arg(2, 'A'))

::method charIn
    if arg(1)~isA(.variableReference) then
        forward message "CHARINTO"
    else
        forward class (super)

::method charInto
    use arg varRef=''
    if \varRef~isA(.variableReference) then
        raise syntax 88.928 array ('First', varRef)
    varRef~value = self~sendWith(("CHARIN", super), arg(2, 'A'))

::method lineIn
    if arg(1)~isA(.variableReference) then
        forward message "LINEINTO"
    else
        forward class (super)

::method lineInto
    use arg varRef=''
    if \varRef~isA(.variableReference) then
        raise syntax 88.928 array ('First', varRef)
    varRef~value = self~sendWith(("LINEIN", super), arg(2, 'A'))
