/*
 * Connect/disconnect to/from SQLite3 database using generic naming
 */
Arg db
If db \= 'LITE' & db \= 'MY' Then
   Do
      Say 'Arg 1 must be "lite" or "my"'
      Return 0
   End
dir.LITE = '/Users/mark/projects/talks/2024-RexxSQL-Design/2.6/sqlite3'
dir.MY = '/Users/mark/projects/talks/2024-RexxSQL-Design/2.6/mysql'
Call Value 'REGINA_ADDON_DIR', dir.db, 'ENVIRONMENT'

Call RxFuncAdd 'SQLLoadFuncs', 'rexxsql', 'SQLLoadFuncs'
loaderror = RxFuncErrMsg()
If loaderror \= '' Then
   Do
      Say loaderror
      Say Value( 'REGINA_ADDON_DIR',, 'ENVIRONMENT' )
      Return 0
   End
Call SQLLoadFuncs

If db = 'LITE' Then rcode = SQLConnect( 'c1',,,'test.db' )
Else rcode = SQLConnect( 'c1','bass','Password1','bass' )
If rcode \= 0 Then Call AnError .line, 'Connecting', 'abort'

Say 'Line:' .line '-' SQLVariable( 'VERSION' )
Say 'Line:' .line '-' SQLGetInfo( 'c1', 'DBMSNAME' ) SQLGetInfo( 'c1', 'DBMSVERSION' )

rcode = SQLGetInfo( 'c1', 'JUNK' )
If rcode \= 0 Then Call AnError 'Internal Error:', 'return'

rcode = SQLCommand( 'q1', 'select * from junk' )
If rcode \= 0 Then Call AnError 'SQL Error:', 'return'

rcode = SQLCommand( 'q1', 'select empname, dbname from rx_emp' )
If rcode \= 0 Then Call AnError 'SQL Error:', 'return'

Do i = 1 To q1.empname.0
   Say 'Line:' .line '-' q1.empname.i 'from' q1.dbname.i
End

rcode = SQLDisconnect( 'c1' )
If rcode \= 0 Then Call AnError 'Disconnecting', 'abort'

Call SQLDropFuncs 'UNLOAD'

Return 0

AnError: Procedure Expose SQLCA.
Parse Arg msg, abort
If SQLCA.INTCODE = -1 Then msg = 'Line:' .sigl '-' msg SQLCA.SQLERRM '('SQLCA.SQLCODE')'
Else msg = 'Line:' .sigl '-' msg SQLCA.INTERRM '('SQLCA.INTCODE')'

Say msg

If abort = 'abort' Then Exit 1
Else Return 0
