/*
 * Connect/disconnect to/from SQLite3 and mySQL databases using database naming
 */
dir.26 = '/Users/mark/projects/talks/2024-RexxSQL-Design/2.6'
Call Value 'REGINA_ADDON_DIR', dir.26, 'ENVIRONMENT'

Call RxFuncAdd 'LITELoadFuncs', 'rexxlite', 'LITELoadFuncs'
loaderror = RxFuncErrMsg()
If loaderror \= '' Then
   Do
      Say loaderror
      Say Value( 'REGINA_ADDON_DIR',, 'ENVIRONMENT' )
      Return 0
   End
Call LITELoadFuncs

Call RxFuncAdd 'MYLoadFuncs', 'rexxmy', 'MYLoadFuncs'
loaderror = RxFuncErrMsg()
If loaderror \= '' Then
   Do
      Say loaderror
      Say Value( 'REGINA_ADDON_DIR',, 'ENVIRONMENT' )
      Return 0
   End
Call MYLoadFuncs

rcode = LITEConnect( 'c1',,,'test.db' )
If rcode \= 0 Then Call AnError 'LITE', 'Connecting', 'abort'

rcode = MYConnect( 'c2','bass','Password1','bass' )
If rcode \= 0 Then Call AnError 'MY', 'Connecting', 'abort'

Say 'Line:' .line '-' LITEVariable( 'VERSION' )
Say 'Line:' .line '-' LITEGetInfo( 'c1', 'DBMSNAME' ) LITEGetInfo( 'c1', 'DBMSVERSION' )

Say 'Line:' .line '-' MYVariable( 'VERSION' )
Say 'Line:' .line '-' MYGetInfo( 'c2', 'DBMSNAME' ) MYGetInfo( 'c2', 'DBMSVERSION' )

rcode = LITEGetInfo( 'c1', 'JUNK' )
If rcode \= 0 Then Call AnError 'LITE', 'Internal Error:', 'return'

rcode = MYGetInfo( 'c2', 'JUNK' )
If rcode \= 0 Then Call AnError 'MY', 'Internal Error:', 'return'

rcode = LITECommand( 'q1', 'select * from junk' )
If rcode \= 0 Then Call AnError 'LITE', 'SQL Error:', 'return'

rcode = MYCommand( 'q2', 'select * from junk' )
If rcode \= 0 Then Call AnError 'MY', 'SQL Error:', 'return'

rcode = LITECommand( 'q1', 'select empname, dbname from rx_emp' )
If rcode \= 0 Then Call AnError 'LITE', 'SQL Error:', 'return'

Do i = 1 To q1.empname.0
   Say 'Line:' .line '-' q1.empname.i 'from' q1.dbname.i
End

rcode = MYCommand( 'q1', 'select empname, dbname from rx_emp' )
If rcode \= 0 Then Call AnError 'MY', 'SQL Error:', 'return'

Do i = 1 To q1.empname.0
   Say 'Line:' .line '-' q1.empname.i 'from' q1.dbname.i
End

rcode = LITEDisconnect( 'c1' )
If rcode \= 0 Then Call AnError 'LITE', 'Disconnecting', 'abort'

rcode = MYDisconnect( 'c2' )
If rcode \= 0 Then Call AnError 'MY', 'Disconnecting', 'abort'

Call LITEDropFuncs 'UNLOAD'
Call MYDropFuncs 'UNLOAD'

Return 0

AnError: Procedure Expose LITECA. MYCA.
Parse Arg db, msg, abort
If db = 'LITE' Then
   Do
      If LITECA.INTCODE = -1 Then msg = 'Line:' .sigl '-' msg LITECA.SQLERRM '('LITECA.SQLCODE')'
      Else msg = 'Line:' .sigl '-' msg LITECA.INTERRM '('LITECA.INTCODE')'
   End
Else
   Do
      If MYCA.INTCODE = -1 Then msg = 'Line:' .sigl '-' msg MYCA.SQLERRM '('MYCA.SQLCODE')'
      Else msg = 'Line:' .sigl '-' msg MYCA.INTERRM '('MYCA.INTCODE')'
   End

Say msg

If abort = 'abort' Then Exit 1
Else Return 0
