/*
 * Connect/disconnect to/from SQLite3 and mySQL databases
 */
dir.30 = '/Users/mark/projects/talks/2024-RexxSQL-Design/3.0'
Call Value 'REGINA_ADDON_DIR', dir.30, 'ENVIRONMENT'

Call RxFuncAdd 'SQLLoadFuncs', 'rexxsql', 'SQLLoadFuncs'
loaderror = RxFuncErrMsg()
If loaderror \= '' Then
   Do
      Say loaderror
      Say Value( 'REGINA_ADDON_DIR',, 'ENVIRONMENT' )
      Return 0
   End
--Call SQLLoadFuncs

rcode = SQLLoadFuncs( 'LITE' )
If rcode \= 0 Then Call AnError 'LITE', 'Loading', 'abort'
rcode = SQLLoadFuncs( 'MY')
If rcode \= 0 Then Call AnError 'MY', 'Loading', 'abort'

rcode = SQLConnect( 'lite1',,,'test.db',,'LITE' )
If rcode \= 0 Then Call AnError 'LITE', 'Connecting', 'abort'

rcode = SQLConnect( 'my1','bass','Password1','bass',,'MY' )
If rcode \= 0 Then Call AnError 'MY', 'Connecting', 'abort'

Call SQLDefault 'lite1'
Say 'Line:' .line '-' SQLVariable( 'VERSION' )
Say 'Line:' .line '-' SQLGetInfo( 'lite1', 'DBMSNAME' ) SQLGetInfo( 'lite1', 'DBMSVERSION' )

Call SQLDefault 'my1'
Say 'Line:' .line '-' SQLVariable( 'VERSION' )
Say 'Line:' .line '-' SQLGetInfo( 'my1', 'DBMSNAME' ) SQLGetInfo( 'my1', 'DBMSVERSION' )

Call SQLDefault 'lite1'
rcode = SQLCommand( 'q1', 'select * from rx_emp' )
If rcode \= 0 Then Call AnError 'LITE', 'SQL Error:', 'return'
Do i = 1 To q1.empname.0
   Say 'Line:' .line '-' q1.empid.i q1.empname.i q1.dbname.i
End

Call SQLDefault 'my1'
rcode = SQLCommand( 'q2', 'select * from RX_EMP' )
If rcode \= 0 Then Call AnError 'MY', 'SQL Error:', 'return'
Do i = 1 To q2.empname.0
   Say 'Line:' .line '-' q2.empid.i q2.empname.i q2.dbname.i
End

rcode = SQLGetInfo( 'lite1', 'JUNK' )
If rcode \= 0 Then Call AnError 'LITE', 'Internal Error:', 'return'

rcode = SQLGetInfo( 'my1', 'JUNK' )
If rcode \= 0 Then Call AnError 'MY', 'Internal Error:', 'return'

Call SQLDefault 'lite1'
rcode = SQLCommand( 'q1', 'select * from junk' )
If rcode \= 0 Then Call AnError 'LITE', 'SQL Error:', 'return'

Call SQLDefault 'my1'
rcode = SQLCommand( 'q2', 'select * from junk' )
If rcode \= 0 Then Call AnError 'MY', 'SQL Error:', 'return'

rcode = SQLDisconnect( 'lite1' )
If rcode \= 0 Then Call AnError 'LITE', 'Disconnecting', 'abort'

rcode = SQLDisconnect( 'my1' )
If rcode \= 0 Then Call AnError 'MY', 'Disconnecting', 'abort'

Return 0

AnError: Procedure Expose SQLCA.
Parse Arg db, msg, abort
If SQLCA.INTCODE = -1 Then msg = 'Line:' .sigl '-' '('db')' msg SQLCA.SQLERRM '('SQLCA.SQLCODE')'
Else msg = 'Line:' .sigl '-' '('db')' msg SQLCA.INTERRM '('SQLCA.INTCODE')'

Say msg

If abort = 'abort' Then Exit 1
Else Return 0
