/*
 * Connect/disconnect to/from SQLite3 database using SQLite naming
 */
dir.26 = '/Users/mark/projects/talks/2024-RexxSQL-Design/2.6'
Call Value 'REGINA_ADDON_DIR', dir.26, 'ENVIRONMENT'

Call RxFuncAdd 'LITELoadFuncs', 'rexxlite', 'LITELoadFuncs'
loaderror = RxFuncErrMsg()
If loaderror \= '' Then
   Do
      Say loaderror
      Say Value( 'REGINA_ADDON_DIR',, 'ENVIRONMENT' )
      Return 0
   End
Call LITELoadFuncs

rcode = LITEConnect( 'c1',,,'test.db' )
If rcode \= 0 Then Call AnError .line, 'Connecting', 'abort'

Say 'Line:' .line '-' LITEVariable( 'VERSION' )
Say 'Line:' .line '-' LITEGetInfo( 'c1', 'DBMSNAME' ) LITEGetInfo( 'c1', 'DBMSVERSION' )

rcode = LITEGetInfo( 'c2', 'JUNK' )
If rcode \= 0 Then Call AnError 'Internal Error:', 'return'

rcode = LITECommand( 'q1', 'select * from junk' )
If rcode \= 0 Then Call AnError 'SQL Error:', 'return'

rcode = LITECommand( 'q1', 'select empname, dbname from rx_emp' )
If rcode \= 0 Then Call AnError 'SQL Error:', 'return'

Do i = 1 To q1.empname.0
   Say 'Line:' .line '-' q1.empname.i 'from' q1.dbname.i
End

rcode = LITEDisconnect( 'c1' )
If rcode \= 0 Then Call AnError 'Disconnecting', 'abort'

Call LITEDropFuncs 'UNLOAD'

Return 0

AnError: Procedure Expose LITECA.
Parse Arg msg, abort
If LITECA.INTCODE = -1 Then msg = 'Line:' .sigl '-' msg LITECA.SQLERRM '('LITECA.SQLCODE')'
Else msg = 'Line:' .sigl '-' msg LITECA.INTERRM '('LITECA.INTCODE')'

Say msg

If abort = 'abort' Then Exit 1
Else Return 0
