#!/usr/bin/env rexx
/* This routine will be called from the Rexx code defined in the Button element in
   with the fx:id="idButton1" the "onAction" attribute in the FXML Button definition */
::routine buttonClicked public
  use arg slotDir    -- using Rexx script annotation instead
  now=.dateTime~new -- time of invocation
  say now": arrived in routine 'buttonClicked' ..."
  /* RexxScript annotation fetches the Label object with the id "idLabel1" from
     the ScriptContext and makes it available as the Rexx variable "IDLABEL1"  */
  /* @get(idLabel1) */
  say '... current value of label='pp(idLabel1~getText)
  idLabel1~text="Clicked at:" now         -- set text property
  say '...     new value of label='pp(idLabel1~getText)
  say
