persons=.Array~new         /* create an array                           */
persons[1]=.person~new("Albert", "Einstein", 45000)
persons[2]=.person~new("Vera", "WithAnyName", 25000)

do p over persons~sort     /* iterate over all persons in sorted order  */
   say "Person:" p~firstName p~lastName p~salary
end

::CLASS Person             /* name of the structure/class               */
::ATTRIBUTE firstName
::ATTRIBUTE lastName
::ATTRIBUTE salary

::METHOD INIT        /* constructor method                              */
  EXPOSE firstName lastName salary     /* access attributes directly    */
  USE ARG firstName, lastName, salary  /* assign arguments to attributes*/

::METHOD compareTo         /* comparison method for sorting             */
  EXPOSE salary            /* access attribute directly                 */
  use arg other            /* other person to compare to                */
  if other~salary<salary then return 1 /* our salary is greater         */
  if other~salary=salary then return 0 /* salaries are the same         */
  return -1                /* other salary is greater                   */
