-- set to the code of the  myMTprefix resource
.traceObject~setMakeString(.resources~myMTprefix)
event = .EventSemaphore~new
say "main starts tasks"
do nr = 1 to 3
    .task~new~waitFor(event, "task" nr)
end
call SysSleep 0.1
say "main posts"
event~post
say "main ends"

::class Task
::method waitFor
    reply
    use strict arg event, name
    say name "waits"
    event~wait
    say name "runs"

::options trace all

::RESOURCE myMTprefix   -- define own trace format
  use arg traceObj      -- fetch traceObject
  tod=traceObj["TIMESTAMP"]~timeOfDay
  return '#' adjRight(traceObj["NR"])"," tod"," -
         "T"traceObj["THREAD"]":" traceObj["TRACELINE"]
  adjRight: procedure   -- adjust right
    use strict arg value, width=3
    if value~length>=width then return value
    return value~right(width)
::END