-- .traceObject~option="T" -- show thread number in trace prefix
event = .EventSemaphore~new
say "main starts tasks"
do nr = 1 to 3          -- create tasks that wait on semaphore
    .task~new~waitFor(event, "task" nr) -- create object, send message
end
call SysSleep 0.1       -- sleep a bit
say "main posts"
event~post              -- now post the event semaphore
say "main ends"

::class Task
::method waitFor
    reply   -- returns to caller, remaining code runs on new thread
    use strict arg event, name  -- fetch event semaphore and name
    say name "waits"
    event~wait          -- wait until semaphore gets posted
    say name "runs"

::options trace all    -- setup the entire program to be traced