/**  The public routine kickOf which will run the supplied script on
     nrThreads separate threads.

     @param script the script to run/execute on a separat thread and can be
     <ul>
     <li>a Routine object
     <li>an array of Rexx statements
     <li>a string (will get turned into an array)
     </ul>
     @param nrThreads the number of threads on which the script should execute,
            defaults to 3

*/

::routine kickOff public
  use strict arg script="say 'hello, world at:' .dateTime~new", nrThreads=3

  if \script~isA(.routine) then
     script=.routine~new("", script)

  runner=.Runner~new -- create an instance
  do i=1 to nrThreads
     runner~run(script)
  end

::class  runner         -- define a class
::method run unguarded  -- allow to run concurrently
  use arg script    --  get routine object
  reply             -- return, remainder executes on new thread
  script~call       -- now run the routine on the a thread
