w=.waiter~new -- create an instance
do i=1 to 5
   w~wait(i)  -- invoke instance method
end
say "Waiting for counter to drop to 0..."
.waiter~wait  -- invoke class method
say "--- All done ---"

/* Waiter */
::class waiter
::method init class  -- guarded class method
   expose counter
   counter=0         -- set initial value
::method up   class  -- guarded class method
   expose counter
   counter=counter+1 -- increase counter
::method down class  -- guarded class method
   expose counter
   counter=counter-1 -- decrease counter
::method wait class  -- guarded class method
   expose counter
   guard on when counter=0  -- wait until counter drops to 0

::method wait unguarded -- instance method
   a=random(1,6)  -- get a number between 1 and 6
   reply          -- now concurrency starts
   parse arg n    -- get invocation number
   .waiter~up     -- increase counter
   if n<>'' then say 'Waiter' n 'waiting' a 'seconds'
   call syssleep a   -- sleep a few seconds
   if n<>'' then say 'Waiter' n 'finished'
   .waiter~down   -- decrease counter