call BsfCommandHandler "add", "JDOR",,
                       .bsf~new("org.oorexx.handlers.jdor.JavaDrawingHandler")
signal on syntax
Parse Arg name .
If name='' | name='?' Then
  Call help
g.arrOutput = .array~new
g.arrError  = .array~new
   -- set default environment to JDOR with redirection
address jdor  with output append using (g.arrOutput) error append using (g.arrError)

data=triresult()name'_data.txt'
If sysFileExists(data)=0 Then Do
  Say 'File' data 'does not exist!'
  Call help
  End
Call get_size
xrange=g.0xmx-g.0xmi
yrange=g.0ymx-g.0ymi
sz=max(xrange,yrange)
--Say sz
g.0shiftx=(sz-xrange)%2
g.0shifty=(sz-yrange)%2
--Say xrange yrange sz g.0shiftx
rh.=sz+10
new (sz+10) (sz+10) TYPE_INT_RGB             -- create new bitmap
--scale 0.8
g.0xmin=999
g.0ymin=999
g.0xmax=0
g.0ymax=0
stroke s3 3

background white
clearRect rh. rh. -- this will use the current background color for clearing
l=linein(data)
parse Var l . . ax ay bx by cx cy
head=' Triangle' name 'A('ax'/'ay')' 'B('bx'/'by')' 'C('cx'/'cy')'
Do While lines(data)>0
  l=linein(data)
  l=translate(l,'   ','(/)')
  Parse Var l what col dat
  If what='P' Then Do
    Parse Var dat x y .
    Call draw_point i(x),i(y),col
    End
  If what='L' Then Do
    Parse Var dat ax ay bx by .
    Call draw_line i(ax),i(ay),i(bx),i(by),col
    End
  If what='C' Then Do
    Parse Var dat mx my r .
    Call draw_circle i(mx),i(my),i(r),col
    End
  If what='G' Then Do
    Select
      When left(dat,2)='x=' Then Do
        Parse Var dat 'x=' gx .
        hx=gx
        gy=g.0ymin
        hy=g.0ymax
        End
      Otherwise Do
        If pos('+',dat)=0 &,
           pos('-',dat)=0 Then Do
          Parse Var dat '=' k '*x'
          d=0
          End
        Else
          Parse Var dat '=' k '*x' d .
        gy=g.0ymin
        gx=(gy-d)/(k)
        hy=g.0ymax
        hx=(hy-d)/(k)
        End
      End
--    say i(gx) i(gy) i(hx) i(hy)
    Call draw_line i(gx),i(gy),i(hx),i(hy),'s'
    End
  End

winShow                 -- show frame

Parse Value (g.0xmin-5) (g.0xmax+5) (g.0ymin-5) (g.0ymax+5) With ax cx ay cy
Call draw_line ax,ay,ax,cy,'s'
Call draw_line ax,cy,cx,cy,'s'
Call draw_line cx,cy,cx,ay,'s'
Call draw_line cx,ay,ax,ay,'s'
Call draw_point ax,ay,'s'
Call draw_point ax,cy,'s'
Call draw_point cx,ay,'s'
Call draw_point cx,cy,'s'
goto 10 10
color black
drawString head

saveImage triresult()name'.png'
winTitle head .dateTime~new
/*
Say head
say "processed commands (canonical):"
call indent g.arrOutput
say
*/
if g.arrError~items>0 then do
  say "error/failures:"
  call indent g.arrError
  say
  end

sleep 5

Exit

draw_circle: Procedure Expose g.
Parse Arg mx,my,r,col
Call set_color(col)
goto xx(mx-r) yy(my+r)
g.0xmin=min(g.0xmin,mx-r)
g.0xmax=max(g.0xmax,mx+r)
g.0ymin=min(g.0ymin,my-r)
g.0ymax=max(g.0ymax,my+r)
drawoval r*2 r*2
goto xx(mx-2) yy(my+2); fillrect 5 5
coli=translate(col,'yywwwYYWWWs','rgsbpRGSBP*')
Call set_color(coli)
goto xx(mx-1) yy(my+1); fillrect 3 3
Return

draw_point: Procedure Expose g.
Parse Arg  x,y,col
Call set_color(col)
goto xx(x-2) yy(y+2); fillrect 5 5
coli=translate(col,'yywwwYYWWWs','rgsbpRGSBP*')
--say col '->' coli
Call set_color(coli)
goto xx(x-1) yy(y+1); fillrect 3 3
g.0xmin=min(g.0xmin,x)
g.0xmax=max(g.0xmax,x)
g.0ymin=min(g.0ymin,y)
g.0ymax=max(g.0ymax,y)
Return

draw_line: Procedure Expose g.
Parse Arg ax,ay,bx,by,col
Call set_color(col)
goto xx(ax) yy(ay)
drawline xx(bx) yy(by)
g.0xmin=min(g.0xmin,ax)
g.0xmax=max(g.0xmax,ax)
g.0ymin=min(g.0ymin,ay)
--Say         g.0ymax '-' ay
g.0ymax=max(g.0ymax,ay)
g.0xmin=min(g.0xmin,bx)
g.0xmax=max(g.0xmax,bx)
g.0ymin=min(g.0ymin,by)
g.0ymax=max(g.0ymax,by)
Return

draw_triangle: Procedure Expose g.
Parse Arg ax,ay,bx,by,cx,cy

goto ax ay
drawline xx(bx) yy(by)
drawline xx(bx) yy(by)
goto bx by
drawline xx(cx) yy(cy)
goto cx cy
drawline xx(ax) yy(ay)
goto (ax-2) (ay-2); fillrect 5 5
goto (bx-2) (by-2); fillrect 5 5
goto (cx-2) (cy-2); fillrect 5 5
color white
goto (ax-1) (ay-1); fillrect 3 3
goto (bx-1) (by-1); fillrect 3 3
goto (cx-1) (cy-1); fillrect 3 3
Return

i: Return format(arg(1),5,0)

set_color:
Parse Upper Arg col
Select
  When col='S' Then coll='black'
  When col='B' Then coll='blue'
  When col='R' Then coll='red'
  When col='G' Then coll='green'
  When col='Y' Then coll='yellow'
  When col='W' Then coll='white'
  Otherwise         coll='black'
  End
color coll
Return

get_size: Procedure Expose g. data
/***********************************************************************
* Determine the size of the BMP file to contain all picture elements
* The essential items are the circumcircle and then Hhenschnittpunkt
* which can be far outside
***********************************************************************/
Do While lines(data)>0
  l=linein(data)
  l=translate(l,'   ','()/')
  Parse Var l what col dat
  If pos('Umkreis',l)>0 Then Do
    Parse Var l . . xcc ycc r .
    xcc=i(xcc)
    ycc=i(ycc)
    r=i(r)
    End
  If pos('schnittpunkt',l)>0 Then Do
    Parse Var l . . xh yh .
    xh=i(xh)
    yh=i(yh)
    End
  End
Call lineout data

Call dbg  'xcc ycc r='xcc ycc r
Call dbg  'xcc-r='xcc-r
Call dbg  'xcc+r='xcc+r
Call dbg  'ycc-r='ycc-r
Call dbg  'ycc+r='ycc+r
Call dbg  'xh   ='xh
Call dbg  'yh   ='yh
g.0xmi=i(min(xcc-r,xh))
g.0xmx=i(max(xcc+r,xh))
g.0ymi=i(min(ycc-r,yh))
g.0ymx=i(max(ycc+r,yh))
g.0xmi=g.0xmi-12;          ; Call dbg 'g.0xmi='g.0xmi
g.0xmx=g.0xmx+12;          ; Call dbg 'g.0xmx='g.0xmx
g.0ymi=g.0ymi-12;          ; Call dbg 'g.0ymi='g.0ymi
g.0ymx=g.0ymx+12;          ; Call dbg 'g.0ymx='g.0ymx
/*
x=g.0xmi; y=k*x+d; Say x y
x=g.0xmx; y=k*x+d; Say x y
y=g.0ymi; x=(d-y)/(-k);Say x y
y=g.0ymx; x=(d-y)/(-k); Say x y
*/
Return

dbg: Return; Say arg(1);

xx: Return arg(1)-g.0xmi+g.0shiftx
yy: Return g.0ymx-arg(1)+g.0shifty+8

mkxx:
res='"('
Do i=1 To arg()
  res=res||xx(arg(i))','
  End
Return strip(res,'T',',')')"'

mkyy:
res='"('
Do i=1 To arg()
  res=res||yy(arg(i))','
  End
Return strip(res,'T',',')')"'

poly: Procedure Expose g.
Parse Arg t2
Say t2
t2=translate(t2,'0123456789.-','0123456789.-'xrange('00'x,'ff'x))
Say t2
lst.='"('
Do i=1 To words(t2)
  j=(i-1)//2+1
  w=word(t2,i)
  If i//2=1 Then w=xx(w)
            Else w=yy(w)
  lst.j=lst.j||w','
  End
lst.1=strip(lst.1,'T',',')')"'
lst.2=strip(lst.2,'T',',')')"'
poly=lst.1 lst.2 (i-1)%2
Say poly
Return poly


help:
  Say 'After "rexx tri name ..." - see "rexx tri ?" fot details'
  Say 'you can use "rexx trin name" to create thr same picture with the circles'
  Exit

syntax:
   say 'SYNTAX error'
   say Condition('o')
   raise propagate
::requires "bsf.cls"   -- makes routine addJdorHandler([environmentName]) available

::routine indent
  use strict arg arr
  tab="09"x
  len=arr~items~length  -- get lenght of highest number
  do counter c item over arr
     say tab c~right(len)":" pp(item)
  end
