/* REXX ****************************************************************
* Create a BMP file showing triangle circles and lines
* 20220726 Creation of an HTML file
***********************************************************************/
triresult=triresult()
If sysfileexists(triresult)=0 Then Do
  Say 'Directory' triresult 'does not exist.'
  Say 'Please use rex triset to establish a valid output directory.'
  Exit
  End
Signal On Halt
Signal On Novalue
Signal On Syntax
Call time 'R'
Parse Arg args
Parse Var args arg ',' steiner .
Parse Var arg name m n ddx ddy .
If name='?' | name='' Then Do
  Say 'After rexx tric name x1 y1 x2 y2 x3 y3 which creates name_data.data'
  Say 'rexx trid name <m <n> >  creates name_m.bmp or name_m_n.bmp using name_data.data.'
  Say 'If no size (m) is specified, the size of the BMP file is determined automatically'
  Say 'and trimerge.rex is used to create file name.html which gets immediately displayed.'
  Say 'If a size (m) is specified, the generated BMP file is displayed.'
  Say 'rexx trid name m n g.0ddx g.0ddy lets you specify horizontal and vertical sizes and shifts.'
  Exit
  End
If ddx='' Then
  Parse Value 0 0 with ddx ddy
data=triresult()name'_data.txt'
If chars(data)=0 Then Do
  Say 'File' data 'not found'
  Exit
  End

Call init

g.0name=name
g.0zz=0             /* fill pixels in z.i.j and output pixel by pixel */
g.0zz=1             /* fill lines z.i using overlay and output lines  */
If m='' Then
  Call get_size
Else Do
  g.0m=m
  If n='' Then
    Parse Value m 0 0 with g.0n g.0ddx g.0ddy
  Else Do
    g.0n=n
    If ddx>0 Then g.0ddx=ddx
    If ddy>0 Then g.0ddy=ddy
    End
  End
hor=g.0m*8
ver=g.0n*8
g.0hor=hor
/* s is the header of the BMP file */
s='424d4600000000000000360000002800000038000000280000000100180000000000'X
s=s'1000000000000000000000000000000000000000'x
s=overlay(lend(hor),s,19,4) /* insert horizontal size                */
s=overlay(lend(ver),s,23,4) /* insert vertical size                  */
If g.0zz Then Do
  zz.='**'copies(g.0white,hor)
  g.0zzlen=length(zz.)
  End
Else
  z.=g.0white                 /* initalize all pixels in white         */
z.0=ver+8                   /* the number of lines                   */
g.0ymax=z.0

If n=m Then
  pict=triresult()name'_'g.0m         /* the name of the BMP file to be created */
Else
  pict=triresult()name'_'g.0m'_'g.0n
pict=pict||'_'steiner'.bmp'
Call sysfiledelete pict

Do While lines(data)>0      /* Now read all lines from nama_data.data */
  l=linein(data)
  -- Say l
  typ=word(l,1)
  l=translate(l,'   ','()/')
  g.0euler=0
  Select
    When typ='L' Then Do    /* A line is defined by its end points    */
      Parse Var l . col x1 y1 x2 y2 . /* and the color to be used     */
      If length(col)=2 Then           /* a size may be given          */
        Parse Var col col +1 hi       /* xtract color and size        */
      Else                            /* otherwise                    */
        hi=''                         /* no highlighting              */
      x1=format(x1,6,0)               /* coordinates -> integers      */
      y1=format(y1,6,0)
      x2=format(x2,6,0)
      y2=format(y2,6,0)
      Call line x1,y1,x2,y2,color(col),hi  /* draw the line           */
      End
    When typ='C' Then Do    /* A circle is defined by center & radius */
      Parse Var l . col xm ym r .
      If steiner<>'S' Then
        Call circle xm,ym,r,color(col)/* draw the circle            */
      If g.0auto=0 Then Do            /* no sizing was done           */
        g.0xmi=min(g.0xmi,xm-r)
        g.0xmx=max(g.0xmx,xm+r)
        g.0ymi=min(g.0ymi,ym-r)
        g.0ymx=max(g.0ymx,ym+r)
        End
      End
    When typ='S' Then Do    /* Steiner ellipses                       */
      If steiner='S' |,
         steiner='A' Then Do
        Parse Var l . col sx sy scx scy abx aby
        Call steiner col,sx,sy,scx,scy,abx,aby
        End
      End
    When typ='G' Then Do    /* Euler's line is defined by k and d     */
      g.0euler=1
      Parse Var l . col gg
      If left(gg,2)='y=' Then Do
        Parse Var l . col 'y=' k 'x' d .
        If pos('*',l)=0 Then
          k=k||1
        Else
          k=strip(k,,'*')
        If datatype(d)<>'NUM' Then d=0
        End
      If pos('x=',l)>0 Then Do
        Parse Var l . col 'x=' x1 .
        x1=format(x1,6,0)
        y1=format(g.0ymi-200,8,0)
        y2=format(g.0ymx+200,8,0)
        Call line x1,y1,x1,y2,color(col)
        Iterate
        End
      -- Say g.0xmi g.0xmx g.0ymi g.0ymx
      Parse Value (g.0xmi-20) (g.0xmx+20) With x1 x2
      y1=format(k*x1+d,8,0)
      y2=format(k*x2+d,8,0)
      If inrange(g.0ymi-200,y1,g.0ymx+20) &,
         inrange(g.0ymi-200,y2,g.0ymx+20) Then
        Call line x1,y1,x2,y2,color(col)
      Else Do
        Parse Value (g.0ymi-200) (g.0ymx+200) With y1 y2
        x1=format((y1-d)/k,8,0)
        x2=format((y2-d)/k,8,0)
        If inrange(g.0xmi-20,x1,g.0xmx+20) &,
           inrange(g.0xmi-20,x2,g.0xmx+20) Then
          Call line x1,y1,x2,y2,color(col)
        End
      End
    When typ='P' Then Do    /* A point is defined by its coordinates  */
      Parse Var l . col xp yp .
      x1=format(xp,6,0)
      y1=format(yp,6,0)
      If g.0auto=0 Then Do            /* no sizing was done           */
        g.0xmi=min(g.0xmi,x1)
        g.0xmx=max(g.0xmx,x1)
        g.0ymi=min(g.0ymi,y1)
        g.0ymx=max(g.0ymx,y1)
        End
      Call store x1 y1 color(col) '/' l
      End
    When typ='*' Then       /* To be ignored                          */
      Iterate
    End
  End

If g.0auto=0 Then Do                  /* no sizing was done           */
  g.0xmi=format(g.0xmi,6,0)           /* values -> integers           */
  g.0xmx=format(g.0xmx,6,0)
  g.0ymi=format(g.0ymi,6,0)
  g.0ymx=format(g.0ymx,6,0)
  End

/* Draw frame */
If g.0auto=0 Then Do
  Parse Value (g.0xmi-4) (g.0ymi-12) With g.0xmi g.0ymi
  Parse Value (g.0xmi-4) (g.0ymx+12) With g.0xmi g.0ymx
  Parse Value (g.0xmx+4) (g.0ymi-12) With g.0xmx g.0ymi
  Parse Value (g.0xmx+4) (g.0ymx+12) With g.0xmx g.0ymx
  End

Call stp g.0xmi,g.0ymi,g.0black
Call stp g.0xmi,g.0ymx,g.0black
Call stp g.0xmx,g.0ymi,g.0black
Call stp g.0xmx,g.0ymx,g.0black
Call line g.0xmi,g.0ymi,g.0xmi,g.0ymx,g.0black
Call line g.0xmi,g.0ymi,g.0xmx,g.0ymi,g.0black
Call line g.0xmi,g.0ymx,g.0xmx,g.0ymx,g.0black
Call line g.0xmx,g.0ymi,g.0xmx,g.0ymx,g.0black

Call points                /* Draw all points                        */

Call charout pict,s

Do i=1 To z.0
  If g.0zz Then
    Call charout pict,substr(zz.i,3,g.0zzlen-2)
  Else Do
    Do j=1 To hor
      Call charout pict,z.i.j
      End
    End
  End
Call lineout pict

ee=time('E')
-- Say ee 'elapsed'
Call lineout  triresult()'trid_times.txt',left(g.0name,8) g.0zz format(ee,2,4) 'seconds'
Parse Var pict pn '.'
If g.0auto Then Do        /* Automatc sizing took place               */
  Call trimerge pn,steiner/* Create HTML file                         */
  triresult()name'_'steiner'.html'             /* Display it                               */
  End
Else                      /* Otherwise                                */
  pict              /* Display the picture                      */
Exit

stp: Procedure  Expose points.
/***********************************************************************
* Store point data
***********************************************************************/
Parse Arg xp,yp,color
x1=format(xp,6,0)
y1=format(yp,6,0)
Call store x1 y1 color
Return

lend:
/***********************************************************************
* Convert an integer to the form needed in the BMP header
***********************************************************************/
Return reverse(d2c(arg(1),4))

line: Procedure Expose z. zz. g. xmax ymax m n  ddx ddy l  sigl
/***********************************************************************
* Draw a line
***********************************************************************/
Parse Arg x0, y0, x1, y1, color, hi
-- say '>> line  ' x0'/'y0 x1'/'y1   'sigl='sigl
If x0=x1 & y0=y1 Then Do
  -- Say 'no line' x0'/'y0 x1'/'y1
  Return
  End
If color='' Then color=g.0black
If hi>3 Then
  yd=3
Else
  yd=1
--Say      'line'  x0  y0  x1  y1
sx=sign(x1-x0)
sy=sign(y1-y0)
cnt.=0
Select
  When x1=x0 Then Do
    Do y=y0 To y1 By sy
      x=x0
      Call dot
      End
    End
  When y1=y0 Then Do
    Do x=x0 To x1 By sx
      y=y0
      Call dot
      End
    End
  Otherwise Do
    k=(y1-y0)/(x1-x0)
    Do x=x0 To x1 By sx
      y=k*(x-x0)+y0
      y=intg(y)
      Call dot
      End
    Do y=y0 To y1 By sy
      x=(y-y0)/k+x0
      x=intg(x)
      Call dot
      End
    End
  End
Return

dot: Procedure Expose x y color  z. zz. g.
Do xx=x-1 To x+1
  Do yy=y-1 To y+1
  --  say xx yy
    Call set yy,xx,color
    End
  End
Return

intg: Return strip(format(arg(1),6,0))

circle:
/***********************************************************************
* Draw the circle and store the center
***********************************************************************/
Parse Arg xm,ym,r,color
-- Say '>> Circle' xm'/'ym 'r='r
do w=0 To 360 By 0.5
  x=format(xm+r*rxcalccos(w,,'D'),6,0)
  y=format(ym+r*rxcalcsin(w,,'D'),6,0)
  Call ovl x,y,color
  End
Call store format(xm,6,0) format(ym,6,0) color
Return

steiner:
/***********************************************************************
* Draw both Steiner Ellipses
***********************************************************************/
-- Say '>> Steiner Ellipses'
Parse Arg col,sx,sy,scx,scy,abx,aby
do w=0 To 360 By 0.5
  dx=scx*rxcalccos(w,,'D')+abx*rxcalcsin(w,,'D')/rxcalcsqrt(3)
  dy=scy*rxcalccos(w,,'D')+aby*rxcalcsin(w,,'D')/rxcalcsqrt(3)
  x=format(sx+dx,6,0)
  y=format(sy+dy,6,0)
  Call ovl x,y,g.0black
  x=format(sx+dx/2,6,0)
  y=format(sy+dy/2,6,0)
  Call ovl x,y,g.0black
  End
Return

ovl: Procedure Expose z. zz. g. sigl  l
/***********************************************************************
* Put color pixels into z.y and surroundings
***********************************************************************/
Parse Arg x,y,color,hi
If hi='' Then
  Parse Value '3 1 1' With hi xd yd
Else
  Parse Value hi '1 3' With hi xd yd
do xx=x-1 To x+1
  Do yy=y-1 To y+1
    call set yy,xx,color
    End
  End
Return

store:
/***********************************************************************
* Store point data
***********************************************************************/
z=points.0+1
points.z=arg(1)
points.0=z
Return

points: Procedure Expose z. zz. g. points.
/***********************************************************************
* At last draw all points that have been stored
***********************************************************************/
Do i=1 To points.0
  Parse Var points.i xm ym color '/' l
  x=format(xm,6,0)
  y=format(ym,6,0)
  Call point x,y,color
  End
Return

point: Procedure Expose z. zz. g. sigl
/***********************************************************************
* At last draw all points that have been stored
***********************************************************************/
  Parse Arg x,y,color
-- Say '>> Point ' xm'/'ym
  color=strip(color)
  Do yy=y-6 To y+6
    Do xx=x-4 To x+4
      Call set yy,xx,color
      End
    End
  Select
    When color=g.0red Then colori=g.0yellow
    When color=g.0green Then colori=g.0yellow
    When color=g.0black Then colori=g.0white
    When color=g.0blue  Then colori=g.0white
    When color=g.0pink  Then colori=g.0white
    Otherwise                colori=g.0black
    End
  Do yy=y-3 To y+3
    Do xx=x-2 To x+2
      Call set yy,xx,colori
      End
    End
  Return

color: Procedure Expose g.
/***********************************************************************
* Translate color code to RGB.string
***********************************************************************/
Parse Arg c
Select
  When c='r' Then Return g.0red
  When c='g' Then Return g.0green
  When c='b' Then Return g.0blue
  When c='s' Then Return g.0black
  When c='z' Then Return g.0black
  When c='m' Then Return g.0magen
  When c='w' Then Return g.0white
  When c='y' Then Return g.0yellow
  When c='p' Then Return g.0pink
  End

get_size: Procedure Expose g. data steiner
/***********************************************************************
* Determine the size of the BMP file to contain all picture elements
* The essential items are the circumcircle and then Hhenschnittpunkt
* which can be far outside
***********************************************************************/
g.0auto=1
Do While lines(data)>0
  l=linein(data)
  Parse Var l typ col dat
  l=translate(l,'   ','()/')
  Select
    when pos('Umkreis',l)>0 Then Do
      Parse Var l . . xcc ycc r .
      xcc=format(xcc,6,0)
      ycc=format(ycc,6,0)
      r=format(r,6,0)
      End
    When pos('schnittpunkt',l)>0 Then Do
      Parse Var l . . xh yh .
      xh=format(xh,6,0)
      yh=format(yh,6,0)
      End
    When typ='S' & pos(steiner,'AS')>0 Then Do
      Parse Var dat sx sy scx scy abx aby
      stmin.=999999
      stmax.=-999999
      do w=0 To 360 By 0.5
        dx=scx*rxcalccos(w,,'D')+abx*rxcalcsin(w,,'D')/rxcalcsqrt(3)
        dy=scy*rxcalccos(w,,'D')+aby*rxcalcsin(w,,'D')/rxcalcsqrt(3)
        x=sx+dx
        y=sy+dy
        stmin.0x=min(stmin.0x,x)
        stmax.0x=max(stmax.0x,x)
        stmin.0y=min(stmin.0y,y)
        stmax.0y=max(stmax.0y,y)
        End
      End
    Otherwise
      Nop
    End
  End
Call lineout data

Call dbg  'xcc ycc r='xcc ycc r
Call dbg  'xcc-r='xcc-r
Call dbg  'xcc+r='xcc+r
Call dbg  'ycc-r='ycc-r
Call dbg  'ycc+r='ycc+r
Call dbg  'xh   ='xh
Call dbg  'yh   ='yh
If pos(steiner,'AC')>0 Then Do
  g.0xmi=min(xcc-r,xh)
  g.0xmx=max(xcc+r,xh)
  g.0ymi=min(ycc-r,yh)
  g.0ymx=max(ycc+r,yh)
  End
Else Do
  g.0xmi=xh
  g.0xmx=xh
  g.0ymi=yh
  g.0ymx=yh
  End
If pos(steiner,'AS')>0 Then Do
  g.0xmi=min(g.0xmi,stmin.0x)
  g.0xmx=max(g.0xmx,stmax.0x)
  g.0ymi=min(g.0ymi,stmin.0y)
  g.0ymx=max(g.0ymx,stmax.0y)
  End

g.0xmi=intg(g.0xmi)
g.0xmx=intg(g.0xmx)
g.0ymi=intg(g.0ymi)
g.0ymx=intg(g.0ymx)
g.0xmi=g.0xmi-12;          ; Call dbg 'g.0xmi='g.0xmi
g.0xmx=g.0xmx+12;          ; Call dbg 'g.0xmx='g.0xmx
g.0ymi=g.0ymi-12;          ; Call dbg 'g.0ymi='g.0ymi
g.0ymx=g.0ymx+12;          ; Call dbg 'g.0ymx='g.0ymx
xrange=g.0xmx-g.0xmi      ; Call dbg 'xrange='xrange
yrange=g.0ymx-g.0ymi      ; Call dbg 'yrange='yrange
range=max(xrange,yrange)  ; Call dbg 'range ='range
g.0m=range%8+1            ; Call dbg 'g.0m  ='g.0m
g.0n=format(yrange/7,6,0) ; Call dbg 'g.0n  ='g.0n
g.0m=max(g.0m,g.0n); Call dbg 'g.0m  ='g.0m
g.0hor=g.0m*8             ; Call dbg 'g.0hor='g.0hor
g.0ver=g.0n*8             ; Call dbg 'g.0ver='g.0ver
midx=(g.0xmx+g.0xmi)%2    ; Call dbg 'midx  ='midx
midy=(g.0ymx+g.0ymi)%2    ; Call dbg 'midy  ='midy
g.0ddx=g.0m*4-midx        ; Call dbg 'g.0ddx='g.0ddx
g.0ddy=g.0n*4-midy        ; Call dbg 'g.0ddy='g.0ddy
Return

dbg:  Return

inrange: Procedure
Parse Arg lo,x,hi
lo=lo-500
hi=hi+500
Return (lo<x & x<hi)

set: Procedure Expose g. z. zz. sigl
Parse Arg i,j,color
ii=i+g.0ddy
jj=j+g.0ddx
If g.0zz Then Do
  If ii>0 & jj>0 Then Do
    If jj<=g.0hor Then
      zz.ii=overlay(color,zz.ii,jj*3,3)
    End
  End
Else
  z.ii.jj=color
Return

init: Procedure Expose g. z. zz. points.
  g.=0
  g.0xmind=999999
  g.0ymind=999999
  g.0xmis =999999
  g.0ymis =999999
  points.=0
  g.0white  ='ffffff'x
  g.0red    ='0000ff'x
  g.0green  ='00ff00'x
  g.0blue   ='ff0000'x
  g.0black  ='000000'x
  g.0yellow ='00ffff'x
  g.0pink   ='0000bb'x
  g.0magen  ='777700'x
  Return

f6: Return format(arg(1),6,0)

Novalue:
  Say 'Novalue raised in line' sigl
  Say sourceline(sigl)
  Say 'Variable' condition('D')
  Signal lookaround

Syntax:
  Say 'Syntax raised in line' sigl
  Say sourceline(sigl)
  Say 'rc='rc '('errortext(rc)')'

halt:
lookaround:
  Say 'You can look around now.'
  Trace ?R
  Nop
  Exit 12
::requires RxMath Library
::requires triangle.cls
