/**********************************************************************
* Compute miscellaneous data about a triangle
* and store data to be used by trid.rex in name_data.data
* 20220708 Walter Pachl
**********************************************************************/
Numeric Digits 12
triresult=triresult()
If sysfileexists(triresult)=0 Then Do
  Say 'Directory' triresult 'does not exist.'
  Say 'Please use rex triset to establish a valid output directory.'
  Exit
  End
Parse Arg arg
arg=strip(arg,,"'")
If arg='' Then
  arg='test 105 110 300 120 400 500'
Parse Var arg name x1 y1 x2 y2 x3 y3
g.0x1=x1
g.0y1=y1
g.0x2=x2
g.0y2=y2
g.0x3=x3
g.0y3=y3
If name='?' Then Do
  Say 'Rexx tric name x1 y1 x2 y2 x3 y3 computes triangle data'
  Say 'and stores them in name.data for trid, the drawing program'
  Say 'Thereafter'
  Say 'Rexx trid name creates name.bmp showing all circles and lines'
  Say 'All point coordinates should be in the range 1 to 500 or so'
  Exit 12
  End
If \valid(name) Then Do
  Say 'Specified name ('name') is invalid. Use alphanumeric characters!'
  Exit 12
  End

data=triresult()name'_data.txt'; Call sysfiledelete data
html=triresult()name'_html.txt'; Call sysfiledelete html
Call o '*' arg
T=.triangle~new(x1,y1,x2,y2,x3,y3)
Do i=1 To 3
  Call dbg T~E[i] T~S[i] T~M[i] T~S[i]~kxd
  End
Call o 'L s' T~E[2] T~E[3] 'Seite a' round(distpp(T~E[2],T~E[3]))
Call o 'L s' T~E[3] T~E[1] 'Seite b' round(distpp(T~E[3],T~E[1]))
Call o 'L s' T~E[1] T~E[2] 'Seite c' round(distpp(T~E[1],T~E[2]))

Say ''
Say 'Triangle' name
Say 'A' T~E[1]
Say 'B' T~E[2]
Say 'C' T~E[3]
Call o2  6 '<h2>Compute and show data about Triangle' name': A' pround(T~E[1]) 'B' pround(T~E[2]) 'C' pround(T~E[3])'</h2>'
Say ''
/***********************************************************************
* Area
***********************************************************************/
al=T~S[1]~length
bl=T~S[2]~length
cl=T~S[3]~length
s=(al+bl+cl)/2
area=rxCalcsqrt(s*(s-al)*(s-bl)*(s-cl))
If area=0 Then Do
  Say 'These points do not define a correct triange, We surrender!'
  Exit 12
  End
Say 'Triangle''s sides:'
Say 'B-C a='round(al)
Say 'C-A b='round(bl)
Say 'A-B c='round(cl)

Call o2  9 '&nbsp;&nbsp;&nbsp; <strong>BC a='round(al) 'CA b='round(bl) 'AB c='round(cl)'</strong><br>'

/***********************************************************************
* Perimeter and Area
***********************************************************************/
Say ''
Say 'Perimeter   :' round(al+bl+cl)
Say 'Area        :' round(area)
Call o2 10 '<strong>Perimeter</strong> / Umfang: <strong>'round(al+bl+cl)'</strong><br>'
Call o2 11 '<strong>Area</strong> / Flche: <strong>'round(area)'</strong><br>'

Say ''
Say 'Triangle''s angles:' /* c**2=a**2+b**2-2*a*b*cos(gamma) */
cnvf=180/rxcalcpi() -- 57.2957796
alpha=rxCalcarccos((bl**2+cl**2-al**2)/(2*bl*cl),,'R')*cnvf
beta =rxCalcarccos((al**2+cl**2-bl**2)/(2*al*cl),,'R')*cnvf
gamma=rxCalcarccos((al**2+bl**2-cl**2)/(2*al*bl),,'R')*cnvf
Say 'alpha='round(alpha,3)
Say 'beta ='round(beta,3)
Say 'gamma='round(gamma,3)
Say 'sum  ='round(alpha+beta+gamma)
Call o2 14 '&nbsp;&nbsp;&nbsp; <strong>alpha='round(alpha) 'beta ='round(beta) 'gamma='round(gamma) '</strong><br>'
/***********************************************************************
* Angle bisectors
***********************************************************************/
Say ''
Say 'Angle-bisectors:'
wsa=ws(T~E[1],T~E[3],T~E[2]); Say 'wsA' wsa~kxd
wsb=ws(T~E[2],T~E[1],T~E[3]); Say 'wsB' wsb~kxd
wsc=ws(T~E[3],T~E[1],T~E[2]); Say 'wsC' wsc~kxd
Call o2 16 '&nbsp;&nbsp;&nbsp; <strong>bsA:' wsa~kxd '</strong><br>'
Call o2 17 '&nbsp;&nbsp;&nbsp; <strong>bsB:' wsb~kxd '</strong><br>'
Call o2 18 '&nbsp;&nbsp;&nbsp; <strong>bsC:' wsc~kxd '</strong><br>'
cha=sp(wsa,T~S[1]); Call o 'L b' T~E[1] cha 'Winkelsymmetrale a'
chb=sp(wsb,T~S[2]); Call o 'L b' T~E[2] chb 'Winkelsymmetrale b'
chc=sp(wsc,T~S[3]); Call o 'L b' T~E[3] chc 'Winkelsymmetrale c'
I=sp(wsa,wsb)

/***********************************************************************
* Area and radius of inscribed cirle
***********************************************************************/
s=(al+bl+cl)/2
area=rxCalcsqrt(s*(s-al)*(s-bl)*(s-cl))
rho=rxCalcsqrt((s-al)*(s-bl)*(s-cl)/s)
Call o 'C b' I rho 'Inkreis'

/***********************************************************************
* Orthocenter
***********************************************************************/
ha=normale(T~E[1],.line~new(T~E[2],T~E[3]))
hb=normale(T~E[2],.line~new(T~E[1],T~E[3]))
hc=normale(T~E[3],.line~new(T~E[2],T~E[1]))
aha=sp(ha,T~S[1]); Call o 'L g' T~E[1] aha 'Hhe A-a' round(distpg(T~E[1],T~S[1]))
bhb=sp(hb,T~S[2]); Call o 'L g' T~E[2] bhb 'Hhe B-b' round(distpg(T~E[2],T~S[2]))
chc=sp(hc,T~S[3]); Call o 'L g' T~E[3] chc 'Hhe C-c' round(distpg(T~E[3],T~S[3]))
H=sp(ha,hb)
Call o 'L g' H T~E[1]  'Hhe A-a extended'
Call o 'L g' H T~E[2]  'Hhe B-b extended'
Call o 'L g' H T~E[3]  'Hhe C-c extended'

Call o2 21 '<strong>Orthocenter</strong> / Hhenschnittpunkt:<strong>' H '</strong><br>'

Say ''
Say 'Orthocenter :' H

/***********************************************************************
* Circumcircle
***********************************************************************/
U=.circle~new(T~E[1],T~E[2],T~E[3])
Say ''
Say 'Center of circumcircle    :' U~M
Say 'Radius                    :' round(U~r)
Call o2 24 '<strong>Circumcircle</strong> / Umkreis: <strong>'U~M 'R='round(U~r)'</strong><br>'
Call o 'C r' U~M U~r 'Umkreis'

/***********************************************************************
* Inscribed circle
***********************************************************************/
Say ''
Say 'Center of inscribed circle:' I
Say 'Radius                    :' round(rho)
Call o2 26 '<strong>Inscribed Circle</strong> / Inkreis: <strong>'I 'r='round(rho)'</strong><br>'

/***********************************************************************
* Centroid
***********************************************************************/
sa=.line~new(T~E[1],T~M[1]); Call o 'L p' T~E[1] T~M[1] 'Schwerlinie A-a'
sb=.line~new(T~E[2],T~M[2]); Call o 'L p' T~E[2] T~M[2] 'Schwerlinie B-b'
sc=.line~new(T~E[3],T~M[3]); Call o 'L p' T~E[3] T~M[3] 'Schwerlinie C-c'
Say ''
S=sp(sa,sb)
Say 'Centroid                  :' S
g.0sx=S~x
g.0sy=S~y

Call o2 30 '<strong>Centroid</strong> / Schwerpunkt: <strong>'S '</strong><br>'
Call o2 32 '&nbsp;&nbsp;&nbsp; mA: <strong>'sa~kxd '</strong><br>'
Call o2 33 '&nbsp;&nbsp;&nbsp; mB: <strong>'sb~kxd '</strong><br>'
Call o2 34 '&nbsp;&nbsp;&nbsp; mC: <strong>'sc~kxd '</strong><br>'

/***********************************************************************
* Steiner Ellipses
***********************************************************************/
scx=g.0x3-g.0sx
scy=g.0y3-g.0sy
abx=g.0x2-g.0x1
aby=g.0y2-g.0y1
Call o 'S' 'r' g.0sx g.0sy scx scy abx aby
al2=al**2
bl2=bl**2
cl2=cl**2
r=al2+bl2+cl2
z=rxcalcsqrt(al2**2+bl2**2+cl2**2-al2*bl2-bl2*cl2-cl2*al2)
gh=rxcalcsqrt(r+2*z)/3
kh=rxcalcsqrt(r-2*z)/3
Call o2 28 '<strong>Steiner Ellipsis</strong> / Steiner Ellipse: <strong>a='format(gh,3,3)', b='format(kh,3,3)'</strong><br>'

/***********************************************************************
* Feuerbach circle
***********************************************************************/
F=.circle~new(T~M[1],T~M[2],T~M[3])
Say ''
Say 'Center of Feuerbach Circle:' F~M
Say 'Radius                    :' round(F~r)
Call o 'C s' F~M F~r 'Feuerbachkreis'
Call o2 37 '<strong>Feuerbach Circle</strong> / Feuerbachkreis: <strong>'F~M 'r='round(F~r)'</strong><br>'

/***********************************************************************
* Euler's line
********************************************bo***************************/
Say ''
sh=.line~new(S,H)
su=.line~new(S,U~M)
sf=.line~new(S,F~M)
uh=.line~new(U~M,H)
Call o2 40 '<strong>Euler''s Line</strong> / Eulersche Gerade: <strong>'su~kxd '</strong><br>'
Say     'Euler''s Line:' su~kxd
/*
Say 'S-U' sh~kxd
Say 'S-H' su~kxd
Say 'S-F' sf~kxd
Say 'U-H' uh~kxd
Pull .
*/
If datatype(k)='NUM' Then
  Call o 'G m' su~k su~d    'Eulersche Gerade'
Else
  Call o 'G m' su~kxd       'Eulersche Gerade'
Call o 'P p' S~x S~y      'Schwerpunkt'
Call o 'P g' H~x H~y      'Hhenschnittpunkt'
Call o 'P s' T~E[1]       'A'
Call o 'P s' T~E[2]       'B'
Call o 'P s' T~E[3]       'C'
Call o 'P b' I            'Inkreismittelpunkt'
Call lineout data
Exit 0
o: Return lineout(data,arg(1))
o2   : Return lineout(html,arg(1))

pround:
Parse Arg s
Parse Var s '(' x '/' y ')'
Return space('('format(x,6,0)'/'format(y,6,0)')',0)

valid: Procedure
Parse Arg n
valid='abcdefghijklmnopqrstuvwxyz'
valid=valid||translate(valid)'1234567890'
return verify(n,valid)=0
nx=translate(n,copies('*',length(valid)),valid)
nx=translate(nx,' *','* ')
Return nx=''

::REQUIRES triangle.cls
