::CLASS triangle public inherit stringlike
::ATTRIBUTE E   -- Vertices
::ATTRIBUTE S   -- Edges
::ATTRIBUTE M   -- Midpoints of the edges
::METHOD init   PUBLIC
  Expose E S M
  Use Arg ax,ay,bx,by,cx,cy
  -- sf= .context~stackframes
  -- say sf[1]~line
  -- say sf[1]~executable~package~name
  E=(.point~new(ax,ay),.point~new(bx,by),.point~new(cx,cy))
  M=(.point~new((bx+cx)/2,(by+cy)/2),,
   .point~new((cx+ax)/2,(cy+ay)/2),,
   .point~new((ax+bx)/2,(ay+by)/2))
  S=(.line~new(self~E[2],self~E[3]),,
   .line~new(self~E[3],self~E[1]),,
   .line~new(self~E[1],self~E[2]))

::METHOD string PUBLIC
  Expose E
  Return E[1] E[2] E[3]

::CLASS point public inherit stringlike
::ATTRIBUTE X
::ATTRIBUTE Y
::METHOD init   PUBLIC
  Expose X Y
  Use Arg X,Y

::METHOD string PUBLIC
  Expose X Y
  Return '('round(self~X)'/'round(self~Y)')'  -- text: (x/y)

::CLASS line public inherit stringlike
::ATTRIBUTE A
::ATTRIBUTE B
::METHOD init   PUBLIC
  Expose A B
  Use Arg A,B

::METHOD string PUBLIC
  Expose A B
  Return self~A'-'self~B            -- text: (ax/ay)-(bx/by)

::METHOD length PUBLIC
  Expose A B
  Return distpp(self~A,self~B)

::METHOD kxd    PUBLIC
  Expose A B
  ax=A~x; ay=A~y; bx=B~x; by=B~y
  Select
  When ax=bx Then Do
    res='x='||round(ax)
    Call tri_dbg ax ay bx by res
    End
  When ay=by Then
    res='y='round(ay)
  Otherwise Do
    k=(by-ay)/(bx-ax)
    d=round(ay-k*ax)
    Select
      When d>0 Then d='+'d
      When d=0 Then d=''
      Otherwise Nop
      End
    Select
      When k=1 Then
        res='y=x'd
      When k=-1 Then
        res='y=-x'd
      Otherwise
        res='y='round(k)'*x'd
      End
    End
  End
  Return res

::METHOD k      PUBLIC
  Expose A B
  ax=A~x; ay=A~y; bx=B~x; by=B~y
  If ax=bx Then
    res='infinite'
  Else
    res=(by-ay)/(bx-ax)
  Return res

::METHOD d      PUBLIC
  Expose A B
  ax=A~x; ay=A~y
  If self~k='infinite' Then
    res='indeterminate'
  Else
    res=round(ay-ax*self~k)
  Return res

::CLASS circle public inherit stringlike
::ATTRIBUTE M
::ATTRIBUTE r
::METHOD init   PUBLIC
  Expose M r
  Use strict Arg A,B,C=.nil
  Call tri_dbg 'circle~new'
  If datatype(B)='NUM' Then Do --assume M and r were supplied as arguments
    M=A                        -- center
    r=B                        -- radius
    End
  Else Do
    g=.line~new(A,B)           -- one side of the triangle
    h=.line~new(A,C)           -- another side of the triangle
    M=sp(ss(g),ss(h))          -- cut their perpendicular bisectors
    If M=.nil Then
      Say a',' b',' C 'don''t define a circle'
    Else
      r=distpp(A,M)            -- radius
    End

::METHOD string PUBLIC
  Expose M r
  Call tri_dbg 'M='M
  Call tri_dbg 'r='r
  Return 'M='M 'r='r         -- text: M(x,y) r=r

::CLASS "Stringlike" PUBLIC MIXINClass object

::ROUTINE ss      PUBLIC --Compute the perpendicular bisector of a line segment
/***********************************************************************
* Compute the perpendicular bisector of a line segment
***********************************************************************/
  Use Arg g
  -- sf= .context~stackframes
  -- say sf[1]~line
  -- say sf[1]~executable~package~name
  ax=g~A~x; ay=g~A~y; bx=g~B~x; by=g~B~y
  If ax=bx & ay=by Then Do
    Say g~A'-'g~B 'isn''t a line segment'
    Return .nil
    End
  mx=(ax+bx)/2
  my=(ay+by)/2
  vx=bx-ax
  vy=by-ay
  Select
    When vx=0 Then Parse Value 1 0 With sx sy
    When vy=0 Then Parse Value 0 1 With sx sy
    Otherwise Do
      sx=vy
      sy=-vx
      End
    End
  M=.point~new(mx,my)
  M1=.point~new(mx+10*sx,my+10*sy)
  res=.line~new(M,M1)
  Return res

::ROUTINE cs      PUBLIC --Compute the crossing points of circle c and line g
/***********************************************************************
* Compute crossing points of circle c and line g
***********************************************************************/
  Use Arg c,g
  mx=c~M~x
  my=c~M~y
  r =c~r
  kxd=g~kxd
  Call tri_dbg '>>>' mx my r kxd
  Select
    When pos('x',kxd)=0 Then Do   /* y=nnn */
      k=0
      Parse Value kxd With '=' d
      End
    When pos('y',kxd)=0 Then Do   /* x=nnn */
      k=.nil
      Parse Value kxd With '=' x .
      End
    When pos('*x',kxd)>0 Then Do
      Parse Value kxd With '=' k '*x' d
      If k='' Then k=1
      If d='' Then d=0
      End
    When pos('-x',kxd)>0 Then Do
      Parse Value kxd With '='  '-x' d
      k=-1
      End
    Otherwise Do
      Parse Value kxd With '='  'x' d
      k=1
      End
   End

  If k<>.nil Then Do
    Call tri_dbg 'k='k 'd='d
    a=(1+k**2)
    b=(-2*mx+2*k*(d-my))
    c=(mx**2+(d-my)**2-r**2)
    Call tri_dbg '>>>'a b c
    Parse Value qgl(a,b,c) with x1 x2
    If pos('i',x1)>0 Then Do
      Say 'no intersection'
      Return (.nil,.nil)
      End
    y1=k*x1+d
    y2=k*x2+d
    Call tri_dbg x1 y1
    Call tri_dbg x2 y2
    End
  Else Do
    dd=r**2-(x-mx)**2
    If dd<0 Then Do
      Say 'no intersection'
      Return (.nil,.nil)
      End
    x1=x
    x2=x
    d=rxCalcsqrt(dd)
    y1=my+d
    y2=my-d
    Call tri_dbg x1 y1
    Call tri_dbg x2 y2
    End
  S1=.point~new(x1,y1)
  S2=.point~new(x2,y2)
  Call tri_dbg 'r='r
  Call tri_dbg rxCalcsqrt((x1-mx)**2+(y1-my)**2)
  Call tri_dbg rxCalcsqrt((x2-mx)**2+(y2-my)**2)
  Return (S1,S2)

::ROUTINE sp      PUBLIC --Compute the crossing point of the lines g and h
/***********************************************************************
* Compute crossing point of the lines g and h
***********************************************************************/
  Use Arg g,h
  ax=g~A~x; ay=g~A~y; bx=g~B~x; by=g~B~y
  cx=h~A~x; cy=h~A~y; dx=h~B~x; dy=h~B~y
  z=(cx-ax)*(dy-cy) - (cy-ay)*(dx-cx)
  n=(bx-ax)*(dy-cy) - (by-ay)*(dx-cx)
  If n=0 Then Do
    If z=0 Then
      Say 'lines are identical' z'/'n ax ay bx by cx cy dx dy
    Else
      Say 'lines are parallel' z'/'n ax ay bx by cx cy dx dy
    res=.nil
    End
  Else Do
    t=z/n
    x=ax+(bx-ax)*t
    y=ay+(by-ay)*t
    Call tri_dbg x y
    res=.point~new(x,y)
    End
  Return res

::ROUTINE normale PUBLIC --Compute the normale from point P to line g
/***********************************************************************
* Compute the normale from point P to line g
***********************************************************************/
  Use Arg P,g
  ax=g~A~x; ay=g~A~y; bx=g~B~x; by=g~B~y
  px=P~x; Py=P~y
  vx=bx-ax
  vy=by-ay
  Q=.point~new(Px+vy,Py-vx)
  res=.line~new(P,Q)
  Return res

::ROUTINE ws      PUBLIC --Compute the angular symmetric from point A
/***********************************************************************
* Compute the angular symmetric from point A
***********************************************************************/
  Use Arg A,B,C
  ax=A~x; ay=A~y; bx=B~x; by=B~y; cx=C~x; cy=C~y
  ebl=rxCalcsqrt((bx-ax)**2+(by-ay)**2)
  ecl=rxCalcsqrt((cx-ax)**2+(cy-ay)**2)
  A1=.point~new(ax+((bx-ax)/ebl+(cx-ax)/ecl)*10,,
                ay+((by-ay)/ebl+(cy-ay)/ecl)*10)
  res=.line~new(A,A1)
  Return res

::ROUTINE distpp  PUBLIC --Compute the distance between the points A and B
/***********************************************************************
* Compute the distance between the points A and B
***********************************************************************/
  Use Arg A,B
  ax=A~x; ay=A~y; bx=B~x; by=B~y
  res=rxCalcsqrt((bx-ax)**2+(by-ay)**2)
  Return res

::ROUTINE distpg  PUBLIC --Compute the distance from a point to a line
/***********************************************************************
* Compute the distance from a point to a line
***********************************************************************/
  Use Arg A,g
  ax=A~x; ay=A~y
  k=g~k
  If k='infinite' Then Do
    Parse Value g~kxd With 'x='gx
    res=gx-ax
    End
  Else
    res=(ay-k*ax-g~d)/rxCalcsqrt(1+k**2)
  Return abs(res)

::ROUTINE cc      PUBLIC --Compute the crossing points of circles c1 and c2
/***********************************************************************
* Compute crossing points of circles c1 and c2
**********************************************************************/
  Use Arg c1,c2
  m1=c1~M~x
  n1=c1~M~y
  r1 =c1~r
  m2=c2~M~x
  n2=c2~M~y
  r2 =c2~r
  N=(2*n1-2*n2)
  If N=0 Then Do
    x=(m2**2-m1**2+r1**2-r2**2)/(2*m2-2*m1)
    P1=.point~new(x,0)
    P2=.point~new(x,100)
    End
  Else Do
    k=(-2*m1+2*m2)/N
    d=(m1**2-m2**2+n1**2-n2**2-r1**2+r2**2)/N
    P1=.point~new(0,d)
    P2=.point~new(100,k*100+d)
    End
  g=.line~new(P1,P2)
  Call tri_dbg 'g='g
  ss=cs(c1,g)
  If ss[1]=.nil Then
    Say 'circles don''t cross each other'
  Return ss

::ROUTINE round   PUBLIC --Round a number to 3 decimal digits
/***********************************************************************
* Round a nmber to 3 decimal digits
***********************************************************************/
  Use Arg z,d
  Numeric Digits 6
  res=z+0
  If d>'' Then
    res=format(res,9,3)
  Return strip(res)

::ROUTINE qgl     PUBLIC --Solve a quadratic equation
/***********************************************************************
* Solve a quadratic equation
***********************************************************************/
  Use Arg a,b,c
  Call tri_dbg a b c
  Numeric Digits 20
  gl=a'*x**2'
  Select
    When b<0 Then gl=gl||b'*x'
    When b>0 Then gl=gl||'+'||b'*x'
    Otherwise Nop
    End
  Select
    When c<0 Then gl=gl||c
    When c>0 Then gl=gl||'+'||c
    Otherwise Nop
    End
  Call tri_dbg gl '= 0'
  d=b**2-4*a*c
  If d<0 Then Do
    i='i'
    d=abs(d)
    End
  Else
    i=''
  dd=rxCalcsqrt(d)
  If i='' Then Do
    x1=(-b+dd)/(2*a)
    x2=(-b-dd)/(2*a)
    End
  Else Do
    re=-b/(2*a)
    im=dd/(2*a)
    If im=1 Then im=''
    If re=0 Then re=''
    x1=re'+'im'i'
    x1=strip(x1,,'+')
    x2=re'-'im'i'
    end
  Call tri_dbg x1
  Call tri_dbg x2
  Return x1 x2

::ROUTINE tri_dbg PUBLIC --Show debug information
  Return
  Say arg(1)

::ROUTINE dbg     PUBLIC --Show debug information
  Say arg(1)
  Return

::ROUTINE ex      PUBLIC
  Say '*** EXIT ***'
  Say arg(1)
  Exit

::requires rxMath library
