/* The triangle package */
triresult=triresult()
If sysfileexists(triresult)=0 Then Do
  Say 'Directory' triresult 'does not exist.'
  Say 'Please use rex triset to establish a valid output directory.'
  Exit
  End
Parse Arg arg
Select
  When name='?' Then
    Call help
  When arg='' Then Do
    arg='test 105 110 300 120 400 500'
    Say 'Using the default data:'
    Say 'rexx tri' arg
    Say 'rexx tri ? tells you how to use tri.rex'
    End
  Otherwise
    arg=strip(strip(arg),,"'")
  End
Parse Var arg name abc
If words(abc)=7 Then Do
  steiner=word(abc,7)
  If wordpos(steiner,'A C S')=0 Then Do
    say 'Invalid mode ('steiner') must be A, C, or S'
    Exit
    End
  abc=subword(abc,1,6)
  End
Else
 steiner='C'
Call is_valid name
/* Reduce an invocation like "rexx tri name A (10/10) B (150/10) C (250/300)" */
/* to                        "rexx tri name    10 10     150 10     250 300 " */
abcn=translate(abc,'0123456789.+-','0123456789.+-'||xrange('00'X,'FF'X))
If words(abcn)<>6 Then
  Call ex '6 numbers needed'
cn='ax ay bx by cx cy'
Do i=1 To 6
  If datatype(word(abcn,i))<>'NUM' Then
    Call ex word(cn,i)':' word(abcn,i) 'is not a number'
  End
rc=tric(name abcn)          /* compute all data about the triangle      */
If rc=0 Then
  Call trid name ',' steiner    /* create a picture of the triangle     */
                            /* and call trimerge to create an html file */
Exit
ex:
Say 'Erroneous invocation!!!'
Say arg(1)
Say copies('-',72)
help:
  Say ''
  Say 'Rexx tri name ax ay bx by cx cy [ C | S | A ]'
  Say '  ax ay bx by cx cy are the coordinates of three points, A, B, and C)'
  Say '  C S A: draw circles, Steiner ellipsis, or all, respectively'
  Say 'All point coordinates should be in the range 50 to 500 or so'
  Say 'calls tric name ax ay bx by cx cy which computes triangle data'
  Say 'and stores them in name_data.data for trid, the drawing program'
  Say 'Thereafter,'
  Say 'trid name creates name_mm.bmp showing all circles and lines.'
  Say 'trimerge name, finally, creates name.html showing all data and the picture'
  Exit
is_valid: Procedure
Parse Arg s
p=verify(s,valid)
valid='abcdefghijklmnopqrstuvwxyz'
valid=translate(valid)valid||'1234567890_-'
If verify(s,valid)>0 Then
  Call ex 'name ('s') is invalid. Bad character:' substr(s,p,1)
Return
