call BsfCommandHandler "add", "JDOR", .bsf~new("org.oorexx.handlers.jdor.JavaDrawingHandler")
Parse Arg arg

outArr=.array~new
errArr=.array~new
address jdor with output append using (outArr),  -- set default environment to JDOR
                  error append using (errArr)
target=triresult()        -- Determine where the pictures are to be stored
new 500 500   "TYPE_INT_ARGB"                    -- create new bitmap
background white
clearRect 500 500
pi=0
stroke s2 2
fontstyle BOLD
fontsize 36
font large "Monospaced"
fontsize 24
font mono "Monospaced"

c=.point~new(0,0)
d=.point~new(200,0)
r=2*rxCalcsqrt(3)*100
c1=.circle~new(c,r);  -- Call draw_circle 1r 0 0 r
c2=.circle~new(d,r);  -- Call draw_circle 1r 200 0 r
ss=cc(c1,c2)
a=ss[1]
x=200
c3=.circle~new(a,x);  -- Call draw_circle 1r a~x a~y x
c4=.circle~new(c,x);  -- Call draw_circle 1r c~x c~y x
c5=.circle~new(d,x);  -- Call draw_circle 1r d~x d~y x
ss=cc(c3,c4); g=ss[1]; b=ss[2]
ss=cc(c3,c5); e=ss[1]; f=ss[2]
Call dbg 'a=' a       -- (100.000/331.662)
Call dbg 'b=' b       -- (-45.772/194.730)
Call dbg 'c=' c       -- (0.000/0.000)
Call dbg 'd=' d       -- (200.000/0.000)
Call dbg 'e=' e       -- (245.901/194.867)
Call dbg 'f=' f       -- (54.207/136.976)
Call dbg 'g=' g       -- (145.610/136.933)

Call draw_string 110,90,'2'               -- label all points
color green; fillpolygon poly(a b c d e)   -- green pentagon
color black; drawpolygon poly(a b c d e a) -- frame it
color black; drawpolygon poly(a g b)       -- left upper triangle
color black; drawpolygon poly(b g c)       -- left lower triangle
color black; drawpolygon poly(a f e)       -- right upper triangle
color black; drawpolygon poly(e f d)       -- right lower triangle

Call save 7

Call draw_string 180, 30,'A'               -- label all points
Call draw_string  40,172,'B'
Call draw_string 100,380,'C'
Call draw_string 300,380,'D'
Call draw_string 350,172,'E'
Call draw_string 130,240,'F'
Call draw_string 250,240,'G'

Call save 7

color green; fillpolygon poly(a b c d e)   -- green pentagon
color black; drawpolygon poly(a b c d e a) -- frame it
color black; drawpolygon poly(a f e)       -- right upper triangle
color black; drawpolygon poly(e f d)       -- right lower triangle
Call draw_string 130,240,'F'

Call save 7

color black; drawpolygon poly(a   d)       -- right lower triangle

Call save 7

color green; fillpolygon poly(a b c d e)   -- green pentagon
color black; drawpolygon poly(a b c d e a) -- frame it
m=.point~new((a~x+d~x)/2,(a~y+d~y)/2)
n=.point~new((c~x+d~x)/2,(c~y+d~y)/2)
color black; drawpolygon poly(c a d)       -- center triangle
color black; drawpolygon poly(m e)         -- triangle base

stroke s1 1

--color black; drawpolygon poly(a f d)
--color black; drawpolygon poly(m f)
color black; drawpolygon poly(a n)         -- height of center triangle
Call draw_string 226,196,'M'               -- Label new points
Call draw_string 180,320,'H'
Call draw_string 196,380,'N'
arg='_'arg
txt1='H**2=12-1'
txt2='A=2*sqrt(3)+sqrt(11)'
fontstyle BOLD
fontsize 13
font mono "Monospaced"
Call draw_string 230, 20,txt1
Call draw_string 230, 40,txt2

Call save 17

Exit

save:
  Parse Arg s
  pi+=1;                        -- increment the picture count
  pic='pentagon_'pi'.png'       -- new picture name
  goto 5 450; clearrect 300 490 -- clear the area
  font large
  goto 5 480; drawstring pic    -- write name to the picture
  font mono
  winShow                       -- show the picture
  saveImage triresult()pic      -- save the current picture
  sleep s                       -- wait s seconds
  Return

draw_string: Procedure expose outarr errarr
  Parse Arg x,y,txt
  goto x y
  drawstring txt
  Return

poly: Procedure Expose g.
  Parse Arg t2
  Call dbg 't2='t2
  t2=translate(t2,'0123456789.- ','0123456789.- 'xrange('00'x,'ff'x))
  Call dbg 't2='t2
  lst.='"('
  Do i=1 To words(t2)
    j=(i-1)//2+1
    w=word(t2,i)
    If i//2=1 Then w=xx(w)    -- transform the x-value
              Else w=yy(w)    -- transform the y-value
    lst.j=lst.j||w','
    End
  lst.1=space(strip(lst.1,'T',',')')"',0) -- x-values
  lst.2=space(strip(lst.2,'T',',')')"',0) -- y-values
  poly=lst.1 lst.2 (i-1)%2
  Call dbg poly
  Return poly

xx: Return format(repl(arg(1),'','.000')+100,5,0)
yy: Return format( 360-repl(arg(1),'','.000'),5,0)

co: Return format(50*rxCalccos(arg(1),,'D'),5,0)
si: Return format(50*rxCalcsin(arg(1),,'D'),5,0)

draw_circle:
  Parse Arg col mx my r
  color black
  goto (mx-r) (my-r)
  drawOval r*2 r*2
  Return

draw_line:
Parse Arg col ax ay bx by
Call set_color col
goto ax ay
drawLine bx by
Return

set_color:
  Parse Arg cc
  Call dbg cc
  Select
    When cc='1R' Then 'color' red
    When cc='1Z' Then 'color' black
    Otherwise        'color' black
    End
  Return
dbg: Return

::requires triangle.cls
::requires "BSF.CLS"    -- get ooRexx-Java bridge
