/* REXX ****************************************************************
* Demonstrate the solution of the puzzle cat_and_mouse
***********************************************************************/
call BsfCommandHandler "add","JDOR",,
                 .bsf~new("org.oorexx.handlers.jdor.JavaDrawingHandler")
outArr=.array~new
errArr=.array~new
Address jdor with output append using (outArr) error append using (errArr)
target=triresult()        -- Determine where the pictures are to be stored
new 500 500                     -- Create a canvas
background white                -- with a white background
clearRect 500 500
stroke stroke2 2                -- define the thickness of edges and arcs
fontstyle BOLD
fontsize 36
font large "Monospaced"
fontsize 24
font mono "Monospaced"
pi=0
Parse Value '250 200 200 43' With mx my rcat rm
M=.point~new(mx,my)
cc=.circle~new(M,rcat)
cm=.circle~new(M,rm)
--trace ?R
Do i=0 to 22
clearRect 500 500
  alpha=60*i
  beta=4*alpha*rm/rcat
  pm=.point~new(mx+rm*rxCalcCos(alpha,,'D'),my+rm*rxCalcSin(alpha,,'D'))
  pc=.point~new(mx+rcat*rxCalcCos(beta,,'D'),my+rcat*rxCalcSin(beta,,'D'))
  cci=.circle~new(pc,5)
  cmi=.circle~new(pm,3)
  --Say cci cmi
  Call draw_circle 1b mx my rcat
  Call draw_circle 1r mx my rm
  Call fill_circle 1z pc~x pc~y 8
  Call fill_circle 1b pm~x pm~y 5
  Call save .3
  If i=22 Then sleep 5
  Call fill_circle 1w pc~x pc~y 8
  Call fill_circle 1w pm~x pm~y 5
  End
Exit

save:
  Parse Arg s
  pi+=1;                        -- increment the picture count
  pic='cm_'pi'.png'             -- new picture name
  goto 5 450; clearrect 200 490 -- clear the area
  font large
  goto 5 480; drawstring pic    -- write name to the picture
  font mono
  winShow                       -- show the picture
  saveImage triresult()pic      -- save the current picture
  sleep s                       -- wait s seconds
  Return

draw_circle:
  Parse Arg col cx cy r
  Call set_color Col
  goto e(cx-r) e(cy-r)
  drawOval r*2 r*2
  Return

fill_circle:
  Parse Arg col cx cy r
  Call set_color Col
  goto e(cx-r) e(cy-r)
  fillOval r*2 r*2
  Return

e: Return trunc(arg(1))

make_polygon:
  Use Arg col,what,points
  Parse Value '' With xp yp
  Do p over points
    Call dbg p
    xp=xp trunc(p~x)
    yp=yp trunc(p~y)
    End
  xp=translate(strip(xp),',',' ')
  yp=translate(strip(yp),',',' ')
  Interpret 'xa = bsf.createJavaArrayOf("int.class",'xp')'
  Interpret 'ya = bsf.createJavaArrayOf("int.class",'yp')'
  Call set_color Col
  If what='d' Then
    drawpolyline 'XA' 'YA' points~items
  Else
    fillpolygon 'XA' 'YA' points~items
  Color black                   -- reset the Color
  Return

set_color:
  Parse Upper Arg cc
  Call dbg cc
  Select
    When cc='1R' Then Color red
    When cc='1B' Then Color blue 140 140 255 -- light blue
    When cc='1Y' Then Color yellow
    When cc='1Z' Then Color black
    When cc='1W' Then Color white
    Otherwise         Color black
    End
  Return

  Exit

  dbg: Return

::requires BSF.CLS
::requires triangle.cls
