/* REXX ****************************************************************
* Demonstrate the solution of the puzzle 3k
***********************************************************************/
call BsfCommandHandler "add","JDOR",,
                 .bsf~new("org.oorexx.handlers.jdor.JavaDrawingHandler")
outArr=.array~new
errArr=.array~new
Address jdor with output append using (outArr) error append using (errArr)
target=triresult()        -- Determine where the pictures are to be stored
new 500 500                     -- Create a canvas
background white                -- with a white background
clearRect 500 500
stroke stroke2 2                -- define the thickness of edges and arcs
fontstyle BOLD
fontsize 36
font large "Monospaced"
fontsize 24
font mono "Monospaced"

pi=0                            -- picture count
p.1=.point~new(-267,0)          -- points of the framework
p.2=.point~new(200,0)
p.3=.point~new(200,350)
p.4=.point~new(0,0)
p.5=.point~new(0,200)
p.6=.point~new(200,200)
Do i=1 to 6                     -- move points into the picture
  q.i=.point~new(p.i~x+280,400-p.i~y)
  Call dbg i p.i q.i
  End
pl=.array~new(4)                -- the large triangle
ql=.array~new(3)                -- the square
Do i=1 To 3
  pl~append(q.i)
  End
pl~append(q.1)
Do i=4 To 6
  ql~append(q.i)
  End

Call make_polygon 1z,'d',pl     -- draw the large triangle
Call make_polygon 1z,'d',ql     -- draw the square

Call save 3                     -- show the picture and wait

M.1=.point~new(100,50)
M.2=.point~new(100,150)
M.3=.point~new(33,100)
M.4=.point~new(167,100)
M.5=.point~new(150,250)
M.6=.point~new(-67,67)
Do i=1 To 6
  Ma.i=.point~new(M.i~x+280,400-M.i~y)
  Call dbg i M.i Ma.i
  End
B=.point~new(100,100)
BA=.point~new(B~x+280,400-B~y)
U=.point~new(150,200)
UA=.point~new(U~x+280,400-U~y)
V=.point~new(120,290)
VA=.point~new(V~x+280,400-V~y)
W=.point~new(200,250)
WA=.point~new(W~x+280,400-W~y)

call fill_circle 1y Ma.1~x Ma.1~y 50
call draw_circle 1z Ma.1~x Ma.1~y 50
call fill_circle 1y Ma.2~x Ma.2~y 50
call draw_circle 1z Ma.2~x Ma.2~y 50
call fill_circle 1y Ma.5~x Ma.5~y 50
call draw_circle 1z Ma.5~x Ma.5~y 50
call fill_circle 1b Ma.3~x Ma.3~y 33
call draw_circle 1z Ma.3~x Ma.3~y 33
call fill_circle 1b Ma.4~x Ma.4~y 33
call draw_circle 1z Ma.4~x Ma.4~y 33
call fill_circle 1r Ma.6~x Ma.6~y 67
call draw_circle 1z Ma.6~x Ma.6~y 67

Call save 5                     -- show the picture and wait

rl=.array~new(4)                -- the first small triangle
rl~append(BA)
rl~append(Ma.2)
rl~append(Ma.4)
rl~append(BA)
Call make_polygon 1z,'d',rl     -- draw the first small triangle

Call save 7                     -- show the picture and wait
                                -- Pythagoras thereof
goto 5 140; drawstring '(2*y-b)**2+y**2)=(y+b)**2'

Call save 7                     -- show the picture and wait
                                -- the solution
goto 5 170; drawstring 'b=2*y/3'

Call save 7                     -- show the picture and wait

sl=.array~new(4)                -- the second small triangle
sl~append(UA)
sl~append(Ma.5)
sl~append(q.5)
Call make_polygon 1z,'d',sl     -- draw the second small triangle
tl=.array~new(4)                -- two radii
tl~append(VA)
tl~append(Ma.5)
tl~append(WA)
Call make_polygon 1r,'d',tl     -- draw the two radii
Call save 7                     -- show the picture and wait
goto 427 77; drawstring 'x'
                                -- Pythagoras of the upper triangle
goto 5 50; drawstring '(4*y)**2+(x+y)**2=(3*y+x)**2'

Call save 7                     -- show the picture and wait
                                -- solution for x and grand finale
goto 5 80; drawstring 'x=2*y; h=3*y'

Call save 7                     -- show the picture and wait
                                -- label the two heights
goto 486 80; drawstring 'h'
goto 286 230; drawstring 'H'
goto 5 110; drawstring 'H:h=4:3 -> r=4*y/3 -> r=2*b'

Call save 17                    -- show the picture and wait

if errArr~items>1 then do
  Call dbg; say "errors & failures:"; say errArr
  end
/*
if outArr~items>1 then do
   Call dbg; say "output (command recording):"; say outArr
   end
*/
Exit

save:
  Parse Arg s
  pi+=1;                        -- increment the picture count
  pic='3k_'pi'.png'             -- new picture name
  goto 5 450; clearrect 200 490 -- clear the area
  font large
  goto 5 480; drawstring pic    -- write name to the picture
  font mono
  winShow                       -- show the picture
  saveImage triresult()pic      -- save the current picture
  sleep s                       -- wait s seconds
  Return

draw_circle:
  Parse Arg col mx my r
  Call dbg       col mx my r
  Call set_color Col
  goto e(mx-r) e(my-r)
  drawOval r*2 r*2
  Return

fill_circle:
  Parse Arg col mx my r
  Call dbg       col mx my r
  Call set_color Col
  goto e(mx-r) e(my-r)
  fillOval r*2 r*2
  Return

e: Return trunc(arg(1))

make_polygon:
  Use Arg col,what,points
  Parse Value '' With xp yp
  Do p over points
    Call dbg p
    xp=xp trunc(p~x)
    yp=yp trunc(p~y)
    End
  xp=translate(strip(xp),',',' ')
  yp=translate(strip(yp),',',' ')
  Interpret 'xa = bsf.createJavaArrayOf("int.class",'xp')'
  Interpret 'ya = bsf.createJavaArrayOf("int.class",'yp')'
  Call set_color Col
  If what='d' Then
    drawpolyline 'XA' 'YA' points~items
  Else
    fillpolygon 'XA' 'YA' points~items
  Color black                   -- reset the Color
  Return

set_color:
  Parse Upper Arg cc
  Call dbg cc
  Select
    When cc='1R' Then Color red
    When cc='1B' Then Color blue 140 140 255 -- light blue
    When cc='1Y' Then Color yellow
    When cc='1Z' Then Color black
    Otherwise         Color black
    End
  Return

  Exit

  dbg: Return

::requires BSF.CLS
::requires triangle.cls
