-- PROGRAM-NAME: OSHIOSFlSysDtls.rex  BACKUP-REQUIRED: Yes
-- AUTHOR: Tony Dycks                 REVISED BY: Tony Dycks
-- DATE-WRITTEN: March 14, 2021       DATE-REVISED: November 10, 2021
-- LANGUAGE: Open Object Rexx         VERSION. NO.: 4.10 Or Later
-- PLATFORM: Windows/Linux (Shell)    VERSION. NO.: XP/7/10 / CentOs/Debian
--
-- DESCRIPTION:
--    Show Details of OS File System Using OSHI Java Library Using BSF4ooRexx
--
-- PRE-REQUISITE(S):
--   1. Download and Installation of Open Object Rexx Interpreter Version 4.1
--      Or Later
--   2. Download and Installation of Java SE or Open JDK Version 7 Or Later
--   3. Setup Of $JAVA_HOME Environment Variable and Addition To $PATH
--      Of Binary Directory
--   4. Download and Installation of BSF4ooRexx For OS Platform
--   5. Download and Installation of OSHI Jar File & Pre-Requisites
--      - oshi-core*.jar (Operating System Hardware Info)
--      - slf4j*.jar (Simple Logging Facility for Java)
--      - jna*.jar {linux} or jna-platform*.jar {windows} (Java Native Access)
--
-- REVISION-HISTORY:
--   Version  Change Description
--   =======  ========================================================
--     1.0    Original Implementation
--              T. Dycks -- March 14, 2021
--     1.1    Fix Documentation Errors; Changed Procedures to Routines
--              T. Dycks -- November 10, 2021
--
-- USAGE:
--   sh ./rexxj2.sh OSHIOSFlSysDtls.rex <Enter> {Linux}
--   rexxj2.cmd OSHIOSFlSysDtls.rex <Enter> {Windows}
--
-- USAGE EXAMPLE(S):
--   sh ./rexxj2.sh OSHIOSFlSysDtls.rex <Enter> {Linux}
--   rexxj2.cmd OSHIOSFlSysDtls.rex <Enter> {Windows}
--
-- REFERENCES:
--   Simple Solution -- Get File System Information in Java using OSHI library
--   Example Java program show details of operating system file storage
-- URL:
--   https://simplesolution.dev/java-get-file-system-information-oshi-library/
--

-- Mainline Code --
call banner
call main
call endmsg

-- Print Program Description banner
::routine banner
  call SysCls
  say 'OSHIOSFlSysDtls.rex'
  say 'Show Details of OS File System Using OSHI Java Library Using BSF4ooRexx'
  say 'Version 1.1'
  say 'Written By: Tony Dycks'
  say 'Revised By: Tony Dycks'
  say 'Date Written: March 14, 2021'
  say 'Last Revised: November 10, 2021'
  say

-- Print Program End Message
::routine endmsg
  say
  parse source . . thisPgm
  say '>>> End Of Program --' filespec('Name',thisPgm) '<<<'
  say

-- Mainline Routine
::routine main
  -- Get File System Info using OSHI Library
  FormatUtil = bsf.import("oshi.util.FormatUtil")
  osFileStores = .bsf~new("oshi.SystemInfo")~operatingSystem~fileSystem~fileStores

  loop fileStore over osFileStores
    say
    w=25
    say "Description"   ~left(w,'.') fileStore~description
    say "Label"         ~left(w,'.') fileStore~label
    say "Logical Volume"~left(w,'.') fileStore~logicalVolume()
    say "Mount"         ~left(w,'.') fileStore~mount()
    say "Name"          ~left(w,'.') fileStore~name()
    say "Options"       ~left(w,'.') fileStore~options()
    say "Type"          ~left(w,'.') fileStore~type()
    say "UUID"          ~left(w,'.') fileStore~UUID()
    say "Volume"        ~left(w,'.') fileStore~volume()

    say "Free Space"    ~left(w,'.') FormatUtil~formatBytes(fileStore~freeSpace)~right(9)
    say "Total Space"   ~left(w,'.') FormatUtil~formatBytes(fileStore~totalSpace)~right(9)
    say "Usable Space"  ~left(w,'.') FormatUtil~formatBytes(fileStore~usableSpace)~right(9)
  end

::requires bsf.cls   /* BSF4Rexx Class File */