-- PROGRAM-NAME: OSHIGetOS.rex        BACKUP-REQUIRED: Yes
-- AUTHOR: Tony Dycks                 REVISED BY: Tony Dycks
-- DATE-WRITTEN: August 2, 2021       DATE-REVISED: November 10, 2021
-- LANGUAGE: Open Object Rexx         VERSION. NO.: 4.10 Or Later
-- PLATFORM: Windows/Linux (Shell)    VERSION. NO.: XP/7/10 / CentOs/Debian
--
-- DESCRIPTION:
--    Get OS Name, Family, Manufacturer and Bitness Using OSHI Java Library
--
-- PRE-REQUISITE(S):
--   1. Download and Installation of Open Object Rexx Interpreter Version 4.1
--      Or Later
--   2. Download and Installation of Java SE or Open JDK Version 7 Or Later
--   3. Setup Of $JAVA_HOME Environment Variable and Addition To $PATH
--      Of Binary Directory
--   4. Download and Installation of BSF4ooRexx For OS Platform
--   5. Installation of OSHI Library and Pre-Requisites Jar Files in
--      The $JAVA_HOME Library Extensions Directory
--      - oshi-core*.jar (Operating System Hardware Info)
--      - slf4j*.jar (Simple Logging Facility for Java)
--      - jna*.jar (Java Native Access) {Linux} or ...
--      - jna-platform*.jar {Windows}
--
-- REVISION-HISTORY:
--   Version  Change Description
--   =======  ========================================================
--     1.0    Original Implementation
--              T. Dycks -- August 2, 2021
--     1.1    Fix Documentation Errors
--              T. Dycks -- November 9-10, 2021
--
-- USAGE:
--   sh ./rexxj2.sh OSHIGetOS.rex <Enter> {Linux}
--   rexxj2.cmd OSHIGetOS.rex <Enter> {Windows}
--
-- USAGE EXAMPLE(S):
--   sh ./rexxj2.sh OSHIGetOS.rex <Enter> {Linux}
--   rexxj2.cmd OSHIGetOS.rex <Enter> {Windows}
--
-- REFERENCES:
--   Simple Solution -- Get Operating System Information in Java using
--   OSHI library -- Example 1 -- Get Operating System Information
--   Example 2 -- Get Details of Operating System
--   Example 3 -- Get Details of Operating System Version
-- URL:
--   https://simplesolution.dev/java-get-operating-system-information-oshi-library/
--
if rxFuncQuery("BSF") then  /* no bsf4rexx support available yet, hence load Java */
do
   call rxFuncAdd "BsfLoadFuncs", "BSF4Rexx", "BsfLoadFuncs"
   call BsfLoadFuncs    /* load all BSF-functions                    */
   call BsfLoadJava     /* load the JVM and set up BSF4Rexx-support  */
end

if      BsfInvokedBy()=1 then say "This Rexx program was invoked by Java!"
else if BsfInvokedBy()=2 then say "This Rexx program was invoked by Rexx, JVM loaded by Rexx!"
else                          say "No JVM present, we got troubles ..."

-- Mainline Code --
call banner
call main
call endmsg
exit

-- Print Program Description banner
::routine banner
  call SysCls
  say 'OSHIGetOS.rex'
  say 'Get OS Name, Family, Manufacturer and Bitness Using OSHI Java Library'
  say 'Version 1.1'
  say 'Written By: Tony Dycks'
  say 'Revised By: Tony Dycks'
  say 'Date Written: August 2, 2021'
  say 'Last Revised: November 10, 2021'
  say
  return

-- Print Program End Message
::routine endmsg
  say
  parse source . . thisPgm
  say '>>> End Of Program --' filespec('Name',thisPgm) '<<<'
  say
  return

-- Mainline Routine
::routine main
  os = .bsf~new("oshi.SystemInfo")~operatingSystem
  say
  say "Operating System:" os~toString()
  say "Family:          " || os~family
  say "Manufacturer:    " || os~manufacturer
  say "Bitnesss:        " || os~bitness
  versninfo = os~getVersionInfo
  say "CodeName:        " || versninfo~codeName
  return

::requires bsf.cls   /* BSF4Rexx Class File */