-- PROGRAM-NAME: OSHIGetCPUNumbers.rex  BACKUP-REQUIRED: Yes
-- AUTHOR: Tony Dycks                   REVISED BY: Tony Dycks
-- DATE-WRITTEN: January 25, 2021       DATE-REVISED: November 10, 2021
-- LANGUAGE: Open Object Rexx           VERSION. NO.: 4.10 Or Later
-- PLATFORM: Windows/Linux (Shell)      VERSION. NO.: 7/10 / CentOs/Debian/Ubuntu
--
-- DESCRIPTION:
--   Get Number of Physcical and Logical CPUs using OSHI Java Library
--
-- PRE-REQUISITE(S):
--   1. Download and Installation of Open Object Rexx Interpreter Version 4.1
--      Or Later
--   2. Download and Installation of Java SE or Open JDK Version 8 Or Later
--   3. Setup Of $JAVA_HOME Environment Variable and Addition To $PATH
--      Of Binary Directory
--   4. Download and Installation of BSF4ooRexx For OS Platform
--   5. Download OSHI Core v5.4 Library Jar File; Deploy to Java Classpath
--   6. Download slf4j v1.7.27 Or Later Jar File; Deploy to Java Classpath
--   7. Download jna Library v4.5.1 Or Later Jar File; Deploy to Java Classpath
--
-- REVISION-HISTORY:
--   Version  Change Description
--   =======  ========================================================
--     1.0    Original Implementation
--              T. Dycks -- January 25, 2021
--     1.1    Fix Documentation Errors; Changed Procedures to Routines
--              T. Dycks -- November 9-10, 2021
--
-- USAGE:
--   sh ./rexxj2.sh OSHIGetCPUNumbers.rex <Enter> {Linux}
--   rexxj2.cmd OSHIGetCPUNumbers.rex <Enter> {Windows}
--
-- USAGE EXAMPLE(S):
--   sh ./rexxj2.sh OSHIGetCPUNumbers.rex <Enter> {Linux}
--   rexxj2.cmd OSHIGetCPUNumbers.rex <Enter> {Windows}
--
-- REFERENCES:
--   Simple Soluion -- Get CPU Information in Java using OSHI library
--   Example 3 Get Number of physical or logical CPUs
-- URL:
--   https://simplesolution.dev/java-get-cpu-information-oshi-library/

-- Mainline Code --
call banner
call main
call endmsg
exit

-- Print Program Description banner
::routine banner
  call SysCls
  say 'OSHIGetCPUNumbers.rex'
  say 'Get Number of Physical and Logical CPUs using OSHI Java Library'
  say 'Version 1.1'
  say 'Written By: Tony Dycks'
  say 'Revised By: Tony Dycks'
  say 'Date Written: January 25, 2021'
  say 'Last Revised: November 10, 2021'
  say

-- Print Program End Message
::routine endmsg
  say
  parse source . . thisPgm
  say '>>> End Of Program --' filespec('Name',thisPgm) '<<<'
  say

::routine getprocessorinfoall
  processor = .bsf~new("oshi.SystemInfo")~hardware~processor
  say "Number of physical packages:" processor~physicalPackageCount
  say "Number of physical CPUs:    " processor~physicalProcessorCount
  say "Number of logical CPUs:     " processor~logicalProcessorCount

-- Mainline Routine
::routine main
  call getprocessorinfoall

::requires bsf.cls   /* get ooRexx-Java bridge: defines public classes and public routines */