-- PROGRAM-NAME: OSHIGetCPUAll.rex    BACKUP-REQUIRED: Yes
-- AUTHOR: Tony Dycks                 REVISED BY: Tony Dycks
-- DATE-WRITTEN: January 25, 2021     DATE-REVISED: November 9, 2021
-- LANGUAGE: Open Object Rexx         VERSION. NO.: 4.10 Or Later
-- PLATFORM: Windows/Linux (Shell)    VERSION. NO.: 7/10 / CentOs/Debian/Ubuntu
--
-- DESCRIPTION:
--   Get All CPU Info as a String in BSF4ooRexx using OSHI Java Library
--
-- PRE-REQUISITE(S):
--   1. Download and Installation of Open Object Rexx Interpreter Version 4.1
--      Or Later
--   2. Download and Installation of Java SE or Open JDK Version 8 Or Later
--   3. Setup Of $JAVA_HOME Environment Variable and Addition To $PATH
--      Of Binary Directory
--   4. Download and Installation of BSF4ooRexx For OS Platform
--   5. Download OSHI Core v5.4 Library Jar File; Deploy to Java Classpath
--   6. Download slf4j v1.7.27 Or Later Jar File; Deploy to Java Classpath
--   7. Download jna Library v4.5.1 Or Later Jar File; Deploy to Java Classpath
--
-- REVISION-HISTORY:
--   Version  Change Description
--   =======  ========================================================
--     1.0    Original Implementation
--              T. Dycks -- January 25, 2021
--     1.1    Fix Errors In Documentation; Changed Procedures to Routines
--              T. Dycks -- November 9, 2021
--
-- USAGE:
--   sh ./rexxj2.sh OSHIGetCPUAll.rex <Enter> {Linux}
--   rexxj2.cmd OSHOGetCPUAll.rex <Enter> {Windows}
--
-- USAGE EXAMPLE(S):
--   sh ./rexxj2.sh OSHIGetCPUAll.rex <Enter> {Linux}
--   rexxj2.cmd OSHOGetCPUAll.rex <Enter> {Windows}
--
-- REFERENCES:
--   Simple Soluion -- Get CPU Information in Java using OSHI library
--   Example 1 Get all information of CPU as a String
-- URL:
--   https://simplesolution.dev/java-get-cpu-information-oshi-library/


-- Mainline Code --
call banner
call main
call endmsg

-- Print Program Description banner
::routine banner
  call SysCls
  say 'OSHIGetCPUAll.rex'
  say 'Get All CPU Info as a String in BSF4ooRexx using OSHI Java Library'
  say 'Version 1.1'
  say 'Written By: Tony Dycks'
  say 'Revised By: Tony Dycks'
  say 'Date Written: January 25, 2021'
  say 'Last Revised: November 9, 2021'
  say

-- Print Program End Message
::routine endmsg
  say
  parse source . . thisPgm
  say '>>> End Of Program --' filespec('Name',thisPgm) '<<<'
  say

::routine getprocessorinfoall
  say .bsf~new("oshi.SystemInfo")~hardware~processor~toString

-- Mainline Routine
::routine main
  call getprocessorinfoall

::requires bsf.cls   /* get ooRexx-Java bridge: defines public classes and public routines */
