import org.apache.bsf.*;    // Apache Bean Scripting Framework
import java.util.Vector;    // needed for arguments to script

class Code13_java_bsf
{
    public static void main (String args[]) throws BSFException
    {
        BSFManager mgr    = new BSFManager();
        BSFEngine  engine = mgr.loadScriptingEngine("rexx");
        // BSF4ooRexx: establish the ooRexx-Java bridge via ooRexx
        engine.apply ("code01", 0, 0, "::requires BSF.CLS", null, null);

        // ooRexx code to interact with the Java object argument
        String code= "use arg javaColl                           \n" +
               "tm=.bsf~new('java.util.TreeMap') /* ordered   */ \n" +
               "tm~putAll(javaColl)     /* add all properties */ \n" +
               "do counter i with index p item val over tm       \n" +
               "   say i'.' pp(p)':' pp(val)                     \n" +
               "end                                              \n" +
               "::requires 'BSF.CLS' /* get ooRexx-Java bridge */\n" ;
        // set argument for script
        Vector codeArgs = new Vector();
        codeArgs.addElement( System.getProperties() );
        engine.apply ("code02", 0, 0, code, null, codeArgs);
        mgr.terminate();
        System.exit(0);
    }
}
