-- PROGRAM-NAME: PtKeysForRedisDbId.rex  BACKUP-REQUIRED: Yes               
-- AUTHOR: Tony Dycks                    REVISED BY: Tony Dycks             
-- DATE-WRITTEN: July 24, 2020           DATE-REVISED: September 15, 2020  
-- LANGUAGE: BSF for Open Object Rexx    VERSION. NO.: v641 ooRexx 4.1 Or Later        
-- PLATFORM: Windows/Linux (Shell)       VERSION. NO.: 7/10 / CentOs/Debian/Mint    
--                                                                       
-- DESCRIPTION:                                                          
--    Print Keys For Redis Db Id Number Specified On The Command Line.
--    Command Line Value Must Be From 0 to 15 To Avoid a Program Exception.
--                                                                       
-- PRE-REQUISITE(S):
--   1. Download and Installation of Open Object Rexx Interpreter Version 4.1
--      Or Later
--   2. Download and Installation of Java SE or Open JDK Version 7 Or Later
--   3. Setup Of $JAVA_HOME Environment Variable and Addition To $PATH
--      Of Binary Directory
--   4. Download and Installation of BSF4ooRexx For OS Platform
--   5. Download and Copy of The Following .jar Files to
--      $JAVA_HOME/jre/lib/ext Directory
--        commons-pool2-2.6.2.jar (Option For Pool Connectivity)
--        jedis-3.2.0.jar (Jedis Client)
--        slf4j-api-1.7.25.jar (Option For Logging)
--                                                                       
-- REVISION-HISTORY:                                                     
--   Version  Change Description                                         
--   =======  ========================================================   
--     1.0    Original Implementation                                    
--              T. Dycks -- July 24-25, 2020
--     1.1    Cleanup Documentation
--              T. Dycks -- September 15, 2020
--                                                                                                                           
-- USAGE:                                                                
--   sh ./rexxj2.sh PtKeysForRedisDbId.rex <Db-Id> <Enter> {Linux}                              
--                                                                       
-- USAGE EXAMPLE(S):                                                        
--   sh ./rexxj2.sh PtKeysForRedisDbId.rex 0 <Enter> {Linux} 
--   sh ./rexxj2.sh PtKeysForRedisDbId.rex 4 <Enter> {Linux} 
--                                                                       
-- REFERENCES: 
--   TutorialsPoint.com -- Redis - Java -- Redis Java Keys Example
-- URL:
--   https:--www.tutorialspoint.com/redis/redis_java.htm           
--
if rxFuncQuery("BSF") then  /* no bsf4rexx support available yet, hence load Java */
  do
   call rxFuncAdd "BsfLoadFuncs", "BSF4Rexx", "BsfLoadFuncs"
   call BsfLoadFuncs    /* load all BSF-functions                    */
   call BsfLoadJava     /* load the JVM and set up BSF4Rexx-support  */
  end

if      BsfInvokedBy()=1 then say "This Rexx program was invoked by Java!"
else if BsfInvokedBy()=2 then say "This Rexx program was invoked by Rexx, JVM loaded by Rexx!"
else                          say "No JVM present, we got troubles ..."

-- Parse Numeric Redis Db Index Argument (0-15)  
parse arg ArgDbId

-- Mainline Code --
call banner
call main
call endmsg
exit

-- Print Program Description banner
banner:
  call SysCls
  say 'PtKeysForRedisDbId.rex'
  say 'Print Keys For Redis Db Id Number Specified On The Command Line'
  say 'Version 1.1'
  say 'Written By: Tony Dycks'
  say 'Revised By: Tony Dycks'
  say 'Date Written: July 24, 2020'
  say 'Last Revised: September 15, 2020'
  say
  return

-- Print Program End Message
endmsg:
  say
  say '>>> End Of Program -- PtKeysForRedisDbId.rex <<<'
  say
  return

-- Mainline Routine --
main:
  --Connecting to Redis server on localhost 
  --Java: Jedis jedisCon = new Jedis("localhost") 
  jedisCon = .bsf~new('redis.clients.jedis.Jedis') 
  say "Connected to Redis Server Successfully ..."
  say "Selecting Db Id: " || ArgDbId
  say
  jedisCon~select(ArgDbId);
  iKeyCnt = 0
  -- Get the stored data and print it 
  setDbKeys = jedisCon~keys("*")
  
  loop sDbKey over setDbKeys 
    iKeyCnt = iKeyCnt + 1        
    say iKeyCnt || ": " || sDbKey 
  end
  
  if iKeyCnt == 0 then
    do
      say "No Keys Found for Db Id #: " || iDbId
    end
  -- Close The Redis Connection
  jedisCon~close()
  return

::requires bsf.cls   /* BSF4Rexx Class File */