-- PROGRAM-NAME: PtHGetAllForRedisDbIdDbKey.rex  BACKUP-REQUIRED: Yes               
-- AUTHOR: Tony Dycks                            REVISED BY: Tony Dycks             
-- DATE-WRITTEN: July 24, 2020                   DATE-REVISED: September 15, 2020  
-- LANGUAGE: BSF for Open Object Rexx            VERSION. NO.: 4.1 Or Later        
-- PLATFORM: Windows/Linux (Shell)               VERSION. NO.: 7/10 / Debian/Mint    
--                                                                       
-- DESCRIPTION:                                                          
--   Print All Hash Values For Redis Db Id Number & DB Key Entered On The 
--   Command Line                                                
--                                                                       
-- PRE-REQUISITE(S):
--   1. Download and Installation of Open Object Rexx Interpreter Version 4.1
--      Or Later
--   2. Download and Installation of Java SE or Open JDK Version 7 Or Later
--   3. Setup Of $JAVA_HOME Environment Variable and Addition To $PATH
--      Of Binary Directory
--   4. Download and Installation of BSF4ooRexx For OS Platform
--   5. Download and Copy of The Following .jar Files to
--      $JAVA_HOME/jre/lib/ext Directory
--        commons-pool2-2.6.2.jar (For Pool Connectivity)
--        jedis-3.2.0.jar (Jedis Client)
--        slf4j-api-1.7.25.jar (For Logging)
--                                                                       
-- REVISION-HISTORY:                                                     
--   Version  Change Description                                         
--   =======  ========================================================   
--     1.0    Original Implementation                                    
--              T. Dycks -- July 24-25, 2020    
--     1.1    Fix Errors in Documentation
--              T. Dycks -- September 15, 2020
--                                                                                                                           
-- USAGE:                                                                
--   sh ./rexxj2.sh PtHGetAllForRedisDbIdDbKey.rex <Db-Id> <Db-Key> <Enter> 
--   {Linux & Windows}                              
--                                                                       
-- USAGE EXAMPLE(S):                                                        
--   sh ./rexxj2.sh PtHGetAllForRedisDbIdDbKey.rex 0 tizthelaw:pyqdbm <Enter> 
--     {Linux & Windows} 
--   sh ./rexxj2.sh PtHGetAllForRedisDbIdDbKey.rex 0 tizthelaw:redis <Enter> 
--     {Linux & Windows} 
--                                                                       
-- REFERENCES: 
--   TutorialsPoint.com -- Redis - Java -- Redis Java Keys Example
-- URL:
--   https://www.tutorialspoint.com/redis/redis_java.htm                 
--
if rxFuncQuery("BSF") then  /* no bsf4rexx support available yet, hence load Java */
  do
   call rxFuncAdd "BsfLoadFuncs", "BSF4Rexx", "BsfLoadFuncs"
   call BsfLoadFuncs    /* load all BSF-functions                    */
   call BsfLoadJava     /* load the JVM and set up BSF4Rexx-support  */
  end

if      BsfInvokedBy()=1 then say "This Rexx program was invoked by Java!"
else if BsfInvokedBy()=2 then say "This Rexx program was invoked by Rexx, JVM loaded by Rexx!"
else                          say "No JVM present, we got troubles ..."

-- Parse Redis Db Index & Search Db Keys  
parse arg ArgDbId ArgDbKey

-- Mainline Code --
call banner
call main
call endmsg
exit

-- Print Program Description banner
banner:
  call SysCls
  say 'PtHGetAllForRedisDbIdDbKey.rex'
  say 'Print All Hash Values For Redis Db Id Number & DB Key'
  say 'Entered On The Command Line'
  say 'Version 1.1'
  say 'Written By: Tony Dycks'
  say 'Revised By: Tony Dycks'
  say 'Date Written: July 24, 2020'
  say 'Last Revised: September 15, 2020'
  say
  return

-- Print Program End Message
endmsg:
  say
  say '>>> End Of Program -- PtHGetAllForRedisDbIdDbKey.rex <<<'
  say
  return

-- Mainline Routine --
main:
  -- Connecting to new Jedis Client Connection 
  -- Object on localhost 
  -- Java: Jedis jedisCon = new Jedis("localhost") 
  jedisCon = .bsf~new('redis.clients.jedis.Jedis')
  say 'Pinging Redis Server ... ' || jedisCon~ping()
  say "Connected to Redis Server Successfully ..."
  say "Selecting Db Id: " || ArgDbId
  say
  jedisCon~select(ArgDbId);
  iValCnt = 0
  -- Get the Hash Structure Keys For The Db Key 
  HashKeys = jedisCon~hgetall(ArgDbKey)
  say "Db Index: " || ArgDbId
  say "Key: " || ArgDbKey
  say
  iValCnt = 0
  
  -- Loop Thru The HashKeys And Get The Hash Value for The Key
  loop HashKey over HashKeys
    iValCnt = iValCnt + 1
    HashVal = jedisCon~hget(ArgDbKey, HashKey)
    say HashKey || ' ==> ' || HashVal 
  end
  -- Nothing Found? Print A Message With The Search Key Used
  if iValCnt == 0 then
    do
      say
      say "No Key Found for Search Key Argument: [" || ArgDbKey || "]"
    end
  -- Close The Redis Connection
  jedisCon~close()
  return

::requires bsf.cls   /* BSF4Rexx Class File */