-- PROGRAM-NAME: LdRedis5BSF4ooRexxVerInfo.rex  BACKUP-REQUIRED: Yes               
-- AUTHOR: Tony Dycks                           REVISED BY: Tony Dycks             
-- DATE-WRITTEN: September 13, 2020             DATE-REVISED: September 15, 2020  
-- LANGUAGE: Open Object Rexx                   VERSION. NO.: 4.1 Or Later        
-- PLATFORM: Windows/Linux (Shell)              VERSION. NO.: 7/10 / CentOs/Debian/Arch    
--                                                                       
-- DESCRIPTION:                                                          
--    Load Redis Db Id 5 Store With BSF4ooRexx Version Info From Current Host PC                                                
--                                                                       
-- PRE-REQUISITE(S):
--   1. Download and Installation of Open Object Rexx Interpreter Version 4.1
--      Or Later
--   2. Download and Installation of Java SE or Open JDK Version 7 Or Later
--   3. Setup Of $JAVA_HOME Environment Variable and Addition To $PATH
--      Of Binary Directory
--   4. Download and Installation of BSF4ooRexx For OS Platform
--   5. Installation and Startup of Redis Db Server
--   6. Download of Jedis Client Java Jar File
--   7. Copy Jedis Java Jar File to $JAVA_HOME/jre/lib/ext
--                                                                       
-- REVISION-HISTORY:                                                     
--   Version  Change Description                                         
--   =======  ==================================================================   
--     1.0    Original Implementation                                    
--              T. Dycks -- September 13-15, 2020
--                                                                                                                           
-- USAGE:                                                                
--   sh ./rexxj2.sh LdRedis5BSF4ooRexxVerInfo.rex <Enter> {Linux}                              
--                                                                       
-- USAGE EXAMPLE(S):                                                        
--   sh ./rexxj2.sh LdRedis5BSF4ooRexxVerInfo.rex <Enter> {Linux}                       
--                                                                       
-- REFERENCE(S):
--   Tutorials Point -- Redis -- Java 
-- URL:
--   https://www.tutorialspoint.com/redis/redis_java.htm
-- =============================================================================
--   Open Object Rexx Reference -- Chapter 7. Functions -- Built-in Functions -- Date
-- URL:
--   https://www.oorexx.org/docs/rexxref/x23579.htm

if rxFuncQuery("BSF") then  /* no bsf4rexx support available yet, hence load Java */
do
   call rxFuncAdd "BsfLoadFuncs", "BSF4Rexx", "BsfLoadFuncs"
   call BsfLoadFuncs    /* load all BSF-functions                    */
   call BsfLoadJava     /* load the JVM and set up BSF4Rexx-support  */
end

if      BsfInvokedBy()=1 then say "This Rexx program was invoked by Java!"
else if BsfInvokedBy()=2 then say "This Rexx program was invoked by Rexx, JVM loaded by Rexx!"
else                          say "No JVM present, we got troubles ..."

-- Mainline Code --
call banner
call main
call endmsg
exit

-- Print Program Description banner
banner:
  call SysCls
  say 'LdRedis5BSF4ooRexxVerInfo.rex'
  say 'Load Redis Db Id 5 Store With BSF4ooRexx Version Info From Current Host PC'
  say 'Version 1.0'
  say 'Written By: Tony Dycks'
  say 'Revised By: Tony Dycks'
  say 'Date Written: September 13, 2020'
  say 'Last Revised: September 15, 2020'
  say
  return

-- Print Program End Message
endmsg:
  say
  say '>>> End Of Program -- LdRedis5BSF4ooRexxVerInfo.rex <<<'
  say
  return

-- Get BSF4ooRexx Version 
getbsf4oorexxversn: procedure
  return .bsf4rexx~display.version

-- Get Current Date
getcurdt: procedure
  argcurdt = Date("S")
  argcurdt = substr(argcurdt, 1, 4) || '-' || substr(argcurdt, 5, 2) || '-' || substr(argcurdt, 7, 2)
  say 'Current Date: ' || argcurdt
  return argcurdt
  
-- Get Hostname
gethostname: procedure expose system
  inetaddr=bsf.loadClass('java.net.InetAddress')
  addr = inetaddr~getLocalHost()
  arghostnm = addr~getHostName()
  return arghostnm
  
-- Get Java Version 
getjavaversn: procedure expose system
  return system~getProperty("java.version")

-- Get Java VM Info
getjavavmvendor: procedure expose system
  return system~getProperty("java.vm.vendor")
  
-- Get JVM Bitness
getjvmbitness: procedure expose system
  return system~getProperty("sun.arch.data.model")
  
-- Get ooRexx Version
getoorexxversn: procedure
  parse version argoorexxver
  return argoorexxver

-- Get OS Architecture
getosarch: procedure expose system
  return system~getProperty("os.arch")
  
-- Get OS Platform Name
getosname: procedure expose system
  return system~getProperty("os.name")

-- Mainline Routine
main:
  system = bsf.loadClass('java.lang.System')
  hostnm = gethostname()
  say 'Hostname: ' || hostnm
  osnm = getosname()
  say 'OS Name: ' || osnm
  osarch = getosarch()
  say 'OS Architecture: ' || osarch
  oorexxver = getoorexxversn()
  say 'ooRexx Version: ' || oorexxver
  javaver = getjavaversn()
  say 'Java Version: ' || javaver
  javavmvendor = getjavavmvendor()
  say 'Java VM Info: ' || javavmvendor
  jvmbitness = getjvmbitness()
  say 'JVM Bitness: ' || jvmbitness
  -- Added bsf4oorexx Version -- September 13, 2020
  bsf4oorexxver =  getbsf4oorexxversn()
  say 'BSF4ooRexx Display Version: ' || bsf4oorexxver
  curdt = getcurdt()
  -- Connect To The Redis Db Server; Select Id # 5
  -- Load The Db With The Previously Retrieved Version Info
  -- Set Version Info Hash Entries for Hostname
  -- Jedis Java Client (Jar Files in JRE Lib Extensions Directory
  say 'Connecting to Redis Db Id # 5 ...'
  Jedis = bsf.import("redis.clients.jedis.Jedis")  -- Import Java Class
  jedis = Jedis~new()
  say 'Selecting Redis Db Id #5 ...'
  jedis~select(5) -- Select Redis Db Id #5
  say 'Flushing Db Id #5 of any Existing Data ...'
  jedis~flushdb() -- Delete Any Previous Entries
  say 'Current DB Entries: ' || jedis~dbSize()
  say 'Storing Key Values ...'
  dbkeypfx = hostnm || ":"
  rediskey = dbkeypfx || "os.name"
  strval = osnm
  say rediskey || ' => ' || strval
  jedis~set(rediskey, strval)
  rediskey = dbkeypfx || "os.arch"
  strval = osarch
  say rediskey || ' => ' || strval
  jedis~set(rediskey, strval)
  rediskey = dbkeypfx || "oorexx.versn"
  strval = oorexxver
  say rediskey || ' => ' || strval
  jedis~set(rediskey, strval)
  rediskey = dbkeypfx || "java.version"
  strval = javaver
  say rediskey || ' => ' || strval
  jedis~set(rediskey, strval)
  rediskey = dbkeypfx || "java.vm.vendor"
  strval = javavmvendor
  say rediskey || ' => ' || strval
  jedis~set(rediskey, strval)
  rediskey = dbkeypfx || "sun.arch.data.model"
  strval = jvmbitness
  say rediskey || ' => ' || strval
  jedis~set(rediskey, strval)
  rediskey = dbkeypfx || ".bsf4rexx~display.version"
  strval = bsf4oorexxver
  say rediskey || ' => ' || strval
  jedis~set(rediskey, strval)
  rediskey = dbkeypfx || "last.update"
  strval = curdt
  say rediskey || ' => ' || strval
  jedis~set(rediskey, strval)
  say 'Current DB Entries: ' || jedis~dbSize()
  say 'Closing Redis Db Connection ...'
  jedis~close()
  return

::requires bsf.cls   /* BSF4Rexx Class File */