/*
 * This program turns a laser on if an object gets too close to the IR proximity sensor
 * Also queues command onto bandit's rxstack
 *
 * Wiring:
 *  For IR and PIR Sensor: v - 5V
 *                         g - Ground
 *                         d - Data Pin (Physical Pin 12; wiringPi Pin: 1)
 *  For Laser:             G - Ground
 *                         D - Data Pin (Physical Pin 11; wiringPi Pin: 0)
 * 2 ->  v . g . . d G . . . . . . . . . . . . . <- 40
 * 1 ->  . . . . . D . . . . . . . . . . . . . . <- 39
 */

Numeric Digits 20
Call RxFuncAdd 'WPiLoadFuncs', 'rexxwpi', 'WPiLoadFuncs'
Call WPiLoadFuncs

!global.!IRPin = 1
!global.!LaserPin = 0
!global.!lastState = !REXXWPI.!LOW

Signal On Halt

Say 'This is Rexx/WPi:' WPiVariable('VERSION')

!globalv = '!global. !REXXWPI. !board.'

Call WPiPiBoardId '!BOARD.!'
Say 'Model:   ' !board.!model
Say 'Revision:' !board.!rev
Say 'Maker:   ' !board.!maker
Say 'Memory:  ' !board.!mem'mb'
Say 'Warranty:' !board.!warranty
Say
Call WPiWiringPiSetup
-- set out IR pin to in to be able to read it
--Address System 'gpio mode' !global.!IRPin 'in'
Call WPiPinMode !global.!IRPin, !REXXWPI.!INPUT
Call WPiPinMode !global.!LaserPin, !REXXWPI.!OUTPUT

Do Forever
   rcode = PIRIntruderLoop()
   If rcode = !REXXWPI.!HIGH Then Leave
End
-- turn laser off after 3 seconds
Call WPiDelay 3000
Call WPiDigitalWrite !global.!LaserPin, !REXXWPI.!LOW
Exit 0

PIRIntruderLoop: Procedure Expose (!globalv)
-- Get value from motion sensor
rcode = WPiDigitalRead( !global.!IRPin )
Say Time() 'Motion detected:' rcode
-- Turn on/off laser depending on value from PIR
Call WriteLaser !global.!LaserPin, rcode
If rcode = !REXXWPI.!LOW Then
   Do
      Call WPiDelay 1000
   End
Return rcode

WriteLaser: Procedure Expose (!globalv)
Parse Arg pin, onoff
action = 'off on'
If !global.!lastState \= onoff Then
   Do
      Say 'Turning laser' Word( action, onoff+1 )
      !global.!lastState = onoff
   End
Call WPiDigitalWrite pin, onoff
If onoff = !REXXWPI.!HIGH Then
   Do
      -- kill the bandit
      Call RxQueue 'S', 'bandit@bandit:5656'
      Queue 'kill!'
   End
Return rcode

Halt:
If !global.!PIR = 'motion' Then
   Do
      -- turn off laser in case it is still on
      Call WPiDigitalWrite !global.!LaserPin, !REXXWPI.!LOW
   End
Exit 0
