/*
 * This program waits for a 'Kill1" command on the local rxstack and
 * upon receipt, screams and keels over
 *
 * Wiring:
 *  For Servo Motor: 5V - battery
 *                   g - Ground <-> battery
 *  (40 pin header)  d - PWM Pin (Physical Pin 12; GPIO Pin: 18; wiringPi Pin: 1)
 *  (speaker bonnet) d - PWM Pin (Physical Pin 33; GPIO Pin: 13; wiringPi Pin: 23)
 *
 *  For Tilt sensor: V - 5V
 *                   G - Ground
 *                   D - Data Pin (Physical Pin 13; GPIO Pin: 27; wiringPi Pin: 2))
 *
 * 40 Pin Header->
 * 2 ->  . V g . . d G . . . . . . . . . . . . . <- 40
 * 1 ->  . . . . . . . . . . . . . D . . . . . . <- 39
 * Speaker Bonnet->
 * . . . . . . . D . . . . . . . . . . . . d . . . .
 *
 * G . g
 * V . .
 * . . .
 */
Call RxFuncAdd 'WPiLoadFuncs', 'rexxwpi', 'WPiLoadFuncs'
Call WPiLoadFuncs

Parse Arg !global.!quiet

!global.!ServoPin = 13
!global.!TiltPin = 27
!global.!start = 100
!global.!end = 50

Signal On Halt

Say 'This is Rexx/WPi:' WPiVariable('VERSION')

!globalv = '!global. !REXXWPI.'
-- start an instance of rxstack on port 5656, accessible from world
Address System 'rxstack --world --port=5656 --daemon'

-- create bandit stack and set timeout to 0 to wait forever
Call RxQueue 'C', 'bandit@localhost:5656'
Call RxQueue 'S', 'bandit@localhost:5656'
Call RxQueue 'T', 0

Call WPipiBoardId '!BOARD.!'
Say 'Model:   ' !board.!model
Say 'Revision:' !board.!rev
Say 'Maker:   ' !board.!maker
Say 'Memory:  ' !board.!mem'mb'
Say 'Warranty:' !board.!warranty
Say
Say 'Waiting to be killed...'

Parse Pull line
If line = 'kill!' Then Call KillBandit
-- delete our stack
Say 'Deleting bandit stack'
Call RxQueue 'D', 'bandit@localhost:5656'
-- kill  our instance of rxstack on port 5656
Address System 'rxstack --kill --port=5656'
Exit 0

KillBandit: Procedure Expose (!globalv)
If !global.!quiet = '' Then Address System 'mpg123 -q scream.mp3'
-- setup servo and tilt switch
Call WPiWiringPiSetupGpio
Call WPiPinMode !global.!TiltPin, !REXXWPI.!INPUT
Call WPiPinMode !global.!ServoPin, !REXXWPI.!PWM_OUTPUT
Call WPiPwmSetMode !REXXWPI.!PWM_MODE_MS
-- divide down clock
Call WPiPwmSetClock 192
Call WPiPwmSetRange 2000

Do i = !global.!start To !global.!end By -1
   Call WPiPwmWrite !global.!ServoPin, i
   rcode = WPiDigitalRead( !global.!TiltPin )
   If rcode = !REXXWPI.!HIGH Then Leave
   Call WPiDelay 20
End
-- reset to start position
Call Sleep 2
Call WPiPwmWrite !global.!ServoPin, !global.!end
Return 0

Halt:
Exit 0
