/*
    Date: 3 Aug 2014 22:15:25 - Initial release
 Update:  8 Sep 2015 23:40:50 - Ensure stackframes?=0 for Regina
 Update: 10 Sep 2015 01:23:38 - Add extreme test case data for DUMP
 Update: 18 Oct 2015 00:36:27 - reworked and renamed for oodumpvars
*/ beghelp=thisline()+1; /*
testoodumpx.rex:     See "Purpose", below
Copyright (C) 2014 Leslie L. Koehler
This is free software. See "Notice:" at the bottom of this file

 Author: Les Koehler vmrexx@tampabay.rr.com

Purpose: Test oodumpvars() for a Rex program, using extreme data

 Syntax: &sme [DUMp]
         &pad [Keep]
         &pad [Stem]
         &pad [DELete]

   Dump and show file
   Dump with the KEEP option and an identifier
   Return commands in a STEM and display them
   Delete all generations of the file

   Help: &sme &helps
*/
endhelp=thisline()-2
call parse_source
parse arg args
call parse_args
call valueof ucwd
exit

PARSE_SOURCE:
  Parse Source whatos how fullme
  Parse Value Reverse(fullme) With ext'.' em '\' mypath
  me=Translate(Reverse(em))':'
  sme=Substr(me,1,Length(me)-1)
  pad=copies(' ',length(sme))
  lcsme=lower(sme)
  mypath=reverse(mypath)'\'
  logfile=mypath||Lower(sme)'.log'
  ext=translate(reverse(ext))
  the?=ext='THE'
  rex?=\the?
  parse version whatrexx rexxlevel rexx_release_date
  oorexx?=pos('ooRexx',whatrexx)>0
  if oorexx? then do
    parse version '-ooRexx_'version'.'release'.'mod'(' .
    version_rel=version'.'release
    stackframes?=version_release>=4.2
  End
  else stackframes?=0
  regina?=pos('REGINA',translate(whatrexx))>0
  if regina? then do
    Call rxfuncadd 'sysloadfuncs', 'rexxutil', 'sysloadfuncs'
    call sysloadfuncs
  End
  args=''
  opts=''
  if the? then do
    c='command'
    cn='command nomsg'
    m='macro'
  end
  Return
PARSE_ARGS:
  Call init_vars
  If Words(args)=0 Then call help
  wds=Words(args)
  ucargs=Translate(args)
  Do w=1 To wds
    wd=Word(ucargs,w)
    ok?=0
    Do v=1 To Words(ucvalids)
      If Abbrev(Word(ucvalids,v),wd,Word(abbrev,v)) Then Do
        ok?=1
        leave v
      end
    end
    if ok? then do
        z=Word(flags,v)              /* Set flags indirectly */
        Call value z'.'w,1                       /* Set positional flag */
        Call value z,1                                  /* Set arg flag */
        ucwd=word(ucvalids,v)
        argix.wd=ucwd
    End
    Else Do
      Call value 'unknown?.'w,1
      unknown?=1
      unknowns=unknowns wd
    End
  End
  If help? Then Call help
  If unknown? & keyword_parms? Then Do   /* Allow parms after keywords */
    kwdptrs=''
    kwds=''
    Do u=1 To wds                /* Get the kwds in left to right order */
      wd=Word(ucargs,u)
      If \unknown?.u Then  Do                        /* Found a keyword */
        kwdptrs=kwdptrs u
        kwds=kwds wd
      End
    End
    kwdctr=Words(kwdptrs)
    Do p=1 To kwdctr                      /* Get the parms for each kwd */
      pix=Word(kwdptrs,p)                            /* Index into args */
      If pix+1<wds & p<kwdctr Then Do              /* Another kwd later */
        piy=Word(kwdptrs,p+1)                        /* Ptr to next kwd */
        If piy\='' Then Do
          piy=piy-1                             /* Back up to prev word */
          pwords=piy-pix                /* Number of words between kwds */
        End
        Else Do
          Iterate
        End
      End
      Else Do                           /* TAILOR TO SUIT! Last keyword */
        If pix<wds Then Do                      /* Something follows it */
--          If Word(ucargs,p)='FILE' Then pwords=wds-pix /* Get all of it */
          If Wordpos(Word(ucargs,p),keyword_parms)>0 Then ,
           pwords=wds-pix                              /* Get all of it */
          Else pwords=1                                /* Just one word */
        End
        Else pwords=0
      End
      Do u=pix+1 To pix+pwords                 /* Reset unknown?. flags */
        Call value 'unknown?.'u,0        /* For parms that go with kwds */
      End
      vname=Word(kwds,p)                             /* Name of the var */
      vname=argix.vname
      vval=Subword(args,pix+1,pwords)               /* Value of the var */
      Call value vname,vval                                   /* Set it */
    End
    unknowns=''                                                /* Reset */
    unknown?=0
    Do u=1 To wds         /* Accumulate any args that are still unknown */
      If unknown?.u Then unknowns=unknowns Word(args,u)
    End
  End
    unknown?=unknowns\=''
 --   Call dump
  if unknown? then call exit 8 'Unknown option(s):' unknowns
  return
INIT_VARS:
  valids='?  /? -? Help /Help -Help --Help' /* Keywords                */
  abbrev='1  2  2  1    2     2     3     ' /* Minimum abbreviation    */
  flags=copies('Help? ',words(valids))      /* Flag to set for keyword */
  helps=valids
  valids=valids 'DUmp Stem DELete Keep' --< Your keywords
  abbrev=abbrev '2    1    3      1' --< Your abbreviations
  flags=flags   'dump? stem? del? keep?'--< Your flagnames
  flags=flags 'Unknown? Keyword_parms?'        /* Always the last ones */
  Do f=1 To Words(flags)
    v=Word(flags,f)
    Call value v'.'f,0                    /* Initialize positional flag */
    Call value v,0                               /* Initialize arg flag */
  End
  last=words(helps)
  hhelp=''
  do h=1 to last                       /* Build the Helps line variable */
    if h\=last then hhelp=hhelp || word(helps,h) '| '
    Else hhelp=hhelp||word(helps,h)
  End
  helps=hhelp
  unknowns=''
  unknown?.=0
  ucvalids=Translate(valids)
--  msg.0=0
--  keyword_parms?=1
--  keyword_parms='TO FILE PATH'
--  Parse Value '' With file path To
--  msg.0=0
  exposes='sme lcsme me msg. c cn m myrc how pad' ,
   'help? mypath log? the? rex? logfile oorexx? regina? fullme'
  Return
MSG: Procedure Expose sme me rex? the?
   if rex? then say me Arg(1)
   else 'msg' me Arg(1)
  Return
EMSG: Procedure Expose sme me emsg rex? the?
   if rex? then say me Arg(1)
   else 'emsg' me Arg(1)
  Return
NEXT:
  trace o
  Parse Arg !stem,!val
  If \Datatype(Value(!stem'.0'),'W') Then Call value !stem'.0',0
  !ix=Value(!stem'.0')+1
  Call value !stem'.0',!ix
  Call value !stem'.'||!ix ,!val
  Return
THISLINE:
  Return sigl
DUMP:
name='Les Koehler , Boston' /* Demonstration of weird test data */
name.name='Allston'
tail1='a blank '
a.tail1='111'
tail2='a blank  '
a.tail2='222'
tail3='0102'x
a.tail3='333'
Tail4='..., NAME...'
tail4='..., Value='
a.tail5='>'tail5 tail5'<'
a.tail5=tail5
--verylongvariablenamethatexceeds25chars='test expanded_dumpvars'
--longvariablename='test expanded_dumpvars Name>15'
  if stackframes? then Interpret oodumpvars('K','edit','Les')
  else  Interpret oodumpvars('K','edit','Les',,fullme) /* Use this if <4.2 */
--say edit
  interpret edit
  exit
KEEP:
  if stackframes? then Interpret oodumpvars('K',,'Les')
  else Interpret oodumpvars('K',,'Les',,fullme)
exit
--  Interpret dumpvars('K',zz)
stem:
stem.0=0
file=mypath||upper(left(mypath,1))'_'lcsme'.rex.Les.'
--file=mypath||upper(left(mypath,1))'_'lcsme'.rex.'
--file=mypath||upper(left(mypath,1))'_'lcsme'.'
interpret oodumpvars('D','*','*','stem.',file)
do s=1 to stem.0
  interpret 'say "stem."'s'"="' stem.s
End
exit
delete:
file=mypath||upper(left(mypath,1))'_'lcsme'.rex.Les.'
--file=mypath||upper(left(mypath,1))'_'lcsme'.rex.'
--file=mypath||upper(left(mypath,1))'_'lcsme'.'
interpret oodumpvars('D','*','*','stem.',file)
do s=1 to stem.0
  interpret stem.s
End
  Exit
VALUEOF:
  Arg !_!label
  Signal Value !_!label
  Return
HELP:
  if the? then do
    call helpx_make_file fullme,beghelp,endhelp,fullme'_help.txt'
    Call exit
  End
  alph='abcdefghigklmnopqrstuvwxyz'
  Do h=beghelp To endhelp
--if h=14 then trace r --call dump
    data=Sourceline(h)
    hit=Pos('&',data)
    line=''
    If hit>0 Then Do
      left=Substr(data,1,hit-1)
      data=Substr(data,hit)
      vline=''
      Do While data\='' & Pos('&',data)>0
--        Parse Var data lead '&' +1 wd data
        Parse Var data lead '&' +1 data
        vline=vline||lead
        lead=''
        nonalph=Verify(data,alph,'Nomatch')
        If nonalph>0 Then Do
          Parse Var data wd =(nonalph) data
        End
        Else Do
          Parse Var data wd data
        End
        If Symbol(wd)\='BAD' Then Do
          If Symbol(wd)='VAR' Then Do
/*
            If Left(data,1)=' ' Then ,
             vline=vline Value(wd)
            Else vline=vline || Value(wd)
*/
            vline=vline || Value(wd)
          End
          Else Do                           /* Might end in punctuation */
            Parse Value Reverse(wd) With punct 2 rest
            rest=Reverse(rest)
            If Datatype(rest,'S') & Symbol(rest)='VAR' Then Do
              vline=vline lead||Value(rest)||punct
            End
--            Else vline=vline lead'&'wd data
            Else vline=vline lead'&'rest||punct
          End
        End
--/*
        Else Do               /* It might be bad because of punctuation */
          Parse Value Reverse(wd) With punct 2 rest
          rest=Reverse(rest)
          If Datatype(rest,'S') & Symbol(rest)='VAR' Then Do
            vline=vline lead||Value(rest)||punct
          End
          Else do
            vline=vline lead'&'data
            data=' '
          end
        End
--*/
      End
      If data\='' Then vline=vline||lead||data
--      line=left||Space(vline)
      line=left||vline
    End
    Else line=data                                  /* No & in the line */
    call next 'help',line
  End
  helpfile=fullme'_help.txt'
  Call stream helpfile, 'C', 'OPEN WRITE REPLACE'
trace o
  do l=1 to help.0
    call lineout helpfile,help.l
  End
  Call stream helpfile, 'C', 'CLOSE'
  ADDRESS CMD 'start NOTEPAD "'helpfile'"'
  Call exit
  Return
EXIT: Procedure Expose sme me sigl msg emsg rex? the?
  Parse Arg myrc mymsg
  mysigl=sigl
  If myrc='' Then myrc=0
  If myrc\=0 & mymsg\='' Then Do
    Call emsg mymsg
    Call msg 'Enter' sme 'HELP for help'
    Call emsg 'Rc='myrc
  End
  Else If myrc=0 & mymsg\='' Then Call msg mymsg
  If myrc\=0 Then Call msg 'Exit called from line' mysigl
  Exit myrc
LOGIT: Procedure Expose (exposes) sigl
--trace r
  mysigl=sigl
  Parse Arg logargs
  If logargs='' Then logargs=Sourceline(mysigl+1)
  Parse Value Right(Space(Date(),0),9,0) Time('L') With ds ts
  logline=ds ts logargs
  If Arg(2,'E') & Arg(2)\='' Then Do
    Parse Value Arg(2) With his_sigl him
    logline=logline '>' him '@' his_sigl
  End
  logfile=mypath||upper(sme)'.log'
  If oorexx? Then Do
   -- .stream~new(logfile)~~lineout(logline)~close
    writeline='.stream~new("'logfile'")~~lineout("'logline'")~close'
    interpret writeline
  End
  Else Do
    Call stream logfile, 'C', 'OPEN WRITE APPEND'
    Call lineout logfile,logline
    Call stream logfile,'C', 'CLOSE'
  End
  Return
/* --- End of skeleton code --- Put subroutines below: */

/* Notice:
    This program is free software: you can redistribute it and/or modify
    it under the terms of the EPL (Eclipse Public License) as published by
    the Open Source Initiative, either version 1.0 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    EPL for more details.

    You should have received a copy of the EPL along with this program.
     If not, see:
    http://www.opensource.org/licenses/eclipse-1.0.php
*/
