/*
 Author: Les Koehler, Gil Barmwater and Walter Pachl
   Date: 17 Oct 2015 - Initial release
 Update: 31 Oct 2015 03:36:08 - Use showit.rex for Help
*/ beghelp=thisline()+1 /*
&lcsme.rex:     See "Purpose", below
Copyright (C) 2015 Leslie L. Koehler
This is free software. See "Notice:" at the bottom of 
 &this file.

 Author: Les Koehler vmrexx@tampabay.rr.com

Purpose: Replace SysDumpVariables with Object code that avoids the
         "Carriage Return/Linefeed in data" problem and optionally
         puts the "Name=" data in a fixed width column, along with
         special data validation and hex display of non-printable
         data.

&pad  15   ]
Syntax: Call &lcsme .context~variables , outfile [, width]

If width=0 then expanded_dumpvars.rex will not be executed for the
optional validation and hex features, thus CR and LF will be shown as 
<CR> and <LF>.

 Help: &lcsme [&helps]

Credits: Gil Barmwater for LOTS of help with the Object code. In fact,
         his examples were actually copied into the code!

         Walter Pachl for expanded_dumpvars.rex which he wrote for
         my dumpvars.rex and I reused here.

see also: oodumpvars.rex which is a wrapper that adds more features.
*/
endhelp=thisline()-2
use Arg vardir,outfile,width=15   -- directory of variable names and current values
--trace r
parse source . how fullme
hit=lastpos('\',fullme)
parse var fullme =(hit+1) lcsme'.' .
sme=translate(lcsme)
lcsme=lower(sme)
--trace r
--if \vardir~isa(.Rexxcontext) then do
if \vardir~isa(.Directory) then do
  signal help
End
expand?=0
If Datatype(width,'W') Then Do
  If width>0 Then expand?=1
End
  --  trace ?i
--  trace r
varnames = varDir~allIndexes~sort
out.0=0
Do i = 1 To varNames~items
  thename = varNames[i]
  thevalue = varDir[theName]
  If theValue~isA(.stem) Then Do
    thestemname = thename
    thestemvalue = thevalue
    alltails = theStemValue~allIndexes~sort
    Do j = 1 To allTails~items
      thetail = allTails[j]
      thename = thestemname||thetail
      thevalue  = theStemValue[theTail]
      Call save
    End
  End
  Else Call save
End
Call sysfiledelete outfile
outobject = .stream~new(outfile)
outObject~open("WRITE")
Do l=1 To out.0
  outobject~lineout(out.l)
End
outobject~close()
call sort_dumpvars outfile
If expand? Then Call expanded_dumpvars width outfile
Return
SAVE:
  out.0=out.0+1
  o=out.0
  out.o="Name="thename", Value='"thevalue"'"
  out.o=Changestr('0d'x,out.o,'<CR>')
  out.o=Changestr('0a'x,out.o,'<LF>')
Return
thisline: return sigl
HELP:
  helps='?  /? -? Help /Help -Help --Help'       /* Keywords                */
  pad=copies('ff'x,61)'['

  outvar=beghelp endhelp fullme
  call showit fullme ,, outvar , 
   ,'&lcsme='lcsme , '&helps='helps , '&this file.='fullme , '&pad='pad
exit
dump:
interpret dumpvars()
--interpret z
exit
/* Notice:
    This program is free software: you can redistribute it and/or modify
    it under the terms of the EPL (Eclipse Public License) as published by
    the Open Source Initiative, either version 1.0 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    EPL for more details.

    You should have received a copy of the EPL along with this program.
     If not, see:
    http://www.opensource.org/licenses/eclipse-1.0.php
*/
