/* */ beghelp=thisline()+1 /*
Author: Walter Pachl
Purpose: Column align Value= data from SysDumpVariables

Syntax: expanded_dumpvars column fileid

Process:

 Read all lines from fileid. Note that it must end with: .SDV
 ERASE fileid
 Write all lines to fileid aligning the VALUE part at "column" or less
 (if all name parts are shorter than "column") with the following
 addition:

    If a line contains any unprintable character(s), write two extra
    lines showing the left and right hex byte for each unprintable
    character after that line.

 Examine each line for extra wide Name= data, ambiguous 'Value=' data
 and content addressable stems and flag them.

Update history:
 09.09.2015 WP add hex display
 09.09.2015 LESK add preferred length
 10.09.2015 WP take care of
               tail4='..., Value='; a.tail4='>'tail4 tail4'<'
 02.10.2015 WP fix Problem with  vn=Countstr(', Value=',l.i)
                                 If vn=1 Then Do
 11.10.2015 WP fix Problem with  n=jj-1
*/
endhelp=thisline()-2
valid='abcdefghijklmnopqrstuvwxyz'
valid=valid||Translate(valid)'0123456789'
valid=valid' |!"%$&/()=?\`+*#'';:_,.-><@'
Address CMD
Parse Arg z f            /* Preferred size of Name column and fileid (LesK) */
If z=0 Then Exit

If z='' | f='' | \Datatype(z,'W') Then Do
  Do h=beghelp To endhelp
    Say Sourceline(h)
  End
  Exit
End

If Right(f,4)\='.SDV' Then Do
  Say 'expanded_dumpvars: The fileid must end with: .SDV'
  Exit
End

ptr='-->'
if userid()='Les Koehler' then do
  blob='fe'x
  ptr=blob'=>'
  valid=valid||blob
End
max=0
jj=0
Do i=1 By 1 While Lines(f)>0
  l.i=Linein(f)
--  Say i l.i
--  l.i=repl(l.i,'0d'x,'<CR>')
--  l.i=repl(l.i,'0a'x,'<LF>')
  l.i=changestr('<CR>',l.i,'0d'x) /* Restore the hex characters */
  l.i=changestr('<LF>',l.i,'0a'x)
  instring=0
  ll=''
  j=0
  Do j=1 To Length(l.i)
    c=Substr(l.i,j,1)
    Select
      When c='''' Then Do
        ll=ll||c
        If instring Then Do
          instring=0
        End
        Else  Do
          instring=1
        End
      End
      Otherwise Do
        If instring Then
          ll=ll'_'
        Else
          ll=ll||c
      End
    End
  End
  Call dbg l.i
  vn=Countstr(', Value=',l.i)
  If vn<=1 Then Do
    pv=Pos(', Value=',l.i)
    jj=jj+1
    a.jj=Left(l.i,pv)
    b.jj=Substr(l.i,pv+1)
    max=Max(max,Length(a.jj))
  End
  Else Do
    jj=jj+1
    a.jj='<<<Ambiguous Name/Value. '
    b.jj='Multiple occurences of '', Value=''.'
    ll=l.i
    Do k=1 By 1
      pv=Pos(', Value=',ll)
      If pv=0 Then Leave
      jj=jj+1
      a.jj=Left(l.i,pv)
      b.jj=Substr(l.i,pv+1)
      max=Max(max,Length(a.jj))
      ll=Overlay('_',ll,pv)
    End
    jj=jj+1
    a.jj='>>>One of the above is true.'
    b.jj=''
    jj=jj+1
    a.jj=''
    b.jj=''
  End
End
n=i-1
nn=jj
Call lineout f,,1
If max<z Then Do i=1 To nn /* All Names are shorter than column width */
  l.i=Left(a.i,max) b.i /* Write them to max width */
End
Else Do i=1 To nn /* Some names are longer than column width */
  Select
    When Length(a.i)<z Then /* If less, pad to column width */
      l.i=Left(a.i,z) b.i
    When left(a.i,3)='>>>' Then /* Marker! Leave asis */
      l.i=a.i
    Otherwise
      l.i=a.i ptr||strip(b.i,'L') /* Marked special */
    End
End
Do i=1 To nn
  Call lineout f,translate(l.i,'??','0D0A'x)
  If Verify(l.i,valid)>0 Then Do
    Call mk_hex l.i
    Call lineout f,hex.0left
    Call lineout f,hex.0rite
  End
End
Call lineout f

Return

MK_HEX: Procedure Expose valid hex.
  Parse Arg s
  sx=C2x(s)
  hex.=''
  Do i=1 To Length(s)
    If Pos(Substr(s,i,1),valid)>0 Then Do
      hex.0left=hex.0left||' '
      hex.0rite=hex.0rite||' '
    End
    Else Do
      hex.0left=hex.0left||Substr(sx,i*2-1,1)
      hex.0rite=hex.0rite||Substr(sx,i*2  ,1)
      lh=lh||Substr(sx,i*2-1,1)
    End
  End
  Return

DBG: Return
  Say Arg(1)
  Pull .
  Return
THISLINE: Return sigl
