// ------------------------ Apache Version 2.0 license -------------------------
//    Copyright 2015 Rony G. Flatscher
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.
// -----------------------------------------------------------------------------

#include <oorexxapi.h>
#include <stdio.h>

// -----------------------------------------------------
RexxMethod0(int,                    // return type
             NoArgMethodReturn123)  // native method name
{
    return 123;                     // return value
}

// -----------------------------------------------------
RexxMethod0(RexxObjectPtr,          // return type a Rexx Object Pointer
             NoArgMethodVoid)       // native method name
{
    fprintf(stdout, "(from native code) \"NoArgMethodVoid\"\n");
    return NULLOBJECT;              // indicate no return value !
}

// -----------------------------------------------------
RexxMethod1(int,                    // return type
             OneArgMethodReturnArg, // native method name
             OPTIONAL_int, arg1)             // argument
{
    fprintf(stdout, "(from native code) \"OneArgMethodReturnArg\": arg1=[%d]", arg1);
    fprintf(stdout, " argumentExists(1)=[%d], argumentOmitted(1)=[%d]\n",
                      argumentExists(1),      argumentOmitted(1));
    return arg1;                    // return value
}

// -----------------------------------------------------
RexxMethod1(RexxObjectPtr,          // return type a Rexx Object Pointer
             OneArgMethodVoid,      // native method name
             int, arg1)             // argument
{
    fprintf(stdout, "(from native code) \"OneArgMethodVoid\": arg1=[%d]\n", arg1);
    return NULLOBJECT;              // indicate no return value !
}

// -----------------------------------------------------
RexxMethod2(int,                    // return type
            TwoIntArgAdder,         // native method name
            int, arg1,              // argument 1
            int, arg2)              // argument 2
{
    return arg1 + arg2;             // return value
}

// -----------------------------------------------------
RexxMethod2(double,                 // return type
            TwoDoubleArgAdder,      // native method name
            double, arg1,           // argument 1
            double, arg2)           // argument 2
{
    return arg1 + arg2;             // return value
}

// -----------------------------------------------------
RexxMethod2(RexxObjectPtr,          // return type a Rexx Object Pointer
             OneArgInvokeOrxMethod, // native method name
             OSELF, self,           // pseudo-argument: allow access to object instance
             int, arg1)             // argument from Rexx program!
{
    fprintf(stdout, "(from native code) \"OneArgInvokeOrxMethod\": arg1=[%d]\n", arg1);
    fprintf(stdout, "(from native code) invoking method \"hello\" in this very same object:\n");
    context->SendMessage0(self,"HELLO");
    return NULLOBJECT;              // indicate no return value !
}


RexxMethodEntry orxtest_meths[] = {

    REXX_METHOD(NoArgMethodReturn123 , NoArgMethodReturn123 ),
    REXX_METHOD(NoArgMethodVoid      , NoArgMethodVoid      ),
    REXX_METHOD(OneArgMethodReturnArg, OneArgMethodReturnArg),
    REXX_METHOD(OneArgMethodVoid     , OneArgMethodVoid     ),
    REXX_METHOD(TwoIntArgAdder       , TwoIntArgAdder       ),
    REXX_METHOD(TwoDoubleArgAdder    , TwoDoubleArgAdder    ),
    REXX_METHOD(OneArgInvokeOrxMethod, OneArgInvokeOrxMethod),
    REXX_LAST_METHOD()                 // end marker
};


RexxPackageEntry DemoExternalMethods_package_entry = {
    STANDARD_PACKAGE_HEADER
    REXX_INTERPRETER_4_0_0,         // ooRexx version 4.0.0 or higher
    "ExternalMethodDemo",           // name of the package
    "1.0.0",                        // package information
    NULL,                           // no load function
    NULL,                           // no unload function
    NULL,                           // the exported routines
    orxtest_meths                   // the exported methods
};

// package loading stub.
OOREXX_GET_PACKAGE(DemoExternalMethods);

