// ------------------------ Apache Version 2.0 license -------------------------
//    Copyright 2015 Rony G. Flatscher
//
//    Licensed under the Apache License, Version 2.0 (the "License");
//    you may not use this file except in compliance with the License.
//    You may obtain a copy of the License at
//
//        http://www.apache.org/licenses/LICENSE-2.0
//
//    Unless required by applicable law or agreed to in writing, software
//    distributed under the License is distributed on an "AS IS" BASIS,
//    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//    See the License for the specific language governing permissions and
//    limitations under the License.
// -----------------------------------------------------------------------------

#include <oorexxapi.h>
#include <stdio.h>

// -----------------------------------------------------
RexxRoutine0(int,                   // return type
             NoArgRoutineReturn123) // native routine name
{
    return 123;                     // return value
}

// -----------------------------------------------------
RexxRoutine0(RexxObjectPtr,         // return type a Rexx Object Pointer
             NoArgRoutineVoid)      // native routine name
{
    fprintf(stdout, "(from native code) \"NoArgRoutineVoid\"\n");
    return NULLOBJECT;              // indicate no return value !
}

// -----------------------------------------------------
RexxRoutine1(int,                   // return type
             OneArgRoutineReturnArg,// native routine name
             OPTIONAL_int, arg1)    // optional argument
{
    fprintf(stdout, "(from native code) \"OneArgRoutineReturnArg\": arg1=[%d]", arg1);
    fprintf(stdout, " argumentExists(1)=[%d], argumentOmitted(1)=[%d]\n",
                      argumentExists(1),      argumentOmitted(1));
    return arg1;                    // return value
}

// -----------------------------------------------------
RexxRoutine1(RexxObjectPtr,         // return type a Rexx Object Pointer
             OneArgRoutineVoid,     // native routine name
             int, arg1)             // argument
{
    fprintf(stdout, "(from native code) \"OneArgRoutineVoid\": arg1=[%d]\n", arg1);
    return NULLOBJECT;              // indicate no return value !
}

// -----------------------------------------------------
RexxRoutine2(int,                   // return type
            TwoIntArgAdder,         // native routine name
            int, arg1,              // argument 1
            int, arg2)              // argument 2
{
    return arg1 + arg2;             // return value
}

// -----------------------------------------------------
RexxRoutine2(double,                // return type
            TwoDoubleArgAdder,      // native routine name
            double, arg1,           // argument 1
            double, arg2)           // argument 2
{
    return arg1 + arg2;             // return value
}


RexxRoutineEntry orxtest_funcs[] = {

    REXX_TYPED_ROUTINE(NoArgRoutineReturn123 , NoArgRoutineReturn123 ),
    REXX_TYPED_ROUTINE(NoArgRoutineVoid      , NoArgRoutineVoid      ),
    REXX_TYPED_ROUTINE(OneArgRoutineReturnArg, OneArgRoutineReturnArg),
    REXX_TYPED_ROUTINE(OneArgRoutineVoid     , OneArgRoutineVoid     ),
    REXX_TYPED_ROUTINE(TwoIntArgAdder        , TwoIntArgAdder        ),
    REXX_TYPED_ROUTINE(TwoDoubleArgAdder     , TwoDoubleArgAdder     ),
    REXX_LAST_ROUTINE()                 // end marker
};


RexxPackageEntry DemoExternalRoutines_package_entry = {
    STANDARD_PACKAGE_HEADER
    REXX_INTERPRETER_4_0_0,         // ooRexx version 4.0.0 or higher
    "ExternalRoutineDemo",          // name of the package
    "1.0.0",                        // package information
    NULL,                           // no load function
    NULL,                           // no unload function
    orxtest_funcs,                  // the exported routines
    NULL                            // the exported methods
};

// package loading stub.
OOREXX_GET_PACKAGE(DemoExternalRoutines);

