# usage: nmake /f MakefileWindows.mak [all32 | all64]

# ------------------------ Apache Version 2.0 license -------------------------
#    Copyright (C) 2015 Rony G. Flatscher
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.
# -----------------------------------------------------------------------------

!IF DEFINED(REXX_HOME)
INCLUDE = $(INCLUDE);$(REXX_HOME)\api
LIB = $(LIB);$(REXX_HOME)\api
!ENDIF


WARNINGFLAGS    = /W3 /D_CRT_SECURE_NO_DEPRECATE /D_CRT_NONSTDC_NO_DEPRECATE
OOREXX_CFLAGS   = /nologo /EHsc /O2 /Gr /Gs /FAcs /MT $(WARNINGFLAGS) /c

# 64-bit, just add a warning flag
WARNINGFLAGS64  = /Wp64 $(WARNINGFLAGS)
OOREXX_CFLAGS64 = /nologo /EHsc /O2 /Gr /Gs /FAcs /MT $(WARNINGFLAGS64) /c

REXX_LIBS = rexx.lib rexxapi.lib
DLL_LFLAGS = /nologo /SUBSYSTEM:Windows $(REXX_LIBS) /DLL /def:

# for 64-bit: must for linking
BUFFEROVERFLOWU = bufferoverflowu.lib

# default target
all:
	@echo "creates the external (native) library routine and method dll's"
	@echo "usage: nmake /f MakeFileWindows.mak [all32 | all64]"


# create 32 bit dlls
all32:  clean_all make_dll32 clean_all_but_dll


make_dll32:
	@echo "... make_dll ..."
	@echo "OOREXX_CFLAGS:" $(OOREXX_CFLAGS)
	@echo "DLL_LFLAGS   :" $(DLL_LFLAGS)
	@echo "--->"

	cl $(OOREXX_CFLAGS) /Foextsimple.obj extsimple.cpp
	link $(DLL_LFLAGS)extsimple.def extsimple.obj -out:extsimple.dll

	cl $(OOREXX_CFLAGS) /Foextfunc.obj   extfunc.cpp
	link $(DLL_LFLAGS)extfunc.def   extfunc.obj   -out:extfunc.dll

	cl $(OOREXX_CFLAGS) /Foextmeth.obj   extmeth.cpp
	link $(DLL_LFLAGS)extmeth.def   extmeth.obj   -out:extmeth.dll
	@echo "... make_dll done."
	@echo "<---"

# create 64 bit dlls
all64:  clean_all make_dll64 clean_all_but_dll

make_dll64:
	@echo "... make_dll ..."
	@echo "OOREXX_CFLAGS64:" $(OOREXX_CFLAGS64)
	@echo "DLL_LFLAGS     :" $(DLL_LFLAGS)
	@echo "--->"

	cl $(OOREXX_CFLAGS64) /Foextsimple.obj extsimple.cpp
	link $(DLL_LFLAGS)extsimple.def extsimple.obj $(BUFFEROVERFLOWU) -out:extsimple.dll

	cl $(OOREXX_CFLAGS64) /Foextfunc.obj   extfunc.cpp
	link $(DLL_LFLAGS)extfunc.def   extfunc.obj   $(BUFFEROVERFLOWU) -out:extfunc.dll

	cl $(OOREXX_CFLAGS64) /Foextmeth.obj   extmeth.cpp
	link $(DLL_LFLAGS)extmeth.def   extmeth.obj   $(BUFFEROVERFLOWU) -out:extmeth.dll
	@echo "... make_dll done."
	@echo "<---"

# clean up routines
clean_all:
	@echo "... clean_all ..."
	attrib -h *.suo 1>nul 2>&1
	del *.dll *.obj *.ilk *.pdb *.lib *.exp *.suo *.cod *.res *.sln *.map 1>nul 2>&1
	@echo "... clean_all done."

clean_all_but_dll:
	@echo "... clean_all_but_dll ..."
	attrib -h *.suo 1>nul 2>&1
	del *.obj *.ilk *.pdb *.lib *.exp *.suo *.cod *.res *.sln *.map 1>nul 2>&1
	@echo "... clean_all_but_dll done."




