# make -f MakefileLinux.mak [ all32 | all64 ]

# ------------------------ Apache Version 2.0 license -------------------------
#    Copyright (C) 2015 Rony G. Flatscher
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.
# -----------------------------------------------------------------------------

INC_PATH = -I/opt/ooRexx/include -I. -I/usr/local/include -I/usr/include
LIB_PATH = -L. -L/usr/local/lib -L/usr/lib -L/opt/ooRexx/lib

CFLAGS		= -fPIC -c -O3
LINK_FLAGS      = -shared -rdynamic -lpthread -lc  -lm -lrexx -lrexxapi -lrexxutil

#----------------------------------------------------------
all32: clean clean_so make_so_32

make_so_32:
	echo
	echo Building 32 bit libraries ...
	echo
	g++ $(CFLAGS) -m32 -oextfunc.o   $(INC_PATH) $(LIB_PATH) extfunc.cpp
	g++ $(CFLAGS) -m32 -oextmeth.o   $(INC_PATH) $(LIB_PATH) extmeth.cpp
	g++ $(CFLAGS) -m32 -oextsimple.o $(INC_PATH) $(LIB_PATH) extsimple.cpp

	g++ -Wl,-soname,libextfunc.so   -o libextfunc.so   extfunc.o   $(LIB_PATH) $(LINK_FLAGS)
	g++ -Wl,-soname,libextmeth.so   -o libextmeth.so   extmeth.o   $(LIB_PATH) $(LINK_FLAGS)
	g++ -Wl,-soname,libextsimple.so -o libextsimple.so extsimple.o $(LIB_PATH) $(LINK_FLAGS)

#----------------------------------------------------------
all64: clean clean_so make_so_64

make_so_64:
	echo
	echo Building 64 bit libraries ...
	echo
	g++ $(CFLAGS) -m64 -oextfunc.o   $(INC_PATH) $(LIB_PATH) extfunc.cpp
	g++ $(CFLAGS) -m64 -oextmeth.o   $(INC_PATH) $(LIB_PATH) extmeth.cpp
	g++ $(CFLAGS) -m64 -oextsimple.o $(INC_PATH) $(LIB_PATH) extsimple.cpp

	g++ -Wl,-soname,libextfunc.so   -o libextfunc.so   extfunc.o   $(LIB_PATH) $(LINK_FLAGS)
	g++ -Wl,-soname,libextmeth.so   -o libextmeth.so   extmeth.o   $(LIB_PATH) $(LINK_FLAGS)
	g++ -Wl,-soname,libextsimple.so -o libextsimple.so extsimple.o $(LIB_PATH) $(LINK_FLAGS)


clean:
	rm -f *.o

clean_so:
	rm -f *.so

