# usage: make -f MakefileApple.mak [all | i386 | x86_64 | universal | clean | clean_all ]

# ------------------------ Apache Version 2.0 license -------------------------
#    Copyright (C) 2015 Rony G. Flatscher
#
#    Licensed under the Apache License, Version 2.0 (the "License");
#    you may not use this file except in compliance with the License.
#    You may obtain a copy of the License at
#
#        http://www.apache.org/licenses/LICENSE-2.0
#
#    Unless required by applicable law or agreed to in writing, software
#    distributed under the License is distributed on an "AS IS" BASIS,
#    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#    See the License for the specific language governing permissions and
#    limitations under the License.
# -----------------------------------------------------------------------------


# allow earlier versions of MacOSX to use the lib, e.g.
# export MACOSX_DEPLOYMENT_TARGET=10.6
# echo $MACOSX_DEPLOYMENT_TARGET

# the following paths are according to the MacOSX rules (obeyed e.g. by BSF4ooRexx)
INC_PATH_ALL = -I . -I/System/Library/Frameworks/ooRexx.framework/Versions/Current/Headers
LIB_2_REXX = /System/Library/Frameworks/ooRexx.framework/Libraries

CFLAGS = -fPIC
LFLAGS = -shared

# --------------------------------------------------- needs 64-bit ooRexx installed currently
x86_64:
	g++ -c $(CFLAGS) $(INC_PATH_ALL) -m64 -arch x86_64 -oextfunc.o   extfunc.cpp
	g++ -c $(CFLAGS) $(INC_PATH_ALL) -m64 -arch x86_64 -oextmeth.o   extmeth.cpp
	g++ -c $(CFLAGS) $(INC_PATH_ALL) -m64 -arch x86_64 -oextsimple.o extsimple.cpp

	g++ -dynamiclib $(LFLAGS) -o libextfunc-x86_64.dylib   extfunc.o   $(LIB_2_REXX)/librexx.dylib $(LIB_2_REXX)/librexxapi.dylib -arch x86_64
	g++ -dynamiclib $(LFLAGS) -o libextmeth-x86_64.dylib   extmeth.o   $(LIB_2_REXX)/librexx.dylib $(LIB_2_REXX)/librexxapi.dylib -arch x86_64
	g++ -dynamiclib $(LFLAGS) -o libextsimple-x86_64.dylib extsimple.o $(LIB_2_REXX)/librexx.dylib $(LIB_2_REXX)/librexxapi.dylib -arch x86_64

	cp -p libextfunc-x86_64.dylib   libextfunc.dylib
	cp -p libextmeth-x86_64.dylib   libextmeth.dylib
	cp -p libextsimple-x86_64.dylib libextsimple.dylib


# -------------------------------------------------------- needs 32-bit ooRexx installed currently
i386:
	g++ -c $(CFLAGS) $(INC_PATH_ALL) -m32 -arch i386 -oextfunc.o   extfunc.cpp
	g++ -c $(CFLAGS) $(INC_PATH_ALL) -m32 -arch i386 -oextmeth.o   extmeth.cpp
	g++ -c $(CFLAGS) $(INC_PATH_ALL) -m32 -arch i386 -oextsimple.o extsimple.cpp

	g++ -dynamiclib $(LFLAGS) -o libextfunc-i386.dylib   extfunc.o   $(LIB_2_REXX)/librexx.dylib $(LIB_2_REXX)/librexxapi.dylib -arch i386
	g++ -dynamiclib $(LFLAGS) -o libextmeth-i386.dylib   extmeth.o   $(LIB_2_REXX)/librexx.dylib $(LIB_2_REXX)/librexxapi.dylib -arch i386
	g++ -dynamiclib $(LFLAGS) -o libextsimple-i386.dylib extsimple.o $(LIB_2_REXX)/librexx.dylib $(LIB_2_REXX)/librexxapi.dylib -arch i386

	cp -p libextfunc-i386.dylib   libextfunc.dylib
	cp -p libextmeth-i386.dylib   libextmeth.dylib
	cp -p libextsimple-i386.dylib libextsimple.dylib

# ---------------------------------------------------
universal: clean_all i386 x86_64
	lipo -create -output libextfunc.dylib   -arch x86_64 libextfunc-x86_64.dylib   -arch i386 libextfunc-i386.dylib
	lipo -create -output libextmeth.dylib   -arch x86_64 libextmeth-x86_64.dylib   -arch i386 libextmeth-i386.dylib
	lipo -create -output libextsimple.dylib -arch x86_64 libextsimple-x86_64.dylib -arch i386 libextsimple-i386.dylib

# ---------------------------------------------------


.PHONY: clean_all
clean_all:
	rm -f *.dylib
	rm -f *.o

.PHONY: clean
clean:
	rm -f *i386.dylib *x86_64.dylib
	rm -f *.o


