<!-- /*                                                                              */ -->
<!-- /*  name:        log.xsl                                                        */ -->
<!-- /*  author:      Rainer Kegel                                                   */ -->
<!-- /*  date:        2007-01-02                                                     */ -->
<!-- /*                                                                              */ -->
<!-- /*  purpose:     part of the Test Runner Application for ooRexxUnit             */ -->
<!-- /*               - provides general structures and routines                     */ -->
<!-- /*                                                                              */ -->
<!-- /*  license:     CPL 1.0 (Common Public License v1.0, see below)                */ -->
<!-- /*                                                                              */ -->
<!-- /*                                                                              */ -->
<!-- /*                                                                              */ -->
<!-- /*                                                                              */ -->
<!-- /*  Copyright (c) 2007 Rainer Kegel. All rights reserved.                       */ -->
<!-- /*                                                                              */ -->
<!-- /*  This program and the accompanying materials are made available under        */ -->
<!-- /*  the terms of the Common Public License v1.0 which accompanies this          */ -->
<!-- /*  distribution. A copy is also available at the following address:            */ -->
<!-- /*  http://www.opensource.org/licenses/cpl1.0.php                               */ -->
<!-- /*                                                                              */ -->
<!-- /*  Redistribution and use in source and binary forms, with or                  */ -->
<!-- /*  without modification, are permitted provided that the following             */ -->
<!-- /*  conditions are met:                                                         */ -->
<!-- /*                                                                              */ -->
<!-- /*  Redistributions of source code must retain the above copyright              */ -->
<!-- /*  notice, this list of conditions and the following disclaimer.               */ -->
<!-- /*  Redistributions in binary form must reproduce the above copyright           */ -->
<!-- /*  notice, this list of conditions and the following disclaimer in             */ -->
<!-- /*  the documentation and/or other materials provided with the distribution.    */ -->
<!-- /*                                                                              */ -->
<!-- /*  Neither the name of Rexx Language Association nor the names                 */ -->
<!-- /*  of its contributors may be used to endorse or promote products              */ -->
<!-- /*  derived from this software without specific prior written permission.       */ -->
<!-- /*                                                                              */ -->
<!-- /*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS         */ -->
<!-- /*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT           */ -->
<!-- /*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS           */ -->
<!-- /*  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT    */ -->
<!-- /*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       */ -->
<!-- /*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED    */ -->
<!-- /*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,         */ -->
<!-- /*  OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY      */ -->
<!-- /*  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING     */ -->
<!-- /*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS          */ -->
<!-- /*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                */ -->
<!-- /*                                                                              */ -->
<!-- /*                                                                              */ -->


<?xsl version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

   <xsl:template match="/">
      <html>
         <head>
            <link rel='stylesheet' href='log.css' type='text/css' />
            <script language="Object Rexx" src="log_xsl_script.rex"></script>
         </head>
         <body class="var1">
            <div class="var2">
               <xsl:apply-templates />
            </div>
            <div class="var3">
               <input type="button" style="width:100px" value="hide okay" id="buttonokay" alt="show/hide okay" onclick="call okay" />
               <input type="button" style="width:100px" value="hide failure" id="buttonfailure" alt="show/hide failure" onclick="call failure" />
               <input type="button" style="width:100px" value="hide error" id="buttonerror" alt="show/hide error" onclick="call error" />
            </div>
         </body>
      </html>
   </xsl:template>

   <xsl:template match="username">
      <table width="50%">
         <tr>
            <td class="var4">USERNAME:</td>
            <td colspan="2"  class="var5"><xsl:value-of select="." /></td>
            <td></td>
         </tr>
      </table>
      <p></p>
   </xsl:template>

   <xsl:template match="comment">
      <table width="50%">
         <tr>
            <td class="var4">COMMENT:</td>
            <td colspan="2" class="var6"><xsl:value-of select="." /></td>
            <td></td>
         </tr>
      </table>
      <p></p>
   </xsl:template>

   <xsl:template match="runs">
      <table width="50%">
         <tr>
            <td class="var4">COUNTS:</td>
            <td>
               <table class="var6" width="100%">
                  <tr>
                     <xsl:apply-templates select="testruns" />
                  </tr>
                  <tr>
                     <xsl:apply-templates select="errcounts" />
                  </tr>
                  <tr>
                     <xsl:apply-templates select="failcount" />
                  </tr>
                  <tr>
                     <xsl:apply-templates select="runcount" />
                  </tr>
               </table>
            </td>
         </tr>
      </table>
      <p></p>
   </xsl:template>

   <xsl:template match="testruns">
      <td class="var7">TESTRUNS:</td>
      <td class="var8"><xsl:value-of select="." /></td>
   </xsl:template>

   <xsl:template match="errcounts">
      <td class="var7">ERRORCOUNTS:</td>
      <td class="var8"><xsl:value-of select="." /></td>
   </xsl:template>

   <xsl:template match="failcount">
      <td class="var7">FAILURECOUNTS:</td>
      <td class="var8"><xsl:value-of select="." /></td>
   </xsl:template>

   <xsl:template match="runcount">
      <td class="var7">RUNCOUNTS:</td>
      <td class="var8"><xsl:value-of select="." /></td>
   </xsl:template>



   <xsl:template match="starttestsuite|startdatets">
      <table class="testsuite">
         <tr>
            <td class="var17">Testsuite started:</td>
            <td class="var18"><xsl:value-of select="." /></td>
         </tr>
      </table>
   </xsl:template>

   <xsl:template match="maintestunit">
      <table width="100%">
         <xsl:if test="@id">
            <xsl:attribute name="id">
               <xsl:value-of select="@id" />
            </xsl:attribute>
         </xsl:if>
         <tr>
            <td>
               <xsl:apply-templates />
            </td>
         </tr>
      </table>
   </xsl:template>

   <xsl:template match="startend">
      <tr>
         <td class="space"></td>
      </tr>
      <table class="testcase">
         <tr>
            <th colspan="4" class="var9">
               <xsl:apply-templates select="namemain"/>
            </th>
            <th></th><th></th><th></th>
         </tr>
         <tr>
            <xsl:apply-templates select="mainstartdate"/>
            <xsl:apply-templates select="mainstarttime"/>
         </tr>
         <tr>
            <xsl:apply-templates select="mainenddate"/>
            <xsl:apply-templates select="mainendtime"/>
         </tr>
      </table>
   </xsl:template>

   <xsl:template match="namemain">
      <xsl:value-of select="." />
   </xsl:template>

   <xsl:template match="mainstartdate">
      <td class="var10">Start:</td>
      <td class="var11"><xsl:value-of select="." /></td>
   </xsl:template>

   <xsl:template match="mainenddate">
      <td class="var10">End:</td>
      <td class="var11"><xsl:value-of select="." /></td>
   </xsl:template>

   <xsl:template match="mainstarttime | mainendtime">
      <td style="text-align:left;" width="12%;">
         <xsl:value-of select="." />
      </td>
   </xsl:template>

   <xsl:template match="subtest">
      <table width="100%">
         <xsl:if test="@id">
            <xsl:attribute name="id">
               <xsl:value-of select="@id" />
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@value">
            <xsl:attribute name="value">
               <xsl:value-of select="@value" />
            </xsl:attribute>
         </xsl:if>
         <xsl:choose>
            <xsl:when test="@value='failure'">
               <xsl:attribute name="class">failure</xsl:attribute>
            </xsl:when>
            <xsl:when test="@value='error'">
               <xsl:attribute name="class">error</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
               <xsl:attribute name="class">okay</xsl:attribute>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:apply-templates />
         <tr>
            <td height="10px" bgcolor="#e0e0e0"></td>
         </tr>
      </table>
   </xsl:template>

   <xsl:template match="name">
      <tr>
         <th colspan="4" class="var12">
            <xsl:value-of select="." />
         </th>
      </tr>
   </xsl:template>

   <xsl:template match="main">
      <tr>
         <th /><th /><th />
         <th class="var13" colspan="2">
            <xsl:value-of select="." />
         </th>
      </tr>
   </xsl:template>

   <xsl:template match="linestart">
      <tr>
         <td colspan="3">
           <table>
		     <tr>
		       <xsl:apply-templates select="substartdate" />
               <xsl:apply-templates select="substarttime" />
		     </tr>
		   </table>
         </td>
      </tr>
   </xsl:template>

   <xsl:template match="substarttime">
      <td class="var9"><xsl:value-of select="." /></td>
   </xsl:template>

   <xsl:template match="substartdate">
      <td class="var16">START:</td><td class="var9"><xsl:value-of select="." /></td>
   </xsl:template>

   <xsl:template match="lineend">
      <tr>
         <td colspan="3">
           <table>
		     <tr>
		       <xsl:apply-templates select="subenddate" />
               <xsl:apply-templates select="subendtime" />
		     </tr>
		   </table>
         </td>
      </tr>
   </xsl:template>

   <xsl:template match="subendtime">
      <td class="var9"><xsl:value-of select="." /></td>
   </xsl:template>

   <xsl:template match="subenddate">
      <td class="var16">END:</td><td class="var9"><xsl:value-of select="." /></td>
   </xsl:template>

   <xsl:template match="status">
      <tr>
         <th class="var9"><xsl:value-of select="." /></th>
      </tr>
   </xsl:template>

   <xsl:template match="infotable">
      <table width="100%;">
         <xsl:choose>
            <xsl:when test="@value='failure'">
               <xsl:attribute name="class">failure</xsl:attribute>
            </xsl:when>
            <xsl:when test="@value='error'">
               <xsl:attribute name="class">error</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
               <xsl:attribute name="class">okay</xsl:attribute>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:apply-templates>
            <xsl:sort select="@index"></xsl:sort>
         </xsl:apply-templates>
      </table>
   </xsl:template>

   <xsl:template match="line">
      <tr>
         <xsl:apply-templates />
      </tr>
   </xsl:template>

   <xsl:template match="lineadd">
      <tr>
         <xsl:apply-templates />
      </tr>
   </xsl:template>

   <xsl:template match="info">
      <td style="text-align:left;">
         <xsl:choose>
            <xsl:when test="@col='span'">
               <xsl:attribute name="colspan">3</xsl:attribute>
               <xsl:attribute name="class">var14</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
               <xsl:attribute name="style">font-size:11px;</xsl:attribute>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:value-of select="." />
      </td>
   </xsl:template>

   <xsl:template match="endtestsuite">
      <table class="testsuite">
         <tr>
            <td>Time testsuite ended: <xsl:value-of select="." /></td>
         </tr>
      </table>
   </xsl:template>

   <xsl:template match="enddatets">
      <table class="testsuite">
         <tr>
            <td>Date testsuite ended: <xsl:value-of select="." /></td>
         </tr>
      </table>
   </xsl:template>

   <xsl:template match="subtestnumber">
      <table>
         <xsl:if test="@id">
            <xsl:attribute name="id">
               <xsl:value-of select="@id" />
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@value">
            <xsl:attribute name="value">
               <xsl:value-of select="@value" />
            </xsl:attribute>
         </xsl:if>
      </table>
   </xsl:template>

</xsl:stylesheet>