#!/usr/bin/rexx
/* ---rgf, 2007-04-28, Washington airport, wg. TeRA   */

parse arg file

iStr=" "~copies(3)      -- indent string
inTable =xrange("00"x, "1f"x)
outTable=" "~copies(length(inTable))

call sysFileTree file, "files.", "FO"
say "using" file", found:" files.0 "file(s)"

do i=1 to files.0
   say "working on file:" files.i
   parse var files.i 1 stem "." ext
   outfile=stem".rex"
   if stream(outfile, "C", "query exists")<>"" then
   do
      say "output file ["outfile"] exists already, skipping ..."
      iterate
   end

   indent=0
   do while chars(files.i)>0
      line=linein(files.i)~translate(outTable, inTable)~strip

      word=word(line, 1)~translate

      if indent>0 & (word="END" | left(word,2)="::" ) then       -- outdent before writing end-line
      do
         indent=indent-1
         if indent<0 then
            indent=0
      end

      call lineout outfile, iStr~copies(indent) || line

      if wordpos(word,"DO LOOP")>0 then   -- indent next line
         indent=indent+1
      else if word~left(2)="::" then      -- indent next line
         indent=1
   end
   call stream outfile, "C", "close"
end



