<!-- /*                                                                              */ -->
<!-- /*  name:        complog.xsl                                                    */ -->
<!-- /*  author:      Rainer Kegel                                                   */ -->
<!-- /*  date:        2007-01-02                                                     */ -->
<!-- /*                                                                              */ -->
<!-- /*  purpose:     part of the Test Runner Application for ooRexxUnit             */ -->
<!-- /*               - provides general structures and routines                     */ -->
<!-- /*                                                                              */ -->
<!-- /*  license:     CPL 1.0 (Common Public License v1.0, see below)                */ -->
<!-- /*                                                                              */ -->
<!-- /*                                                                              */ -->
<!-- /*                                                                              */ -->
<!-- /*                                                                              */ -->
<!-- /*  Copyright (c) 2007 Rainer Kegel. All rights reserved.                       */ -->
<!-- /*                                                                              */ -->
<!-- /*  This program and the accompanying materials are made available under        */ -->
<!-- /*  the terms of the Common Public License v1.0 which accompanies this          */ -->
<!-- /*  distribution. A copy is also available at the following address:            */ -->
<!-- /*  http://www.opensource.org/licenses/cpl1.0.php                               */ -->
<!-- /*                                                                              */ -->
<!-- /*  Redistribution and use in source and binary forms, with or                  */ -->
<!-- /*  without modification, are permitted provided that the following             */ -->
<!-- /*  conditions are met:                                                         */ -->
<!-- /*                                                                              */ -->
<!-- /*  Redistributions of source code must retain the above copyright              */ -->
<!-- /*  notice, this list of conditions and the following disclaimer.               */ -->
<!-- /*  Redistributions in binary form must reproduce the above copyright           */ -->
<!-- /*  notice, this list of conditions and the following disclaimer in             */ -->
<!-- /*  the documentation and/or other materials provided with the distribution.    */ -->
<!-- /*                                                                              */ -->
<!-- /*  Neither the name of Rexx Language Association nor the names                 */ -->
<!-- /*  of its contributors may be used to endorse or promote products              */ -->
<!-- /*  derived from this software without specific prior written permission.       */ -->
<!-- /*                                                                              */ -->
<!-- /*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS         */ -->
<!-- /*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT           */ -->
<!-- /*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS           */ -->
<!-- /*  FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT    */ -->
<!-- /*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,       */ -->
<!-- /*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED    */ -->
<!-- /*  TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,         */ -->
<!-- /*  OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY      */ -->
<!-- /*  OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING     */ -->
<!-- /*  NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS          */ -->
<!-- /*  SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.                */ -->
<!-- /*                                                                              */ -->
<!-- /*                                                                              */ -->


<?xsl version="1.0" encoding="ISO-8859-1"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

   <xsl:template match="/">
      <html>
         <head>
            <link rel='stylesheet' href='complog.css' type='text/css' />
            <script language="object rexx" src="complog_xsl_script.rex"></script>
         </head>
         <body onload="call buttons">
            <div id="content_container">
               <xsl:apply-templates />
            </div>
            <div id="footer">
               <input type="button" id="buttonchanges" onclick="call changes" value="hide changes"></input>
               <input type="button" id="buttonlog1" onclick="call log1"  value="hide log1"></input>
               <input type="button" id="buttonlog2" onclick="call log2"  value="hide log2"></input>
               <input type="button" id="buttonrunboth" onclick="call runboth"  value="hide runboth"></input>
               <input type="button" id="buttonrunonce" onclick="call runonce"  value="hide runonce"></input>
               <span style="width:10%;"> </span>
               <span id="leg1" style="background:#C6B5DE; font-size:12px;">test case in this log only</span>
               <span style="width:10px;"> </span>
               <span id="leg2" style="background:#e0e0e0; font-size:12px;">test case in both logs</span>
            </div>
         </body>
      </html>
   </xsl:template>

   <xsl:template match="changes">
      <table width="100%">
         <tr>
            <td>
               <xsl:apply-templates />
            </td>
         </tr>			
      </table>
      <p/>
   </xsl:template>

   <xsl:template match="headline">
      <tr>
         <th colspan="2" class="var1">
            <xsl:value-of select="." />
         </th>
      </tr>
      <tr></tr>
   </xsl:template>

   <xsl:template match="name1">
      <td class="var2">
         <xsl:value-of select="." />
      </td>
   </xsl:template>

   <xsl:template match="name2">
      <td class="var2">
         <xsl:value-of select="." />
      </td>
      <tr></tr>
      </xsl:template>

   <xsl:template match="tutable">
      <table class="changes">
         <tr>
            <td class="var3">
               <xsl:apply-templates select="table1"></xsl:apply-templates>
            </td>
            <td class="var3">
               <xsl:apply-templates select="table2"></xsl:apply-templates>
            </td>
         </tr>
      </table>
      <p></p>
   </xsl:template>

   <xsl:template match="table1 | table2">
      <table>
         <xsl:apply-templates>
            <xsl:sort select="@index" data-type="text"></xsl:sort>
            <xsl:sort select="@nindex" data-type="number"></xsl:sort>
         </xsl:apply-templates>
      </table>
   </xsl:template>

   <xsl:template match="line1 | line2">
      <tr>
         <xsl:apply-templates />
      </tr>
   </xsl:template>

   <xsl:template match="complog1 | complog2">
      <td style="font-size:11px;">
		  <xsl:if test="@check='d'">
		     <xsl:attribute name="class">width</xsl:attribute>
		  </xsl:if>
         <xsl:choose>
            <xsl:when test="@col='span'">
               <xsl:attribute name="colspan">3</xsl:attribute>
            </xsl:when>
            <xsl:when test="@index='AAAAAAAAAA'">
               <xsl:attribute name="style">font-weight:bold;</xsl:attribute>
            </xsl:when>
            <xsl:when test="@value='diff'">
               <xsl:attribute name="class">yellow</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
               <xsl:attribute name="bgcolor">#E0E0E0</xsl:attribute>
            </xsl:otherwise>
         </xsl:choose>
         <xsl:value-of select="." />
      </td>
   </xsl:template>

   <xsl:template match="log1">
      <table class="log1">
         <tr>
            <xsl:apply-templates />
         </tr>			
      </table>
      <p/>
   </xsl:template>
   
   <xsl:template match="log2">
      <table class="log2">
         <tr>
            <xsl:apply-templates />
         </tr>			
      </table>
      <p/>
   </xsl:template>

   <xsl:template match="testname">
      <tr>
         <xsl:if test="@id">
            <xsl:attribute name="id">
               <xsl:value-of select="@id" />
            </xsl:attribute>
         </xsl:if>
         <xsl:if test="@value">
            <xsl:attribute name="value">
               <xsl:value-of select="@value" />
            </xsl:attribute>
         </xsl:if>
         <xsl:choose>
            <xsl:when test="@value='not'">
               
               <xsl:attribute name="class">runonce</xsl:attribute>
            </xsl:when>
            <xsl:otherwise>
               
               <xsl:attribute name="class">runboth</xsl:attribute>
            </xsl:otherwise>
         </xsl:choose>
      <th style="text-align:left; font-size:11px;"><xsl:value-of select="." /></th>
      </tr>
   </xsl:template>

</xsl:stylesheet>