/*
name:             TeRA_script.rex
author:           Rainer Kegel
date:             2007-01-02

purpose:          part of the Test Runner Application for ooRexxUnit
- provides routines for TeRA.hta

license:          CPL 1.0 (Common Public License v1.0, see below)

*/

/*----------------------------------------------------------------------------*/
/*                                                                            */
/* Copyright (c) 2007 Rainer Kegel. All rights reserved.                      */
/*                                                                            */
/* This program and the accompanying materials are made available under       */
/* the terms of the Common Public License v1.0 which accompanies this         */
/* distribution. A copy is also available at the following address:           */
/* http://www.opensource.org/licenses/cpl1.0.php                              */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or                 */
/* without modification, are permitted provided that the following            */
/* conditions are met:                                                        */
/*                                                                            */
/* Redistributions of source code must retain the above copyright             */
/* notice, this list of conditions and the following disclaimer.              */
/* Redistributions in binary form must reproduce the above copyright          */
/* notice, this list of conditions and the following disclaimer in            */
/* the documentation and/or other materials provided with the distribution.   */
/*                                                                            */
/* Neither the name of Rexx Language Association nor the names                */
/* of its contributors may be used to endorse or promote products             */
/* derived from this software without specific prior written permission.      */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS          */
/* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT   */
/* OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,      */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,        */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     */
/* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         */
/* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               */
/*                                                                            */
/*----------------------------------------------------------------------------*/


::routine SelectedTestUnits public
   a=username~value      --get value of username
   nospace=a~translate('__________','"/?* :\<>|+()[]{}&%$!~;#')      --translate special characters
   a=nospace
   b=comment~value      --get value of comment
   home=syssearchpath('path','xmlparser.cls')      --get the right path
   win=countstr("\",home)
   lin=countstr("/",home)
   if win>=1 then op="\"
   if lin>=1 then op="/"
   posname=pos('xmlparser.cls',home)      --edit path
   file=substr(home,1,posname-2)
   TeRAfiles=file||op||'TeRA_files'
   actTests=TeRAfiles||op||'actTests.txt'
   userinformation=TeRAfiles||op||'userinformation.txt'
   call lineout userinformation,a      --write username to file
   call lineout userinformation,b      --write comment to file
   rc=stream(userinformation,'C','close')
   set=(output~value)
   LogFileList=.list~of()
   form = document~forms~item(0)
   name='TU'
   do i=0 to set
      check = form~item(name||i)~checked      --item checked or not
      if check=.true then
      do
         selection=form~item(name||i)~value      --if checked then get value
         sel=compare(selection,'level')
         if sel=1 then
         do
            LogFileList~insert(selection)
            gg=LogfileList~items
            if gg\=0 then
            call lineout actTests,selection      --write test values to file (info for TeRA-runtestsandedit.rex)
         end
      end
   end
   noi=LogfileList~items      --the following code: if no test is checked - alert!
   if noi=0
   then call rxmessagebox 'to run a test, you have to choose at least one testunit'
   rc=stream(actTests,'C','close')
   ab=LogfileList~items
   if ab\=0 then
   do
      editadress=syssearchpath('path','TeRA-runTestsandEdit.rex')
      address cmd 'rexx 'editadress
      location~reload()
   end
   
::routine openLastLog public
   address cmd 'rexx TeRA-openLastLog.rex'
   
::routine compareLogFiles public
   address cmd 'rexx TeRA-compareLogs.rex'
   
::routine invert public
   set=(output~value)
   form = document~forms~item(0)
   name='TU'
   do i=0 to set
      check = form~item(name||i)~checked      --if item is checked then uncheck it onclick
      if check=1 then
      do
         form~item(name||i)~checked=0
      end
      if check=0 then
      do
         getid=form~item(name||i)~id
         idcomp=compare('all',getid)
         if idcomp=1 then
         form~item(name||i)~checked=true
         if idcomp=4 then
         form~item(name||i)~checked=0
      end
   end
   
::routine uncheckAll public
   set=(output~value)
   form = document~forms~item(0)
   name='TU'
   do i=0 to set
      form~item(name||i)~checked=0
   end
   
::routine checkAll public
   set=(output~value)
   form = document~forms~item(0)
   name='TU'
   do i=0 to set
      form~item(name||i)~checked=1
   end
   
::routine openAll public      --open all folders
   xset=output3~value
   do h=0 to xset
      des=TB||h
      document~getElementbyID(des)~style~display='inline'
   end
   
::routine closeAll public      --close all folders
   xset=output3~value
   do h=0 to xset
      des=TB||h
      document~getElementbyID(des)~style~display='none'
   end
   
::routine checkmore public
   set=(output~value)
   form = document~forms~item(0)
   name='TU'
   do i=0 to set
      idstat = form~item(name||i)~id
      r=compare('all',idstat)
      if r=4 then
      do
         check=form~item(name||i)~checked
         if check=1 then
         do
            blevel=form~item(name||i)~value
            ilevel=substr(blevel,2)
            do x=i+1 to set
               bval=form~item(name||x)~value
               home=syssearchpath('path','xmlparser.cls')
               bs=countstr('\',home)
               sl=countstr('/',home)
               if bs>=1 then op='\'      --operating system Windows
               if sl>=1 then op='/'      --operating system Linux
               ival=substr(bval,2)
               if op='\' then
               do
                  g=compare(':\',ival)      --cut driveletter to be independent of drive (Windows)
                  if g>=2 then      --if result is unequal 2 the value is the path declaration
                  form~item(name||x)~checked=1
                  if g<2 then      --if result is < 2 the value is the level declaration
                  do
                     comp2=delstr(ival,1,4)      --cut the name "level" and leave the level number
                     comp1=delstr(ilevel,1,4)
                     if comp1<comp2 then      --check all checkboxes until the new level < old level
                     form~item(name||x)~checked=1
                     if comp1>=comp2 then
                     do
                        x=set
                        i=set
                     end
                  end
               end
               if op='/' then
               do
                  g=compare('/',ival)      --the result should be 2 for the second position (Linux)
                  if g=2 then
                  form~item(name||x)~checked=1
                  if g!=2 then      --if result is unequal 2 the value is the level declaration and not the path declaration
                  do
                     comp2=delstr(ival,1,4)      --cut the name "level" and leave the level number
                     comp1=delstr(ilevel,1,4)
                     if comp1<comp2 then      --check all checkboxes until the new level < old level
                     form~item(name||x)~checked=1
                     if comp1>=comp2 then
                     do
                        x=set
                        i=set
                     end
                  end
               end
            end
         end
      end
   end
   
::routine TUcode public
   xset=output3~value
   do h=0 to xset
      des=TB||h
      document~getElementbyID(des)~style~display='none'      --close all forms
   end
   uset=output4~value
   do h=0 to uset
      name2='namelink'
      document~getElementbyID(name2||h)~style~visibility='hidden'      --hide all links
   end
   
   folder=.array~of()
   f_count=1
   error=.array~of()
   failure=.array~of()
   d=1
   e=1
   home=syssearchpath('path','xmlparser.cls')
   posname=pos('xmlparser.cls',home)
   win=countstr("\",home)
   lin=countstr("/",home)
   if win>=1 then op="\"
   if lin>=1 then op="/"
   file=substr(home,1,posname-2)
   TeRAfiles=file||op||'TeRA_files'      --create paths
   lastTrun=TeRAfiles||op||'lastTrun.txt'
   c=lines(lastTrun,count)
   do i=1 to c
      cline=linein(lastTrun,i)
      dline=linein(lastTrun,i+1)
      if dline='ERROR' then
      do
         error~put(cline,d)
         d=d+1
      end
      if dline='FAILURE' then
      do
         failure~put(cline,e)
         e=e+1
      end
   end
   
   set=output~value
   form = document~forms~item(0)
   name='TU'
   name2='link'
   do i=0 to set
      check = form~item(name||i)~value
      get=compare(check,'level')
      if get=1 then
      do
         pos=lastpos('\',check)
         if pos\=0 then
         do
            t=delstr(check,1,pos)
            u=lastpos('.',t)
            r=delstr(t,u,9)
         end
      end
      
      m=error~items
      
      do v=1 to m
         n=error~at(v)
         u=lastpos('.',n)
         re=delstr(n,u,9)
         if re=r then
         do
            val1=form~item(name||i)~value
            val2=compare(val1,'level')
            if val2=1 then
            do
               form~item(name||i)~style~background='#FF0033'                     --highlight failures red
               document~getElementbyID(name2||i)~style~visibility='visible'      --make links visible (errors)
               check1 = form~item(name||i)~alt
               folder~put(check1,f_count)
               f_count=f_count+1
            end
         end
      end
      
      t=failure~items
      do v=1 to t
         p=failure~at(v)
         u=lastpos('.',p)
         re=delstr(p,u,9)
         if re=r then
         do
            val3=form~item(name||i)~value
            val4=compare(val3,'level')
            if val4=1 then
            do
               form~item(name||i)~style~background='#FFD000'                     --highlight failures orange
               document~getElementbyID(name2||i)~style~visibility='visible'      --make links visible (failures)
               check2 = form~item(name||i)~alt
               folder~put(check2,f_count)
               f_count=f_count+1
            end
         end
      end
   end
   count=folder~items
   do i=1 to count
      item=folder~at(i)
      document~getElementbyID(item)~style~display = 'inline'       --open forms which contain failures or errors
   end
   
::routine folder_checkAll public
   form = document~forms~item(0)
   check=output5~value
   xset=output~value
   
   do h=0 to xset
      item_alt=form~item("TU"||h)~alt
      
      if item_alt=check then
      do
         item_id=form~item("TU"||h)~id
         nr_comp=compare("all",item_id)
         if nr_comp=1 then
         form~item("TU"||h)~checked=1
      end
   end
   
::routine folder_uncheckAll public
   form = document~forms~item(0)
   check=output5~value
   xset=output~value
   
   do h=0 to xset
      item_alt=form~item("TU"||h)~alt
      
      if item_alt=check then
      do
         item_id=form~item("TU"||h)~id
         nr_comp=compare("all",item_id)
         if nr_comp=1 then
         form~item("TU"||h)~checked=0
      end
   end
   
