/*
name:             TeRA-compareLogs_script.rex
author:           Rainer Kegel
date:             2007-01-02

purpose:          part of the Test Runner Application for ooRexxUnit
- provides routines for TeRA-compareLogs.hta

license:          CPL 1.0 (Common Public License v1.0, see below)

*/

/*----------------------------------------------------------------------------*/
/*                                                                            */
/* Copyright (c) 2007 Rainer Kegel. All rights reserved.                      */
/*                                                                            */
/* This program and the accompanying materials are made available under       */
/* the terms of the Common Public License v1.0 which accompanies this         */
/* distribution. A copy is also available at the following address:           */
/* http://www.opensource.org/licenses/cpl1.0.php                              */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or                 */
/* without modification, are permitted provided that the following            */
/* conditions are met:                                                        */
/*                                                                            */
/* Redistributions of source code must retain the above copyright             */
/* notice, this list of conditions and the following disclaimer.              */
/* Redistributions in binary form must reproduce the above copyright          */
/* notice, this list of conditions and the following disclaimer in            */
/* the documentation and/or other materials provided with the distribution.   */
/*                                                                            */
/* Neither the name of Rexx Language Association nor the names                */
/* of its contributors may be used to endorse or promote products             */
/* derived from this software without specific prior written permission.      */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS          */
/* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT   */
/* OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,      */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,        */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     */
/* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         */
/* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               */
/*                                                                            */
/*----------------------------------------------------------------------------*/


::routine showLogFile public
   set=output~value
   LogFileList=.list~of()
   name='LOGFILE'
   do x=1 to 4
      do i=1 to set      --loop through all radio buttons
         check =document~getelementbyid(name||i||x)~checked      --if checked
         if check=1 then
         do
            selection=document~getelementbyid(name||i||x)~value      --then get value
            LogFileList~insert(selection)      --insert value into logfilelist
         end
      end
   end
   noi=LogfileList~items      --get number of items
   if noi=1 then
   do
      msie=.oleObject~new("InternetExplorer.Application")   -- rgf
      msie~visible=.true
      msie~navigate2(selection)
   end
   if noi>1 then      --if (# items)>1
   do
      call rxmessagebox 'too many files chosen!','wrong number of files'
   end
   if noi<1 then      --if (# items)<1
   do
      call rxmessagebox 'choose at least one file!','wrong number of files'
   end

::routine checked public
   set=output~value
   name='LOGFILE'
   do i=1 to set      --loop for ascending sort
      check = document~getElementbyId(name||i||1)~checked      --if this element checked then check=1
      if check=1 then
      document~getElementbyId(name||i||2)~disabled=1      --if check=1 then disable the counterpart
      if check\=1 then
      document~getElementbyId(name||i||2)~disabled=0      --if check\=1 then enable counterpart
   end
   do i=1 to set
      check = document~getElementbyId(name||i||2)~checked
      if check=1 then
      document~getElementbyId(name||i||1)~disabled=1
      if check\=1 then
      document~getElementbyId(name||i||1)~disabled=0
   end
   do i=1 to set      --loop for descending sort
      check = document~getElementbyId(name||i||3)~checked
      if check=1 then
      document~getElementbyId(name||i||4)~disabled=1
      if check\=1 then
      document~getElementbyId(name||i||4)~disabled=0
   end
   do i=1 to set
      check = document~getElementbyId(name||i||4)~checked
      if check=1 then
      document~getElementbyId(name||i||3)~disabled=1
      if check\=1 then
      document~getElementbyId(name||i||3)~disabled=0
   end

::routine uncheckAll public      --onclick uncheck all radio buttons
   set=output~value
   name='LOGFILE'
   do x=1 to 4
      do i=1 to set
         document~getElementbyID(name||i||x)~checked=0
         document~getElementbyID(name||i||x)~disabled=0
      end
   end

::routine arrange public      -- display ascending table or display descending table
   check1=document~getelementbyid('table1')~style~display
   check2=document~getelementbyid('table2')~style~display
   if (check1='inline' & check2='none') then
   do
      document~getelementbyid('table1')~style~display='none'
      document~getelementbyid('table2')~style~display='inline'
      document~getelementbyid('arrange')~value='ascending'
      call uncheckAll
   end
   if (check1='none' & check2='inline') then
   do
      document~getelementbyid('table1')~style~display='inline'
      document~getelementbyid('table2')~style~display='none'
      document~getelementbyid('arrange')~value='descending'
      call uncheckAll
   end

::routine compareLogs public
   set=output~value      --get number of checkboxes
   LogFileList=.list~of()
   form = document~forms~item(0)
   crlf='0d0a'x    -- CR-LF
   name='LOGFILE'
   do x=1 to 4       --do the loop 4 times for both sides and ascending and descending
      do i=1 to set
         check = document~getelementbyid(name||i||x)~checked
         if check=1 then
         do
            selection=document~getelementbyid(name||i||x)~value
            LogFileList~insert(selection)
         end
      end
   end
   noi=LogfileList~items
   if noi<2 then
   do
      call rxmessagebox 'choose two files!','wrong number of files'      --less than two files
      i=set
   end
   if noi>2 then
   do
      call rxmessagebox 'too many files chosen!','wrong number of files'      --too many files are chosen
      i=set
   end
   name1=LogFileList~at(0)
   name2=LogFileList~at(1)
   if noi=2 then      --exactly two files chosen
   do
      if rxmessagebox('Compare'crlf name1 crlf' with 'crlf name2,'compare','OKCANCEL','question')=1 then
      do
         check=syssearchpath('path','xmlparser.cls')
         bs=countstr('\',check)
         sl=countstr('/',check)
         if bs>=1 then op='\'      --Windows
         if sl>=1 then op='/'      --Linux
         lp=pos('xmlparser.cls',check)
         xmlpath=substr(check,1,lp-2)
         filespath=xmlpath||op||'TeRA_files'||op||'compTests.txt'
         call lineout filespath,name1      --store the first logfile's name
         call lineout filespath,name2      --store the second logfile's name
         rc=stream(filespath,'C','close')
         address cmd 'rexx TeRA-compareTests.rex'      --start the actual testing
      end
   end
