/*
name:             TeRA.rex
author:           Rainer Kegel
date:             2007-01-02

purpose:          part of the Test Runner Application for ooRexxUnit
- provides navigation and selecting

license:          CPL 1.0 (Common Public License v1.0, see below)

*/

/*----------------------------------------------------------------------------*/
/*                                                                            */
/* Copyright (c) 2007 Rainer Kegel. All rights reserved.                      */
/*                                                                            */
/* This program and the accompanying materials are made available under       */
/* the terms of the Common Public License v1.0 which accompanies this         */
/* distribution. A copy is also available at the following address:           */
/* http://www.opensource.org/licenses/cpl1.0.php                              */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or                 */
/* without modification, are permitted provided that the following            */
/* conditions are met:                                                        */
/*                                                                            */
/* Redistributions of source code must retain the above copyright             */
/* notice, this list of conditions and the following disclaimer.              */
/* Redistributions in binary form must reproduce the above copyright          */
/* notice, this list of conditions and the following disclaimer in            */
/* the documentation and/or other materials provided with the distribution.   */
/*                                                                            */
/* Neither the name of Rexx Language Association nor the names                */
/* of its contributors may be used to endorse or promote products             */
/* derived from this software without specific prior written permission.      */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS          */
/* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT   */
/* OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,      */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,        */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     */
/* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         */
/* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               */
/*                                                                            */
/*----------------------------------------------------------------------------*/



say "opening TeRA.hta.........."

dir=directory()      --get the actual directory
bs=countstr("\",dir)      --count backslash
sl=countstr("/",dir)      --count slash

if bs>=1 then op="\"      --if bs>=1 then operating system = Windows
else op="/"      --if sl>=1 then operating system = Linux

path=dir||op||"TeRA.hta"      --create path

--------------------------------------------

TeRAfilespath=dir||op||"TeRA_files"

lastlogfile=TeRAfilespath||op||"lastlog.xml"      --get path for lastlogfile

---------------------------------------------
call sysmkdir dir||op||"logfiles"      --create new folder ("logfiles" for log files)
call sysmkdir dir||op||"TeRA_files"      --create new folder ("TeRA_files" for additional Info)
call sysmkdir dir||op||"compared_files"      --create new folder ("compared_files" for compared log files)

/* copy style sheets to folders */
address cmd 'copy' dir||op||"log.css" dir||op||"logfiles"
address cmd 'copy' dir||op||"log.css" dir||op||"TeRA_files"
address cmd 'copy' dir||op||"complog.css" dir||op||"compared_files"
address cmd 'copy' dir||op||"log_xsl_script.rex" dir||op||"logfiles"
address cmd 'copy' dir||op||"complog_xsl_script.rex" dir||op||"compared_files"

qte='"'      --variable for "
qtb="'"      --variable for '
rc=stream(path,"C","close")      -- to close the file TeRA.hta
call SysFiledelete path      --delete the file

call lineout path,"<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'>"      --start writing .hta
call lineout path,"<html>"
call lineout path,"<head>"

call lineout path,"<title>TeRA</title>"

call lineout path,"<link rel='stylesheet' href='styles.css' type='text/css'>"

-----------------------------------------------------------------------------------------------------------------------------
--start script
-----------------------------------------------------------------------------------------------------------------------------

call lineout path,"<script language='Object Rexx' src='TeRA_script.rex'></script>"

-----------------------------------------------------------------------------------------------------------------------------
--end script
-----------------------------------------------------------------------------------------------------------------------------

call lineout path,"</head>"
call lineout path,"<body onload='call TUcode'>"
call lineout path,"<div id='content_container'>"
call lineout path,"<img src='Tera_Logo4TeRA_rex.jpg' id='logo' alt='oorexx logo' height='20%'>"

-----------------------------------------------------------------------------------------------------------------------------
--start generate tables for "checkbox-tree"
-----------------------------------------------------------------------------------------------------------------------------

l=.list~new       -- create a list
stem_index=0
flags      ="FSO"      -- search files only, in all subdirs, return fully qualified path

/* for Windows operating systems */

/* to minimize loading time insert path by opening configure_TeRA.rex */
config=SysSearchPath("path","config.html")

if config="" then
address cmd 'configure_TeRA.rex'

oo_loop=1
do while oo_loop<2
   check00=SysSearchPath("path","config.html")
   if check00\="" then
   oo_loop=2
end

config1=SysSearchPath("path","config.html")

if op="\" then
do
   if config1\="" then
   do
      rc=stream(file,"C","close")      --to close "config.html"
      n_lines=lines("config.html","count")
      do nn=1 to n_lines
         act_line=linein("config.html",nn)
         -- rgf-a
         parse var act_line "value='" dir "'" .
         if dir="" then
         iterate

--         say "Doing a SysFileTree on:" dir "flags:" flags
         call SysFileTree dir"\*.testunit", "files.", flags  --checks drives for .testUnit files
         do xc=1 to files.0
--            say "   found a testUnit file: ["files.xc"]"
            l~insert(files.xc)
         end
      end
   end
end

/* for Linux */

/* to minimize loading time insert path to location of test units on your hard disk */
if op="/" then
do
   call SysFileTree "/*.testunit", "files.", flags

   do xc=1 to files.0         -- rgf
      l~insert(files.xc)
   end
end

if l~items=0 then       -- no testUnit files found?
do
   -- call rxmessagebox "NO FILES FOUND - open 'configure_TeRA.rex' and insert path to test units","wrong or no path set"
   call rxmessagebox "NO FILES FOUND - Will start 'configure_TeRA.hta' to allow configuration of starting directories for test units","Wrong or no path set"
   config2=SysSearchPath("path","config.html")
   rc=stream(config2,"C","close")      -- to close the file "config.html"
   address cmd 'configure_TeRA.hta'
   exit -1
end


y=l~makearray
buttonid1=3      --couter for buttonID
buttonid2=4
index=y~items      --get number of arrayitems


call lineout path,"<form id='form1'>"
call lineout path,"<DL id='TUL1'>"
call lineout path,"<DT><input type='button' id='"||buttonid1"' value='+' onclick="qte"document~getElementbyID('TB0')~style~display = "qtb"inline"qtb""qte"><input type='button' id='"buttonid2"' value='-' onclick="qte"document~getElementbyID('TB0')~style~display = "qtb"none"qtb""qte">  all testunits </DT>"
buttonid1=buttonid1+2
buttonid2=buttonid2+2
call lineout path,"<DD>"
call lineout path,"<Table id="TB0">"
call lineout path,"<TR>"
call lineout path,"<TD>"
call lineout path,"<input type='checkbox' alt="TB0" name='TU0' id='all0' value='level0' onclick='call checkmore'>all TestUnits</br>"
call lineout path,"</TD>"
call lineout path,"</TR>"

z=2      --counter: <DL> ID
setindex=0      --counter: value of textarea "output"
findex=1      --counter: attribute "alt" testunit-checkbox; attribute "ID" <table>
aindex=1      --counter: attribute "ID" "all"-checkbox
nindex=1      --counter: attribute "name" testunit-checkbox
no=0      --counter: attribute "ID" testunit-checkbox
name="TestUnit"      --Variable for html-checkboxnames
tablearray=.array~of()
table_index=1

do i=1 to index      --do over all testunits
   g=y~at(i)      --the following block cuts each testunitpath (e.g.: result="oorexx.base.class.Supplier.testUnit")
   lpos1=lastpos(op,g)        -- get position of last slash
   lpos2=lastpos(".",g)       -- get position of last dot
   full=substr(g,lpos1+1,(lpos2-1)-lpos1) -- extract file name without
   dots=countstr(".",full)      --count dots for level

   interarray=.array~of()

   -- rgf
   if dots=0 then    -- base name has no dot !
   do
      interarray[1]=g      -- fully qualified name of testUnit
      interarray[2]=full   -- unqualified name of testUnit
   end
   else              -- name with at least one dot in it
   do
      posindex=1
      x=2

      do c=1 to dots      --extract each level name - level1 is predefined as "all testunits" - (e.g. level2:"oorexx", level3:"base", level4:"class", level5:"Supplier")
         fdotpos=pos(".",full,posindex)
         level=substr(full,posindex,fdotpos-posindex)
         interarray~put(g,1)
         interarray~put(level,x)      --insert test unit names into array
         x=x+1
         posindex=fdotpos+1
         if c=dots then
         do
            lastlevel=substr(full,posindex)
            interarray~put(lastlevel,x)
            x=x+1
         end
      end
   end

   tablearray~put(interarray,table_index)      --insert interarray into tablearray
   table_index=table_index+1
end

rainer=1

p=tablearray~items

do i=1 to p      --run through tablearray for all test units and the right level
   a_array=tablearray~at(i)
   a_items=a_array~items
   do t=2 to a_items
      act_aitem=a_array~at(t)
      testname=a_array~at(1)

      posinfo=lastpos(op,testname)
      infotestname=substr(testname,posinfo+1)      --get testname for then anchor in the links

      /* if i=1 then level1, if t\=a_items then the actual item is not the last in the array */
      if (i=1 & t\=a_items) then      --start creating the test unit tree
      do
         call lineout path,"</Table>"
         call lineout path,"<DL id='"TUL||z"'>"
         call lineout path,"<DT><input type='button' id='"||buttonid1"' value='+' onclick="qte"document~getElementbyID("qtb"TB"||findex""qtb")~style~display = "qtb"inline"qtb""qte"><input type='button' id='"buttonid2"' value='-' onclick="qte"document~getElementbyID("qtb"TB"||findex""qtb")~style~display = "qtb"none"qtb""qte">  "act_aitem" <input type='button' class='but1' value='checkAll' alt="qtb"TB"||findex""qtb" onmouseover="qte"document~getelementbyid("qtb"output5"qtb")~value=this~alt"qte" onclick='call folder_checkAll'></input><input type='button' class='but2' value='uncheckAll' alt="qtb"TB"||findex""qtb" onmouseover="qte"document~getelementbyid("qtb"output5"qtb")~value=this~alt"qte" onclick='call folder_uncheckAll'></input></DT>"
         buttonid1=buttonid1+2
         buttonid2=buttonid2+2
         call lineout path,"<DD>"
         call lineout path,"<Table id='TB"||findex"'>"
         z=z+1
         findex=findex+1

         call lineout path,"<TR>"
         call lineout path,"<TD>"
         call lineout path,"<input type='checkbox' alt='TB"||findex-1"' name='TU"||nindex"' id='all"||aindex"' value='level"t-1"' onclick='call checkmore'>all "act_aitem" Tests</br>"
         call lineout path,"</TD>"
         call lineout path,"</TR>"

         setindex=setindex+1
         nindex=nindex+1
         aindex=aindex+1
      end

      /* actual item ist the last in the array - insert the following item into new folder */
      if (i=1 & t=a_items) then
      do
         call lineout path,"<TR>"
         call lineout path,"<TD>"
         call lineout path,"<input type='checkbox' alt='TB"||findex-1"' name='TU"||nindex"' id='"name||no"' value='"testname"'><a href='"testname"' class='link_tu' alt='"a_array~at(a_items)"' id='"a_array~at(a_items)"' value='"testname"'>"a_array~at(a_items)"</a>   <a href='"lastlogfile"#"infotestname"' target='_blank' name='namelink"||no"' id='link"||nindex"'>info</a></br>"
         call lineout path,"</TD>"
         call lineout path,"</TR>"
         no=no+1
         setindex=setindex+1
         nindex=nindex+1
      end

      /* not level1, other items are following */
      if (i\=1 & i\=p) then
      do
         b_array=tablearray~at(i-1)
         b_items=b_array~items
         act_bitem=b_array~at(t)

         /* create new folder, not the last item */
         if (act_aitem\=act_bitem & t\=a_items) then
         do
            call lineout path,"</Table>"
            call lineout path,"<DL id='"TUL||z"'>"
            call lineout path,"<DT><input type='button' id='"||buttonid1"' value='+' onclick="qte"document~getElementbyID("qtb"TB"||findex""qtb")~style~display = "qtb"inline"qtb""qte"><input type='button' id='"buttonid2"' value='-' onclick="qte"document~getElementbyID("qtb"TB"||findex""qtb")~style~display = "qtb"none"qtb""qte">  "act_aitem" <input type='button' class='but1' value='checkAll' alt="qtb"TB"||findex""qtb" onmouseover="qte"document~getelementbyid("qtb"output5"qtb")~value=this~alt"qte" onclick='call folder_checkAll'></input><input type='button' class='but2' value='uncheckAll' alt="qtb"TB"||findex""qtb" onmouseover="qte"document~getelementbyid("qtb"output5"qtb")~value=this~alt"qte" onclick='call folder_uncheckAll'></input></DT>"
            buttonid1=buttonid1+2
            buttonid2=buttonid2+2
            call lineout path,"<DD>"
            call lineout path,"<Table id='TB"||findex"'>"
            z=z+1
            findex=findex+1

            call lineout path,"<TR>"
            call lineout path,"<TD>"
            call lineout path,"<input type='checkbox' alt='TB"||findex-1"' name='TU"||nindex"' id='all"||aindex"' value='level"t-1"' onclick='call checkmore'>all "act_aitem" Tests</br>"
            call lineout path,"</TD>"
            call lineout path,"</TR>"

            setindex=setindex+1
            nindex=nindex+1
            aindex=aindex+1
         end

         /* last item in this folder */
         if (act_aitem\=act_bitem & t=a_items) then
         do
            call lineout path,"<TR>"
            call lineout path,"<TD>"
            call lineout path,"<input type='checkbox' alt='TB"||findex-1"' name='TU"||nindex"' id='"name||no"' value='"testname"'><a href='"testname"' class='link_tu' alt='"a_array~at(a_items)"' id='"a_array~at(a_items)"' value='"testname"'>"a_array~at(a_items)"</a>   <a href='"lastlogfile"#"infotestname"' target='_blank' name='namelink"||no"' id='link"||nindex"'>info</a></br>"
            call lineout path,"</TD>"
            call lineout path,"</TR>"
            no=no+1
            setindex=setindex+1
            nindex=nindex+1

            /* close HTML tags if necessary */
            c_array=tablearray~at(i+1)
            x_array=tablearray~at(i)

            if c_array\=.nil then
            do
               act_citem=c_array~at(1)
               act_xitem=x_array~at(1)
               act_c=lastpos("\",act_citem)
               act_x=lastpos("\",act_xitem)
               n1=substr(act_citem,act_c+1)
               n2=substr(act_xitem,act_x+1)
               n1n2_compare=compare(n1,n2)

               if n1n2_compare\=0 then
               do
                  new_x=substr(n2,n1n2_compare+1)
                  dots_count=countstr(".",new_x)

                  if dots_count>1 then
                  do cl=1 to dots_count-1
                     call lineout path,"</Table>"
                     call lineout path,"</DD>"
                     call lineout path,"</DT>"
                     call lineout path,"</DL>"
                  end
               end
            end
         end
      end


      /* block for closing all opened tags to this level */
      -- if i=p then
      if i=p & i>1 then
      do
         b_array=tablearray~at(i-1)
         b_items=b_array~items
         act_bitem=b_array~at(t)
         /*        if t\=a_items then
         do
            if b_items>a_items then
            do
               q=b_items-a_items
               do r=1 to q+1
                  call lineout path,"</Table>"
                  call lineout path,"</DD>"
                  call lineout path,"</DT>"
                  call lineout path,"</DL>"
               end
            end
         end */

         /* new folder, not the last item */
         if (act_aitem\=act_bitem & t\=a_items) then
         do
            call lineout path,"</Table>"
            call lineout path,"<DL id='"TUL||z"'>"
            call lineout path,"<DT><input type='button' id='"||buttonid1"' value='+' onclick="qte"document~getElementbyID("qtb"TB"||findex""qtb")~style~display = "qtb"inline"qtb""qte"><input type='button' id='"buttonid2"' value='-' onclick="qte"document~getElementbyID("qtb"TB"||findex""qtb")~style~display = "qtb"none"qtb""qte">  "act_aitem" <input type='button' class='but1' value='checkAll' alt="qtb"TB"||findex""qtb" onmouseover="qte"document~getelementbyid("qtb"output5"qtb")~value=this~alt"qte" onclick='call folder_checkAll'></input><input type='button' class='but2' value='uncheckAll' alt="qtb"TB"||findex""qtb" onmouseover="qte"document~getelementbyid("qtb"output5"qtb")~value=this~alt"qte" onclick='call folder_uncheckAll'></input></DT>"
            buttonid1=buttonid1+2
            buttonid2=buttonid2+2
            call lineout path,"<DD>"
            call lineout path,"<Table id='TB"||findex"'>"
            z=z+1
            findex=findex+1

            call lineout path,"<TR>"
            call lineout path,"<TD>"
            call lineout path,"<input type='checkbox' alt='TB"||findex-1"' name='TU"||nindex"' id='all"||aindex"' value='level"t-1"' onclick='call checkmore'>all "act_aitem" Tests</br>"
            call lineout path,"</TD>"
            call lineout path,"</TR>"

            setindex=setindex+1
            nindex=nindex+1
            aindex=aindex+1
         end

         /* new folder, last item */
         if (act_aitem\=act_bitem & t=a_items) then
         do
            call lineout path,"<TR>"
            call lineout path,"<TD>"
            call lineout path,"<input type='checkbox' alt='TB"||findex-1"' name='TU"||nindex"' id='"name||no"' value='"testname"'><a href='"testname"' class='link_tu' alt='"a_array~at(a_items)"' id='"a_array~at(a_items)"' value='"testname"'>"a_array~at(a_items)"</a>   <a href='"lastlogfile"#"infotestname"' target='_blank' name='namelink"||no"' id='link"||nindex"'>info</a></br>"
            call lineout path,"</TD>"
            call lineout path,"</TR>"
            no=no+1
            setindex=setindex+1
            nindex=nindex+1
            do f=1 to a_items
               call lineout path,"</Table>"
               call lineout path,"</DD>"
               call lineout path,"</DT>"
               call lineout path,"</DL>"
            end
         end
      end
   end
end


call lineout path,"</Table>"
call lineout path,"</DD>"    --close html
call lineout path,"</DT>"
call lineout path,"</DL>"
call lineout path,"</form>"

-----------------------------------------------------------------------------------------------------------------------------
--end generate tables for "checkbox-tree"
-----------------------------------------------------------------------------------------------------------------------------

call lineout path,"</div>"

-----------------------------------------------------------------------------------------------------------------------------
--start input buttons
-----------------------------------------------------------------------------------------------------------------------------
call lineout path,"<div id='footer1'>"      --area for buttons

call lineout path,"<input type='button' name='checkAll' id='checkAll' value='checkAll' alt='checkAll' onClick='call checkAll'>"

call lineout path,"<input type='button' name='uncheckAll' id='uncheckAll' value='uncheckAll' alt='uncheckAll' onClick='call uncheckall'>"

call lineout path,"<input type='button' name='openAll' id='openAll' value='open all' alt='openAll' onClick='call openAll'>"

call lineout path,"<input type='button' name='closeAll' id='closeAll' value='close all' alt='closeAll' onClick='call closeAll'>"

call lineout path,"<input type='button' name='invert' id='invert' value='invert' alt='invert' onClick='call invert'>"

call lineout path,"<span>username: <input type='text' id='username' name='username' alt='username' value='noUserNamedYet'></input></span>"

call lineout path,"</div>"

call lineout path,"<div id='footer2'>"

call lineout path,"<input type='button' name='runTests' id='runTests' value='run tests' alt='runTests' onClick='call SelectedTestUnits'>"

call lineout path,"<input type='button' name='showResult' id='showResult' value='show result' alt='showResult' onClick='call openLastLog'>"

call lineout path,"<input type='button' name='compTests' id='compTests' value='compare tests' alt='compTests' onClick='call compareLogFiles'>"

call lineout path,"<input type='button' name='configure' id='configure' value='configure' alt='configure' onClick='address cmd configure_TeRA.rex'>"

call lineout path,"<span>comment: <input type='text' id='comment' name='comment' alt='comment' value='no comment'></input></span>"

call lineout path,"</div>"
-----------------------------------------------------------------------------------------------------------------------------
--end input buttons
-----------------------------------------------------------------------------------------------------------------------------

call lineout path,"<p type='textarea' size='30' id='output' value='"setindex"'></p>"
call lineout path,"<p type='textarea' size='30' id='output2'name='output2'></p>"
call lineout path,"<p type='textarea' size='30' id='output3' value='"findex-1"'></p>"
call lineout path,"<p type='textarea' size='30' id='output4' value='"no-1"'></p>"
call lineout path,"<p type='textarea' size='30' id='output5' value='0'></p>"
call lineout path,"</body>"
call lineout path,"</html>"

rc=stream(path,"C","close")      --cut programm's access to created file

address cmd path      --open file
