/*
name:             TeRA-runTestsandEdit.rex
author:           Rainer Kegel
date:             2007-01-02

purpose:          part of the Test Runner Application for ooRexxUnit
- runs and edits selected tests

license:          CPL 1.0 (Common Public License v1.0, see below)

*/

/*----------------------------------------------------------------------------*/
/*                                                                            */
/* Copyright (c) 2007 Rainer Kegel. All rights reserved.                      */
/*                                                                            */
/* This program and the accompanying materials are made available under       */
/* the terms of the Common Public License v1.0 which accompanies this         */
/* distribution. A copy is also available at the following address:           */
/* http://www.opensource.org/licenses/cpl1.0.php                              */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or                 */
/* without modification, are permitted provided that the following            */
/* conditions are met:                                                        */
/*                                                                            */
/* Redistributions of source code must retain the above copyright             */
/* notice, this list of conditions and the following disclaimer.              */
/* Redistributions in binary form must reproduce the above copyright          */
/* notice, this list of conditions and the following disclaimer in            */
/* the documentation and/or other materials provided with the distribution.   */
/*                                                                            */
/* Neither the name of Rexx Language Association nor the names                */
/* of its contributors may be used to endorse or promote products             */
/* derived from this software without specific prior written permission.      */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS          */
/* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT   */
/* OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,      */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,        */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     */
/* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         */
/* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               */
/*                                                                            */
/*----------------------------------------------------------------------------*/

-- rgf, 2007-04-29
      -- escapeMarkup

.local~tera.markup.from=.array~of("&"    , "<"   , ">"   , '"'     , "'"     )
   -- uses hexadecimal value for "apos" as MSIE would not show an apostrophe in HTML mode
-- .local~tera.markup.to  =.array~of("&amp;", "&lt;", "&gt;", '&quot;', "&#x0027;")
.local~tera.markup.to  =.array~of("&amp;", "&lt;", "&gt;", '&quot;', "&apos;")


-----------------------------------------------------------
TeRA_spec=SyssearchPath("path","TeRA.rex")

bs=countstr("\",TeRA_spec)      --count backslash
sl=countstr("/",TeRA_spec)

if bs>=1 then op="\"      --if bs>=1 then operating system = Windows
if sl>=1 then op="/"      --if sl>=1 then operating system = linux

lp=pos("TeRA.rex",TeRA_spec)
file=substr(TeRA_spec,1,lp-2)      --path of main folder

newpath=file||op||"logfiles"
call sysmkdir newpath

-----------------------------------------------------------
TeRAfiles=file||op||"TeRA_files"

ltrun_spec=TeRAfiles||op||"lastTrun.txt"
if ltrun_spec\="" then
do
   rc=stream(ltrun_spec,"C","close")
   call SysFileDelete ltrun_spec      --delete the old file "lastTrun.txt"
end

acttests=TeRAfiles||op||"actTests.txt"

-------------------------------------------------------------------------------------------------------------

qte="'"
qtb='"'

number=lines(acttests,count)      --get the test data from "actTests.txt"
l=.list~of()
do i=1 to number
   l1=linein(acttests,i)
   l~insert(l1)
end

tSuite=.TestSuite~new      --create a TestSuite object, which will contain all testUnits
call makeTestSuiteFromFileList l, tSuite

/* or alternatively:
tSuite=makeTestSuiteFromFileList(l)  -- will create a testSuite object and return it
*/

tRes=.TestResult~new      -- create a TestResult object to be used to gather the test-log infos
tSuite~run(tRes)      -- run all the testUnits collected in the Testsuite
/*
or alternatively:
tRes=tSuite~run      -- will create a testResult object and return it
*/

intermediarypath=file||op||"intermediary.txt"      --path for "intermediary.txt"

call lineout intermediarypath,"TestCounts:"pp(tSuite~countTestCases),1      --save # of TestCounts to logfile
call lineout intermediarypath,"ErrorCounts:"pp(tRes~errorCount),2      --save # of ErrorCounts to logfile
call lineout intermediarypath,"FailureCounts:"pp(tRes~failureCount),3      --save # of FailureCounts to logfile
call lineout intermediarypath,"RunCounts:"pp(tRes~runCount),4      --save # of RunCounts to logfile

len=length(tRes~logQueue~items)+2
i=0
do item over tRes~logQueue
   i=i+1
   -- say "     queue item #" pp(i)~right(len)":" pp(item)
   call dumpDir item          -- show contents of directory object
end


----------------- now going through the logged items in 'TestCaseTable'..."-----------------------------------

len=length(tRes~testCaseTable~items)+2
i=0
do item over tRes~testCaseTable
   i=i+1
   call dumpQueue tRes~testCaseTable~at(item)      --show contents of directory object
end

call deleteacttests(acttests)

call edit(TeRAfiles)

rc=stream(intermediarypath,"C","close")      --to close "intermediary.txt"

call SysFileDelete intermediarypath


::requires oorexxunit.cls      --get the ooRexxUnit support
   --------------------------------------------------------------------------------------------------------------
   --------------------------------------------------------------------------------------------------------------
::routine dumpDir
   use arg dir
   ----------------------------------------------------
   TeRA_spec=SyssearchPath("path","TeRA.rex")

   bs=countstr("\",TeRA_spec)      --count backslash
   sl=countstr("/",TeRA_spec)

   if bs>=1 then op="\"      --if bs>=1 then operating system = Windows
   if sl>=1 then op="/"      --if sl>=1 then operating system = Linux

   lp=pos("TeRA.rex",TeRA_spec)
   file=substr(TeRA_spec,1,lp-2)
   ----------------------------------------------------

   intermediarypath=file||op||"intermediary.txt"      --path for "intermediary.txt"

   do idx over dir
      --say "           idx="pp(idx) "value:" pp(dir~at(idx))
/*
      call lineout intermediarypath,"idx="pp(escapeMarkupChars(idx)) -
                                    "value:" pp(escapeMarkupChars(dir~at(idx)))
*/

      call lineout intermediarypath,"idx="pp(idx) -
                                    "value:" pp(dir~at(idx))

      tmpValue=dir~at(idx)      --dump content of an array or list object
      if tmpValue~hasMethod("SUPPLIER") then
      do
         do entry over tmpValue
            call lineout intermediarypath,"09"x pp(entry)
/*
            call lineout intermediarypath,"09"x pp(escapeMarkupChars(entry))
*/
         end
      end
   end

::routine dumpQueue
   use arg queue
   do item over queue
      if item~class=.directory then      -- if a directory in hand, dump its content
      call dumpDir(item)
   end



::routine edit public
   use arg TeRAfiles
   --------------------------------------------------------------------------------------------------------------

   TeRA_spec=SyssearchPath("path","TeRA.rex")

   bs=countstr("\",TeRA_spec)      --count backslash
   sl=countstr("/",TeRA_spec)      --count slash

   if bs>=1 then op="\"      --if bs>=1 then operating system = Windows
   if sl>=1 then op="/"      --if sl>=1 then operating system = Linux

   lp=pos("TeRA.rex",TeRA_spec)
   file=substr(TeRA_spec,1,lp-2)

   TeRAfiles=file||op||"TeRA_files"
   intermediarypath=file||op||"Intermediary.txt"

   /*the following code is used to name logfiles precisely, by adding the date and the time of the testrun
   to the identifier*/

   crlf="0d0a"x      --CR-LF

   part1="log"      --filetype

   part2=date("S")      --part2=date without space

   Time=.mutableBuffer~new      --a new mutable buffer to change the format of time
   Time~insert(Time())

   /*the colons have to be deleted, because Microsoft Windows is not able to save files with filenames
   including colons*/

   Time~delete(3,1)      --delete the first colon
   Time~delete(5,1)      --delete the second colon

   Time~insert(.,2)
   Time~insert(.,5)

   part3=Time~string()

   userinformation=TeRAfiles||op||"userinformation.txt"      --get the userinformation
   a=linein(userinformation,1)

   logfilename=part1"_"part2"_"part3"_"a".xml"

   fpath=file||op||"logfiles"
   logpath=fpath||op||logfilename

   rc=stream(intermediarypath,"C","close")      --to close "intermediary.txt"

   linenumber=lines(intermediarypath,count)      --count lines of the logfile


   lasttrunarray=.array~of()      --create new array for last testrun info (color highlighting and linking)
   lasttrunindex=1

   xsl_path=file||op||"log.xsl"      --path for xsl file
   ----------------------------------------------------------------------------------------------------------------
   call lineout logpath,"<?xml version='1.0'?>"
   call lineout logpath,"<?xml-stylesheet type='text/xsl'  href='"xsl_path"' ?>"
   call lineout logpath,"<testunit>"
   ----------------------------------------------------------------------------------------------------------------

   /* now get the whole userinformation (name and comment) */

   username=linein(userinformation,1)
   comment=linein(userinformation,2)

   call lineout logpath,"<username>"escapeMarkupChars(username)"</username>"
   call lineout logpath,"<comment>"escapeMarkupChars(comment)"</comment>"

   rc=stream(userinformation,'C','close')
   call sysfiledelete userinformation


   -------edit the first 4 lines of "Intermediary.txt" to get # of errors, testruns, failures and testunits--------

   call lineout logpath,"<runs>"

   /* test run information */
   a=linein(intermediarypath,1)
   Num=.mutableBuffer~new
   Num~setBufferSize(1)
   Num~insert(a)
   b=lastpos("[",num~string)
   c=lastpos("]",num~string)
   d=Num~getBufferSize()
   num~delete(c,d+1-c)
   num~delete(1,b)
   call lineout logpath,"<testruns>"num~string"</testruns>"

   /* error count information */
   a=linein(intermediarypath,2)
   Num=.mutableBuffer~new
   Num~setBufferSize(1)
   Num~insert(a)
   b=pos("[",num~string)
   c=pos("]",num~string)
   d=Num~getBufferSize()
   num~delete(c,d+1-c)
   num~delete(1,b)
   call lineout logpath,"<errcounts>"num~string"</errcounts>"

   /* failure count information */
   a=linein(intermediarypath,3)
   Num=.mutableBuffer~new
   Num~setBufferSize(1)
   Num~insert(a)
   b=pos("[",num~string)
   c=pos("]",num~string)
   d=Num~getBufferSize()
   num~delete(c,d+1-c)
   num~delete(1,b)
   call lineout logpath,"<failcount>"num~string"</failcount>"

   /* run information */
   a=linein(intermediarypath,4)
   Num=.mutableBuffer~new
   Num~setBufferSize(1)
   Num~insert(a)
   b=pos("[",num~string)
   c=pos("]",num~string)
   d=Num~getBufferSize()
   num~delete(c,d+1-c)
   num~delete(1,b)
   call lineout logpath,"<runcount>"num~string"</runcount>"

   call lineout logpath,"</runs>"


   ----------------------------------------------------------------------------------------------------------------

   TestUnitTestNameBuffer=.mutableBuffer~new
   TestUnitTestNameBuffer~setBufferSize(1)

   ----------------------------------create file ltrun.txt if not already existing---------------------------------

   call sysmkdir TeRAfiles
   xml_subtest_index=1
   lasttrun=TeRAfiles||op||"lastTrun.txt"

   lastlogfile=TeRAfiles||op||"lastlog.xml"      --create path for lastlogfile
   rc=stream(lastlogfile,"C","close")      --close file
   call sysfiledelete lastlogfile      --delete the file

   n_indexTrace=1
   n_indexADD=1

   i=5
   do while i<=linenumber
/*
      call linein intermediarypath,i
      actline=result
*/
      actline=linein(intermediarypath, i)
      ------------------------------get all important positions of "Intermediary.txt"----------------------------------

      posStart=pos("[startTest]",actline)

      posEnd=pos("[endTest]",actline)

      posTestSuite=pos("testCase: []",actline)

      posThe=pos("[The",actline)

      posClass=pos("class]",actline)

      posValue=pos("value: [[",actline)

      posBracket=pos("]:",actline)

      -- posTest=pos("[TEST_",actline)  -- ? evtl. [TEST ???
      posTest=pos("[TEST",actline)  -- ? evtl. [TEST ???

      posFail=pos("[failure]",actline)

      posError=pos("[error]",actline)

      ------------------------------------------------------------------------------------------------------------------

      if posStart>0 then      --get starttime
      do
         StartTimeBuffer=.mutablebuffer~new
         StartTimeBuffer~setBufferSize(1)
         StartTimeBuffer~insert(actline)
         STBS=StartTimeBuffer~getBufferSize()
         StartTimeBuffer~delete(posStart-3,(STBS+1)-(posStart-6))
         StartTimeBuffer~delete(1,(posStart-19))
         DateBuffer=.mutableBuffer~new      --get date
         DateBuffer~setBufferSize(1)
         Datebuffer~insert(actline)
         DBS=DateBuffer~getBufferSize()
         DateBuffer~delete(posStart-19,(STBS+1)-(posStart-19))
         DateBuffer~delete(1,(posStart-28))
      end

      if posEnd>0 then      --get endtime
      do
         EndTimeBuffer=.mutablebuffer~new
         EndTimeBuffer~setBufferSize(1)
         EndTimeBuffer~insert(actline)
         ETBS=EndTimeBuffer~getBufferSize()
         EndTimeBuffer~delete(posEnd-3,(ETBS+1)-(posEnd-6))
         EndTimeBuffer~delete(1,(posEnd-19))
         DateBuffer=.mutableBuffer~new      --get date
         DateBuffer~setBufferSize(1)
         Datebuffer~insert(actline)
         DBS=DateBuffer~getBufferSize()
         DateBuffer~delete(posEnd-19,(ETBS+1)-(posEnd-19))
         DateBuffer~delete(1,(posEnd-28))
      end

      if posThe>0 & posClass>0 then      --get testunitname
      do
         TestUnitNameBuffer=.mutableBuffer~new
         TestUnitNameBuffer~setBufferSize(1)
         TestUnitNameBuffer~insert(actline)
         TUNBS=TestUnitNameBuffer~getbuffersize()
         TestUnitNameBuffer~delete(posClass-1,(TUNBS+1)-(posClass-1))
         TestUnitNameBuffer~delete(1,(posThe+4))
      end

      if posTest>0 then      --get testname
      do
         posTestBracket=pos("]",actline,posTest+1)
         TestNameBuffer=.mutableBuffer~new
         TestNameBuffer~setBufferSize(1)
         TestNameBuffer~insert(actline)
         TNBS=TestNameBuffer~getBufferSize()
         TestNameBuffer~delete(posTestBracket,(TNBS+1)-posTestBracket)
         TestNameBuffer~delete(1,posTest)
         check1=TestUnitNameBuffer~string"/"TestNameBuffer~string";"
         posTestAttachment=pos(check1,TestUnitTestNameBuffer~string)
         if posTestAttachment=0
         then TestUnitTestNameBuffer~insert(TestunitNameBuffer~string"/"TestNameBuffer~string";")
      end
      ------------------------------------------------------------------------------------------------------------------

      if (posTestSuite>0 & posStart>0) then      --start of test suite
      do
         call lineout logpath,"<starttestsuite>"StartTimeBuffer~string"</starttestsuite>"
         call lineout logpath,"<startdatets>"DateBuffer~string"</startdatets>"
      end

      if (posTestSuite>0 & posEnd>0) then      --end of test suite
      do
         call lineout logpath,"<endtestsuite>"EndTimeBuffer~string"</endtestsuite>"
         call lineout logpath,"<enddatets>"DateBuffer~string"</enddatets>"
         call lineout logpath,"<subtestnumber id='subtestnumber' value='"xml_subtest_index-1"'></subtestnumber>"
         call lineout logpath,"</testunit>"
      end

      if (posThe>0 & posClass>0 & posStart>0) then      --start of test case
      do
         call lineout logpath,"<maintestunit id='"TestUnitNameBuffer~string"'>"
         call lineout logpath,"<startend>"
         call lineout logpath,"<namemain>"TestUnitNamebuffer~string"</namemain>"
         call lineout logpath,"<mainstarttime>"StartTimeBuffer~string"</mainstarttime>"
         call lineout logpath,"<mainstartdate>"DateBuffer~string"</mainstartdate>"
         call lineout logpath,"</startend>"
      end

      if (posThe>0 & posClass>0 & posEnd>0) then      --end of test case
      do
         call lineout logpath,"<startend>"
         call lineout logpath,"<mainendtime>"StartTimeBuffer~string"</mainendtime>"
         call lineout logpath,"<mainenddate>"DateBuffer~string"</mainenddate>"
         call lineout logpath,"</startend>"
         call lineout logpath,"</maintestunit>"
      end

      if (posStart>0 & posTest>0) then
      do
         actline_1=linein(intermediarypath,i+1)
         posEnd=pos("[endTest]",actline_1)
         if posEnd>0 then
         do
            EndTimeBuffer=.mutablebuffer~new
            EndTimeBuffer~setBufferSize(1)
            EndTimeBuffer~insert(actline)
            ETBS=EndTimeBuffer~getBufferSize()
            EndTimeBuffer~delete(posEnd-3,(ETBS+1)-(posEnd-6))
            EndTimeBuffer~delete(1,(posEnd-19))
            call lineout logpath,"<subtest value='okay' name='"TestUnitNameBuffer~string"/"TestNameBuffer~string"' id='subtest"||xml_subtest_index"'>"
            call lineout logpath,"<name>"TestNameBuffer~string"</name>"
            call lineout logpath,"<main>"TestUnitNameBuffer~string"</main>"
            call lineout logpath,"<linestart><substarttime>"StartTimeBuffer~string"</substarttime>"
            call lineout logpath,"<substartdate>"DateBuffer~string"</substartdate></linestart>"
            call lineout logpath,"<lineend><subendtime>"EndTimeBuffer~string"</subendtime>"
            call lineout logpath,"<subenddate>"DateBuffer~string"</subenddate></lineend>"
            call lineout logpath,"<status>OKAY</status>"
            call lineout logpath,"</subtest>"
            xml_subtest_index=xml_subtest_index+1
         end
         else      --if test raises an error or failure then execute the following code
         do
            do ix=15 to 500
               actline_ix=linein(intermediarypath,i+ix)
               posEnd=pos("[endTest]",actline_ix)
               if posEnd\=0 then
                  ix=500
            end

            if posEnd>0 then      --extract the end time - this is the last line of this test
            do
               actline_2=linein(intermediarypath,i+2)
               posError=pos("[error]", actline_2)
               posFail=pos("[failure]", actline_2)
               EndTimeBuffer=.mutablebuffer~new
               EndTimeBuffer~setBufferSize(1)
               EndTimeBuffer~insert(actline)
               ETBS=EndTimeBuffer~getBufferSize()
               EndTimeBuffer~delete(posEnd-3,(ETBS+1)-(posEnd-6))
               EndTimeBuffer~delete(1,(posEnd-19))


               if posError>0 then      --if "[error]" can be found create an error section in the xml file
               do
                  call lineout logpath,"<subtest value='error' name='"TestUnitNameBuffer~string"/"TestNameBuffer~string"' id='subtest"||xml_subtest_index"'>"
                  call lineout logpath,"<name>"TestNameBuffer~string"</name>"
                  call lineout logpath,"<main>"TestUnitNameBuffer~string"</main>"
                  call lineout logpath,"<linestart><substarttime>"StartTimeBuffer~string"</substarttime>"
                  call lineout logpath,"<substartdate>"DateBuffer~string"</substartdate></linestart>"
                  call lineout logpath,"<lineend><subendtime>"EndTimeBuffer~string"</subendtime>"
                  call lineout logpath,"<subenddate>"DateBuffer~string"</subenddate></lineend>"
                  call lineout logpath,"<status>ERROR</status>"
                  call lineout logpath,"<infotable value='error'>"
                  errarray=.array~of()
                  errarray~put(TestUnitNameBuffer~string,1)
                  errarray~put("ERROR",2)
                  errarray~put("//////",3)
                  lasttrunarray~put(errarray,lasttrunindex)
                  lasttrunindex=lasttrunindex+1
                  xml_subtest_index=xml_subtest_index+1
               end
               if posFail>0 then      --if "[failure]" can be found create a failure section in the xml file
               do
                  call lineout logpath,"<subtest value='failure' name='"TestUnitNameBuffer~string"/"TestNameBuffer~string"' id='subtest"||xml_subtest_index"'>"
                  call lineout logpath,"<name>"TestNameBuffer~string"</name>"
                  call lineout logpath,"<main>"TestUnitNameBuffer~string"</main>"
                  call lineout logpath,"<linestart><substarttime>"StartTimeBuffer~string"</substarttime>"
                  call lineout logpath,"<substartdate>"DateBuffer~string"</substartdate></linestart>"
                  call lineout logpath,"<lineend><subendtime>"EndTimeBuffer~string"</subendtime>"
                  call lineout logpath,"<subenddate>"DateBuffer~string"</subenddate></lineend>"
                  call lineout logpath,"<status>FAILURE</status>"
                  call lineout logpath,"<infotable value='failure'>"
                  failarray=.array~of()
                  failarray~put(TestUnitNameBuffer~string,1)
                  failarray~put("FAILURE",2)
                  failarray~put("//////",3)
                  lasttrunarray~put(failarray,lasttrunindex)
                  lasttrunindex=lasttrunindex+1
                  xml_subtest_index=xml_subtest_index+1
               end
            end
         end
      end

      if (posStart=0 & posEnd=0 & posFail=0 & posError=0) then
      do
         check4=countstr("*-*",actline)
         if check4=1 then      --additional info in this line (Traceback information)
         do
            call lineout logpath,"<lineadd index='TRACEBACKadd' n_index='"n_indexTrace"'><info col='span'>&#160;&#160;&#160;&#160;&#160;"escapeMarkupChars(actline)"</info></lineadd>"
            n_indexTrace=n_indexTrace+1
         end
         check3=compare("idx=",actline)
         if check3=5 then      --index information
         do
            valpos=pos("value:",actline)      --extract the value information
            part1=substr(actline,1,valpos-1)      --cut the value; result=index
            part2=substr(actline,valpos)      --cut the index; result=value
            bra1=pos("[",actline)
            if bra1=5 then
            do
               bra2=pos("]",actline,bra1+1)
               sortind=substr(actline,bra1+1,(bra2-1)-bra1)
            end
            call lineout logpath,"<line index='"sortind"'><info>"escapeMarkupChars(part1)"</info><info >"escapeMarkupChars(part2)"</info></line>"
         end
         if (check3\=5 & check4=0) then      --like the traceback information, this is additional information
         do
            call lineout logpath,"<lineadd index='ADDITIONALadd' n_index='"n_indexADD"'><info col='span'>&#160;&#160;&#160;&#160;&#160;"escapeMarkupChars(actline)"</info></lineadd>"
            n_indexADD=n_indexADD+1
         end
         check1=linein(intermediarypath,i+1)
         check2=pos("[endTest]",check1)
         if check2\=0 then
         do
            call lineout logpath,"</infotable>"
            call lineout logpath,"</subtest>"
         end
      end
      i=i+1
   end

   ----------------------------------------------------------------------------------------------------------------------
   /* the following code loops through the lasttrunarray to write information into lasttrun.txt */
   /* purpose: delete redundant information       */
   ----------------------------------------------------------------------------------------------------------------------
   lasttTeRAems=lasttrunarray~items      -- get items for the first loop (multidimensional array!)
   do k=1 to lasttTeRAems
      ltrun_array1=lasttrunarray~at(k)
      ltrun_items1=ltrun_array1~items      -- get items for the second loop
      do l=1 to ltrun_items1
         ltrun_act_item1=ltrun_array1~at(l)
         ltrun_act_item_pos1=ltrun_array1~at(1)
         if k=1 then      -- if first array, write information
         call lineout lasttrun,ltrun_act_item1
         if k\=1 then      -- if not first array, check the array (actual position -1), if information was already written
         do
            ltrun_array0=lasttrunarray~at(k-1)
            ltrun_act_item0_pos1=ltrun_array0~at(1)
            if ltrun_act_item_pos1\=ltrun_act_item0_pos1 then
            call lineout lasttrun,ltrun_act_item1
         end
      end
   end


/* ---rgf, 2007-04-29, not needed anymore
   -------------------------------------------------create Logfileindex.txt if not already existing-----------------------
   check3=syssearchpath("path","LogIndex")
   if check3="" then
   do
      pathname1=fpath||op||"LogIndex"
      pathname2=pathname1||op||"LogFileIndex.txt"
      call sysmkdir pathname1
      call lineout pathname2,logfilename
   end
   else call lineout pathname2,logfilename
*/

   call copylastlog logpath,lastlogfile
   -----------------------------------------------------------------------------------------------------------------------

::routine deleteacttests public
   use arg acttests

   rc=stream(acttests,"C","close")
   call sysfiledelete acttests

::routine copylastlog public      --copy the last logfile to ...TeRA_files\lastlog.xml
   use arg logpath,lastlogfile

   rc=stream(logpath,"C","close")

   address cmd 'copy' logpath lastlogfile



-- =====================================================================
-- rgf, 2007-04-29
   /* escape XML/HTML meta-chars using SGML entities  */
::routine escapeMarkupChars public
  parse arg str

  from=.tera.markup.from
  to  =.tera.markup.to

  do i=1 to from~items
     str=str~changestr(from[i], to[i])
  end
  return str

