/*
name:             TeRA-openLastLog.rex
author:           Rainer Kegel
date:             2007-01-02

purpose:          part of the Test Runner Application for ooRexxUnit
- opens the last run log file

license:          CPL 1.0 (Common Public License v1.0, see below)

*/

/*----------------------------------------------------------------------------*/
/*                                                                            */
/* Copyright (c) 2007 Rainer Kegel. All rights reserved.                      */
/*                                                                            */
/* This program and the accompanying materials are made available under       */
/* the terms of the Common Public License v1.0 which accompanies this         */
/* distribution. A copy is also available at the following address:           */
/* http://www.opensource.org/licenses/cpl1.0.php                              */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or                 */
/* without modification, are permitted provided that the following            */
/* conditions are met:                                                        */
/*                                                                            */
/* Redistributions of source code must retain the above copyright             */
/* notice, this list of conditions and the following disclaimer.              */
/* Redistributions in binary form must reproduce the above copyright          */
/* notice, this list of conditions and the following disclaimer in            */
/* the documentation and/or other materials provided with the distribution.   */
/*                                                                            */
/* Neither the name of Rexx Language Association nor the names                */
/* of its contributors may be used to endorse or promote products             */
/* derived from this software without specific prior written permission.      */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS          */
/* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT   */
/* OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,      */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,        */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     */
/* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         */
/* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               */
/*                                                                            */
/*----------------------------------------------------------------------------*/

say "opening last logfile.........."

TeRA_spec=syssearchpath("path","TeRA.rex")      --get path of folder "TeRA.rex"

bs=countstr("\",TeRA_spec)
sl=countstr("/",TeRA_spec)

if bs>=1 then op="\"      --Windows
if sl>=1 then op="/"      --Linux
qte='"'

fpos=pos("TeRA.rex",TeRA_spec)
check=substr(TeRA_spec,1,fpos-2)
logfiles=check||op||"logfiles"      --"logfile" path of folder

name=logfiles||op||logindex

lfi=syssearchpath("path",name)      --get path of folder "logindex"

   -- get all logfiles
call SysFileTree logfiles"\log*.xml", "files.", "FO"
if files.0=0 then                -- oops, no logfiles!
do
   call rxMessageBox "No logfiles found in ["logfiles"] !", "No Logfiles Found!",-
                     "OK", "Exclamation"
   exit -1
end

call SysStemSort "files."        -- make sure files are sorted
lastLogFile=files.[files.0]      -- get last file

say "TeRA-openLastLog: opening ["lastLogFile"] with MSIE..."
msie=.oleObject~new("InternetExplorer.Application")   -- rgf
msie~visible=.true
msie~navigate2(lastLogFile)

