/*
name:             TeRA-compareTests.rex
author:           Rainer Kegel
date:             2007-01-02

purpose:          part of the Test Runner Application for ooRexxUnit
- actual comparison of log files

license:          CPL 1.0 (Common Public License v1.0, see below)

*/

/*----------------------------------------------------------------------------*/
/*                                                                            */
/* Copyright (c) 2007 Rainer Kegel. All rights reserved.                      */
/*                                                                            */
/* This program and the accompanying materials are made available under       */
/* the terms of the Common Public License v1.0 which accompanies this         */
/* distribution. A copy is also available at the following address:           */
/* http://www.opensource.org/licenses/cpl1.0.php                              */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or                 */
/* without modification, are permitted provided that the following            */
/* conditions are met:                                                        */
/*                                                                            */
/* Redistributions of source code must retain the above copyright             */
/* notice, this list of conditions and the following disclaimer.              */
/* Redistributions in binary form must reproduce the above copyright          */
/* notice, this list of conditions and the following disclaimer in            */
/* the documentation and/or other materials provided with the distribution.   */
/*                                                                            */
/* Neither the name of Rexx Language Association nor the names                */
/* of its contributors may be used to endorse or promote products             */
/* derived from this software without specific prior written permission.      */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS          */
/* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT   */
/* OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,      */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,        */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     */
/* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         */
/* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               */
/*                                                                            */
/*----------------------------------------------------------------------------*/


say "reading logfiles.........."

check=syssearchpath("path","xmlparser.cls")      --get path of "TeRA_files"

bs=countstr("\",check)
sl=countstr("/",check)

if bs>=1 then op="\"      --Windows
if sl>=1 then op="/"      --Linux

lp=pos("xmlparser.cls",check)
file=substr(check,1,lp-2)

checkpath=file||op||"TeRA_files"||op||"compTests.txt"
log1=linein(checkpath,1)      -- read which logs are going to be compared

lpos1=lastpos(op,log1)
name=substr(log1,lpos1+1)
pos1=lastpos(".",name)
name1=substr(name,1,pos1-1)      --edit the first name (without path and ".xml")

log2=linein(checkpath,2)      -- read which logs are going to be compared

lpos2=lastpos(op,log2)
name=substr(log2,lpos2+1)
pos2=lastpos(".",name)
name2=substr(name,1,pos2-1)      --edit the second name (without path and ".xml")

c1=name1"___"name2".xml"      --get both name-combinations
c2=name2"___"name2".xml"      --get both name-combinations

pspec=syssearchpath("path","compared_files")      --search folder

g1=pspec||op||c1
g2=pspec||op||c2

res1=syssearchpath("path",g1)      --check whether file is already existing
res2=syssearchpath("path",g2)      --check whether file is already existing

if res1\="" then
do
--   address cmd 'iexplore.exe' g1      -- if file is existing, open it
   -- address cmd g1      -- if file is existing, open it
   call showFileWithIexplore g1
end

if res2\="" then
do
--    address cmd 'iexplore.exe' g2      -- if file is existing, open it
   -- address cmd g2      -- if file is existing, open it
   call showFileWithIexplore g2
end

if (res1="" & res2="") then      --create file,if not existing
do
   filename=name1"___"name2".xml"
   newpath=file||op||"compared_files"

   if pspec="" then      --create folder "compared_files", if not existing
      call sysmkdir newpath

   comppath=newpath||op||filename      --new name of file

   xsl_path=file||op||"complog.xsl"
   ---------------------------------------------------------------------------------------------------------
   /* create new xml file */
   ---------------------------------------------------------------------------------------------------------

   call lineout comppath,"<?xml version='1.0'?>"
   call lineout comppath,"<?xml-stylesheet type='text/xsl'  href='"xsl_path"' ?>"
   call lineout comppath,"<testunit>"

   nochanges=0

   do i=1 to 2      --loop for both logs that are compared

      if i=1 then
      log=log1

      if i=2 then
      log=log2

      .local~insert.index=1      --save counter to local environment
      .local~insert.array=.array~new      --save new array to local environment
      .local~index.TeRA=1
      .local~comp.log=.array~new

      say "storing results.........."

      parser = .myparser~new()
      errortxt = parser~parse_file(log)      --parse log-xml

      if i=1 then      --fill first array
      do
         attrarr1=.comp.log
         i1=attrarr1~items
      end

      if i=2 then      --fill second array
      do
         attrarr2=.comp.log
         i2=attrarr2~items
      end
   end

   /*
   search both arrays for changes
   */
   say "creating file.........."

   call lineout comppath,"<changes>"
   call lineout comppath,"<headline>CHANGES FOUND</headline>"
   call lineout comppath,"<name1>"name1"</name1>"
   call lineout comppath,"<name2>"name2"</name2>"

   do x=1 to i1      --loop through all items ("attrarr1")
      a1=attrarr1~at(x)      --get actual array (a1=multi dimensional array)
      a1check=a1~at(1)      --get testname
      a1status=a1~at(2)      --get status

      do y=1 to i2      --loop through all items ("attrarr2")
         a2=attrarr2~at(y)      --get actual array (a2=multi dimensional array)
         a2check=a2~at(1)      --get testname
         a2status=a2~at(2)      --get status

         if a1check=a2check then      --compare test name
         do

            nindexTrace=1
            nindexADD=1

            if a1status\=a2status then      --compare status (if not same => new section in the in xml "changes")
            do
               n=a1~items
               m=a2~items

               if n>=m then      --check which array has more items
                  t=n
               else
                  t=m

               diffstatus1=.array~of()
               dsindex1=1
               diffstatus2=.array~of()
               dsindex2=1

               do q=1 to t      --loop through both arrays at once
                  if q<=n then      --if counter<# of items then write information
                  do
                     get1=a1~at(q)
                     diffstatus1~put(get1,dsindex1)      --insert info
                     dsindex1=dsindex1+1
                  end

                  if q>n then      --if counter># of items then write empty tag
                  do
                     get1=''
                     diffstatus1~put(get1,dsindex1)
                     dsindex1=dsindex1+1
                  end

                  if q<=m then
                  do
                     get2=a2~at(q)
                     diffstatus2~put(get2,dsindex2)
                     dsindex2=dsindex2+1
                  end

                  if q>m then
                  do
                     get2=''
                     diffstatus2~put(get2,dsindex2)
                     dsindex2=dsindex2+1
                  end
               end

               u=diffstatus1~items
               m=diffstatus2~items
               if u=m then
                  nui=u
               if u>m then
                  nui=u
               if m>u then
                  nui=m

               call lineout comppath,"<tutable>"
               call lineout comppath,"<table1>"      --table for first log file
               do w=1 to nui
                  get1=diffstatus1~at(w)
                  g1=compare("idx=",get1)
                  g2=compare("value:",get1)
                  g3=countstr("*-*",get1)
                  g4=countstr("]",get1)
                  g5=countstr("[",get1)
                  if g1=5 then      --if item is an index item
                  do
                     n1=pos("[",get1)
                     n2=pos("]",get1)
                     attnameadd=substr(get1,n1+1,(n2-1)-n1)
                     call lineout comppath,"<line1 index='"attnameadd"'><complog1 check='d'>"escapeMarkupChars(get1)"</complog1>"      --attribute 'index' important to sort the lines
                  end
                  if g2=8 then      --value item
                  call lineout comppath,"<complog1>"escapeMarkupChars(get1)"</complog1></line1>"
                  if g3>=1 then      --"traceback" info
                  do
                     call lineout comppath,"<line1 index='TRACEBACKadd' nindex='"nindexTrace"'><complog1 col='span'>"escapeMarkupChars(get1)"</complog1></line1>"
                     nindexTrace=nindexTrace+1
                  end
                  if (g4>=3 & g5>=3 & g2\=8) then      --"Additional" info
                  do
                     call lineout comppath,"<line1 index='ADDITIONALadd' nindex='"nindexADD"'><complog1 col='span'>"escapeMarkupChars(get1)"</complog1></line1>"
                     nindexADD=nindexADD+1
                  end
                  if (g1<5 & g2<8 & g3=0 & g4<3 & get1\='') then      --testname
                  call lineout comppath,"<line1 index='AAAAAAAAAA'><complog1>"escapeMarkupChars(get1)"</complog1></line1>"
                  if get1='' then      --test unit name
                  call lineout comppath,"<line1 index='CCCCCCCCCC'><complog1></complog1></line1>"
               end

               call lineout comppath,"</table1>"
               call lineout comppath,"<table2>"
               do w=1 to nui
                  get2=diffstatus2~at(w)

                  /* checks */
                  g1=compare("idx=",get2)
                  g2=compare("value:",get2)
                  g3=countstr("*-*",get2)
                  g4=countstr("]",get2)
                  g5=countstr("[",get2)
                  if g1=5 then
                  do
                     n1=pos("[",get2)
                     n2=pos("]",get2)
                     attnameadd=substr(get2,n1+1,(n2-1)-n1)
                     call lineout comppath,"<line2 index='"attnameadd"'><complog2 check='d'>"escapeMarkupChars(get2)"</complog2>"
                  end
                  if g2=8 then
                  call lineout comppath,"<complog2>"escapeMarkupChars(get2)"</complog2></line2>"
                  if g3>=1 then
                  do
                     call lineout comppath,"<line2 index='TRACEBACKadd' nindex='"nindexTrace"'><complog2 col='span'>"escapeMarkupChars(get2)"</complog2></line2>"
                     nindexTrace=nindexTrace+1
                  end
                  if (g4>=3 & g5>=3 & g2\=8) then
                  do
                     call lineout comppath,"<line2 index='ADDITIONALadd' nindex='"nindexADD"'><complog2 col='span'>"escapeMarkupChars(get2)"</complog2></line2>"
                     nindexADD=nindexADD+1
                  end
                  if (g1<5 & g2<8 & g3=0 & g4<3 &get2\='') then
                  call lineout comppath,"<line2 index='AAAAAAAAAA'><complog2>"escapeMarkupChars(get2)"</complog2></line2>"
                  if get2='' then
                  call lineout comppath,"<line2 index='CCCCCCCCCC'><complog2></complog2></line2>"
               end
               call lineout comppath,"</table2>"
               call lineout comppath,"</tutable>"
            end

            if a1status=a2status then      --if status is the same
            do
               c=1
               d=1
               point=0      --if there are no changes found, point stays =0, else point=1
               int_arr1=.array~of()
               int_arr2=.array~of()
               n=a1~items
               do q=1 to n      --loop through all items of a1
                  get1=a1~at(q)
                  get2=a2~at(q)

                  if get1=get2 then      --compare all information
                  do
                     check1=compare("idx=",get1)      --index
                     check2=compare("value:",get1)      --value
                     if check1=5 then      --index item
                     do
                        n1=pos("[",get1)
                        n2=pos("]",get1)
                        attnameadd=substr(get1,n1+1,(n2-1)-n1)
                        int_arr1~put("<line1 index='"attnameadd"'><complog1 check='d'>"escapeMarkupChars(get1)"</complog1>",c)
                        c=c+1
                     end
                     if check2=8 then      --value item
                     do
                        int_arr1~put("<complog1>"escapeMarkupChars(get1)"</complog1></line1>",c)
                        c=c+1
                     end
                     if (check1\=5 & check2\=8) then      --additional info, traceback info or test name
                     do
                        cstr=countstr("*-*",get1)
                        check3=countstr("[",get1)
                        check4=countstr("]",get1)
                        if cstr>=1 then
                        do
                           int_arr1~put("<line1 index='TRACEBACKadd' nindex='"nindexTrace"'><complog1 col='span'>"escapeMarkupChars(get1)"</complog1></line1>",c)
                           nindexTrace=nindexTrace+1
                        end
                        if (check3>=3 & check4>=3) then
                        do
                           int_arr1~put("<line1 index='ADDITIONALadd' nindex='"nindexADD"'><complog1 col='span'>"escapeMarkupChars(get1)"</complog1></line1>",c)
                           nindexADD=nindexADD+1
                        end
                        if (check3<3 & check4<3 & cstr<1) then
                        int_arr1~put("<line1 index='AAAAAAAAAA'><complog1 col='span'>"escapeMarkupChars(get1)"</complog1></line1>",c)
                        c=c+1
                     end
                  end

                  if get1\=get2 then      --if information is not the same
                  do
                     point=1
                     check1=compare("idx=",get1)
                     check2=compare("value:",get1)
                     if check1=5 then      --index item
                     do
                        n1=pos("[",get1)
                        n2=pos("]",get1)
                        attnameadd=substr(get1,n1+1,(n2-1)-n1)
                        int_arr1~put("<line1 index='"attnameadd"'><complog1 value='diff' check='d'>"get1"</complog1>",c)
                        c=c+1
                     end
                     if check2=8 then      --value item
                     do
                        int_arr1~put("<complog1 value='diff'>"escapeMarkupChars(get1)"</complog1></line1>",c)
                        c=c+1
                     end
                     if (check1\=5 & check2\=8) then      --additional info, traceback info or test name
                     do
                        cstr=countstr("*-*",get1)
                        check3=countstr("[",get1)
                        check4=countstr("]",get1)
                        if cstr>=1 then
                        do
                           int_arr1~put("<line1 index='TRACEBACKadd' nindex='"nindexTrace"'><complog1 value='diff' col='span'>"escapeMarkupChars(get1)"</complog1></line1>",c)
                           nindexTrace=nindexTrace+1
                        end
                        if (check3>=3 & check4>=3) then
                        do
                           int_arr1~put("<line1 index='ADDITIONALadd' nindex='"nindexADD"'><complog1 value='diff' col='span'>"escapeMarkupChars(get1)"</complog1></line1>",c)
                           nindexADD=nindexADD+1
                        end
                        if (check3<3 & check4<3 & cstr<1) then
                        int_arr1~put("<line1 index='AAAAAAAAAA'><complog1 value='diff' col='span'>"escapeMarkupChars(get1)"</complog1></line1>",c)
                        c=c+1
                     end
                  end
               end
               do q=1 to n      --loop through all items of a2
                  get1=a1~at(q)
                  get2=a2~at(q)
                  if get1=get2 then      -- info is the same
                  do
                     check1=compare("idx=",get2)
                     check2=compare("value:",get2)
                     if check1=5 then
                     do
                        n1=pos("[",get2)
                        n2=pos("]",get2)
                        attnameadd=substr(get2,n1+1,(n2-1)-n1)
                        int_arr2~put("<line2 index='"attnameadd"'><complog2 check='d'>"get2"</complog2>",d)
                        d=d+1
                     end
                     if check2=8 then
                     do
                        int_arr2~put("<complog2>"escapeMarkupChars(get2)"</complog2></line2>",d)
                        d=d+1
                     end
                     if (check1\=5 & check2\=8) then
                     do
                        cstr=countstr("*-*",get2)
                        check3=countstr("[",get2)
                        check4=countstr("]",get2)
                        if cstr>=1 then
                        do
                           int_arr2~put("<line2 index='TRACEBACKadd' nindex='"nindexTrace"'><complog2 col='span'>"escapeMarkupChars(get2)"</complog2></line2>",d)
                           nindexTrace=nindexTrace+1
                        end
                        if (check3>=3 & check4>=3) then
                        do
                           int_arr2~put("<line2 index='ADDITIONALadd' nindex='"nindexADD"'><complog2 col='span'>"escapeMarkupChars(get2)"</complog2></line2>",d)
                           nindexADD=nindexADD+1
                        end
                        if (check3<3 & check4<3 & cstr<1) then
                        int_arr2~put("<line2 index='AAAAAAAAAA'><complog2 col='span'>"escapeMarkupChars(get2)"</complog2></line2>",d)
                        d=d+1
                     end
                  end
                  if get1\=get2 then
                  do
                     point=1
                     check1=compare("idx=",get2)
                     check2=compare("value:",get2)
                     if check1=5 then
                     do
                        n1=pos("[",get2)
                        n2=pos("]",get2)
                        attnameadd=substr(get2,n1+1,(n2-1)-n1)
                        int_arr2~put("<line2 index='"attnameadd"'><complog2 value='diff' check='d'>"get2"</complog2>",d)
                        d=d+1
                     end
                     if check2=8 then
                     do
                        int_arr2~put("<complog2 value='diff'>"escapeMarkupChars(get2)"</complog2></line2>",d)
                        d=d+1
                     end
                     if (check1\=5 & check2\=8) then
                     do
                        cstr=countstr("*-*",get2)
                        check3=countstr("[",get2)
                        check4=countstr("]",get2)
                        if cstr>=1 then
                        do
                           int_arr2~put("<line2 index='TRACEBACKadd' nindex='"nindexTrace"'><complog2 value='diff' col='span'>"escapeMarkupChars(get2)"</complog2></line2>",d)
                           nindexTrace=nindexTrace+1
                        end
                        if (check3>=3 & check4>=3) then
                        do
                           int_arr2~put("<line2 index='ADDITIONALadd' nindex='"nindexADD"'><complog2 value='diff' col='span'>"escapeMarkupChars(get2)"</complog2></line2>",d)
                           nindexADD=nindexADD+1
                        end
                        if (check3<3 & check4<3 & cstr<1) then
                        int_arr2~put("<line2 index='AAAAAAAAAA'><complog2 value='diff' col='span'>"escapeMarkupChars(get2)"</complog2></line2>",d)
                        d=d+1
                     end
                  end
               end


               if point=1 then      --changes found
               do
                  nochanges=1
                  call lineout comppath,"<tutable>"
                  call lineout comppath,"<table1>"
                  m=int_arr1~items
                  do q=1 to m      --create first table
                     get=int_arr1~at(q)
                     call lineout comppath,get
                  end
                  call lineout comppath,"</table1>"
                  call lineout comppath,"<table2>"
                  u=int_arr2~items
                  do q=1 to u      --create second table
                     get=int_arr2~at(q)
                     call lineout comppath,get
                  end
                  call lineout comppath,"</table2>"
                  call lineout comppath,"</tutable>"
               end
            end
         end
      end
   end

   if nochanges=0 then
   do
      call lineout comppath,"<tutable>"
      call lineout comppath,"<table1>"
      call lineout comppath,"<line1><complog1>no changes found</complog1></line1>"
      call lineout comppath,"</table1>"
      call lineout comppath,"<table2>"
      call lineout comppath,"<line2><complog2>no changes found</complog2></line2>"
      call lineout comppath,"</table2>"
      call lineout comppath,"</tutable>"
   end

   call lineout comppath,"</changes>"

   /*
   now write the information, which tests run in which logfile (first for log1 and then for log2)
   */


   call lineout comppath,"<log1>"
   call lineout comppath,"<headline>"name1"</headline>"
   testname_bothindex=1
   testname_onceindex=1

   do x=1 to i1
      a1=attrarr1~at(x)
      a1check=a1~at(1)
      a1status=a1~at(2)
      to_comp=0
      do y=1 to i2
         a2=attrarr2~at(y)
         a2check=a2~at(1)
         if a1check=a2check then
         do
            call lineout comppath,"<testname id='both"||testname_bothindex"' value='1'>"a1check"</testname>"
            to_comp=1
            testname_bothindex=testname_bothindex+1
         end
      end

      if to_comp=0 then
      do
         call lineout comppath,"<testname id='once"||testname_onceindex"' value='not'>"a1check"</testname>"
         testname_onceindex=testname_onceindex+1
      end
   end
   call lineout comppath,"</log1>"

   call lineout comppath,"<log2>"
   call lineout comppath,"<headline>"name2"</headline>"
   do y=1 to i2
      a2=attrarr2~at(y)
      a2check=a2~at(1)
      a2status=a2~at(2)
      to_comp=0
      do x=1 to i1
         a1=attrarr1~at(x)
         a1check=a1~at(1)
         if a2check=a1check then
         do
            call lineout comppath,"<testname id='both"||testname_bothindex"' value='1'>"a2check"</testname>"
            testname_bothindex=testname_bothindex+1
            to_comp=1
         end
      end

      if to_comp=0 then
      do
         call lineout comppath,"<testname id='once"||testname_onceindex"' value='not'>"a2check"</testname>"
         testname_onceindex=testname_onceindex+1
      end
   end

   call lineout comppath,"</log2>"

   qte='"'

   call lineout comppath,"</testunit>"    --write closing tag

   rc=stream(comppath,"C","close")        --close new generated comp-file completely
   -- delpath=qte||comppath||qte
   -- address cmd 'iexplore.exe' delpath      --open new generated comp-file
   -- address cmd delpath      --open new generated comp-file
   call showFileWithIexplore comppath
end

rc=stream(checkpath,"C","close")      --close comptests.txt(info -log1 -log2)

call sysfiledelete checkpath      --delete the file



::requires 'xmlparser.cls'


/* Starting MSIE via ADDRESS CMD may take looong (30secs and more),
   hence this solution instead.
*/
::routine showFileWithIexplore      -- rgf, 2007-04-29
  parse arg logpath_fspec

   msie=.oleObject~new("InternetExplorer.Application")
   msie~visible=.true
   msie~navigate2(logpath_fspec)  -- without (!) quotes


   /* This class provides the information of the log files by reading the tags via the "xmlparser.cls" */
::class myparser subclass xmlparser

::method mystream attribute
::method curtag attribute

::method start_element
   use arg chunk
   self~curtag=chunk~tag
   a=.array~of()
   sub=chunk~tag

   if sub="subtest" then      -- if xml-Tag = subtest
   do
      att=chunk~attr      -- get the attributes (returns one string)
      attarr=att~makearray      --strip down to attributes value and name
      check=attarr~at(1)
      fpos=pos("'",check)
      spos=pos("'",check, fpos+1)
      value=substr(check, fpos+1, (spos-1)-fpos)
      tpos=pos("'",check, spos+1)
      opos=pos("'",check, tpos+1)
      name=substr(check, tpos+1, (opos-1)-tpos)

      .insert.array~put(name,.insert.index)      --insert name and value
      .local~insert.index=.insert.index+1
      .insert.array~put(value,.insert.index)
      .local~insert.index=.insert.index+1

   end


::method text
   use arg chunk
   if self~curtag="info" then      --if xml-tag = info
   do      --insert "info"-text      --insert "info"-text
      .insert.array~put(chunk~text,.insert.index)
      .local~insert.index=.insert.index+1
   end

::method end_element
   use arg chunk
   main_index=1
   if chunk~tag="subtest" then       --if closing-tag = subtest
   do
      .comp.log~put(.insert.array,.index.TeRA)      --insert array into local array
      .local~index.TeRA=.index.TeRA+1
      .local~insert.array=.array~new
      .local~insert.index=1
   end



-- =====================================================================
-- rgf, 2007-04-29
   /* escape XML/HTML meta-chars using SGML entities  */
::routine escapeMarkupChars public
  parse arg str

  if verify(str, "<>", "M")=0 then
     return str

  from=.tera.markup.from
  to  =.tera.markup.to
  from=.array~of("<"   , ">"   )
  to  =.array~of("&lt;", "&gt;")

  do i=1 to from~items
     if pos(from[i],str)=0 then
        iterate
-- say "--> found ["from[i]"] ..."
     str=str~changestr(from[i], to[i])
  end
  return str

