/*
name:             TeRA-compareLogs.rex
author:           Rainer Kegel
date:             2007-01-02

purpose:          part of the Test Runner Application for ooRexxUnit
- provides navigation for comparing log files

license:          CPL 1.0 (Common Public License v1.0, see below)

*/

/*----------------------------------------------------------------------------*/
/*                                                                            */
/* Copyright (c) 2007 Rainer Kegel. All rights reserved.                      */
/*                                                                            */
/* This program and the accompanying materials are made available under       */
/* the terms of the Common Public License v1.0 which accompanies this         */
/* distribution. A copy is also available at the following address:           */
/* http://www.opensource.org/licenses/cpl1.0.php                              */
/*                                                                            */
/* Redistribution and use in source and binary forms, with or                 */
/* without modification, are permitted provided that the following            */
/* conditions are met:                                                        */
/*                                                                            */
/* Redistributions of source code must retain the above copyright             */
/* notice, this list of conditions and the following disclaimer.              */
/* Redistributions in binary form must reproduce the above copyright          */
/* notice, this list of conditions and the following disclaimer in            */
/* the documentation and/or other materials provided with the distribution.   */
/*                                                                            */
/* Neither the name of Rexx Language Association nor the names                */
/* of its contributors may be used to endorse or promote products             */
/* derived from this software without specific prior written permission.      */
/*                                                                            */
/* THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS        */
/* "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT          */
/* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS          */
/* FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT   */
/* OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,      */
/* SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED   */
/* TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,        */
/* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY     */
/* OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING    */
/* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS         */
/* SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.               */
/*                                                                            */
/*----------------------------------------------------------------------------*/

say "opening compareLogs.........."

TeRA_spec=SyssearchPath("path","TeRA.rex")      --get the right directory

bs=countstr("\",TeRA_spec)
sl=countstr("/",TeRA_spec)

if bs>=1 then op="\"      -- operating system Windows
if sl>=1 then op="/"      -- operating system Linux

lp=pos("TeRA.rex",TeRA_spec)
file=substr(TeRA_spec,1,lp-2)

name=file||op||"TeRA-compareLogs.hta"
call sysfiledelete name      --delete the old TeRA-compareLogs.hta

qte='"'
qtb="'"

call lineout name,"<!DOCTYPE HTML PUBLIC '-//W3C//DTD HTML 4.01 Transitional//EN'>"
call lineout name,"<html>"
call lineout name,"<head>"

call lineout name,"<title>TeRA - compare Tests</title>"
call lineout name,"<link rel='stylesheet' href='styles.css' type='text/css'>"
---------------------------------------------------------------------------------------------------------------
--start script
---------------------------------------------------------------------------------------------------------------

call lineout name,"<script language='object rexx' src='TeRA_compareLogs_script.rex'></script>"
-----------------------------------------------------------------------------------------------------------------------------
--end script
-----------------------------------------------------------------------------------------------------------------------------

call lineout name,"</head>"
call lineout name,"<body>"
call lineout name,"<div id='content_container'>"
call lineout name,"<h1>COMPARE LOG FILES</h1>"

filespath=file||op||"logfiles"

FilePattern=filespath||op||"*.xml"      --search for .xml files
-- flags      ="FSO"      -- search files only, in all subdirs, return fully qualified path
flags      ="FO"      -- search files only, return fully qualified path
call SysFileTree FilePattern, "files.", flags

if files.0=0 then
do
   call rxmessagebox "no logfiles found - aborting"
   exit -1
end

mystem.=.stem~new
l=.list~new      -- create a list
do i=1 to files.0      -- add each found file into the list
   l~insert(files.i)
   mystem.i=files.i
end

j=l~items      --get number of list items for descending list

mystem.0=j      --set index to number of items

call SysStemSort "mystem.","D"      --sort stem descending

call lineout name,"<form name='LogFileForm1' id='LogFileForm1'>"      --ascending form
call lineout name,"<table id='table1' style='display:inline;'>"

y=l~makearray      --list => array
arr=y~supplier      --supplier => array

num=l~items

i=1
do while i<=num      --loop through all items in the list (ascending table)
   htmlname=LogFile||i
   g=arr~item()
   backlastpos=lastpos(op,g)
   lName=substr(g,(backlastpos+1))
   call lineout name,"<tr><td><input type='radio' onclick='call checked' name='a' id='"htmlname||1"' value='"g"'>" lName"</input></td><td><input type='radio' onclick='call checked' name='b' id='"htmlname||2"' value='"g"'>" lName"</input></td></tr>"
   arr~next
   i=i+1
end

call lineout name,"</table>"
call lineout name,"</form>"

call lineout name,"<form name='LogFileForm2' id='LogFileForm2'>"      --descending form
call lineout name,"<table id='table2' style='display:none;'>"

x=1
do while x<=mystem.0      --loop through all stem items (descending table)
   htmlname=Logfile||x
   backlastpos=lastpos(op,mystem.x)
   lName=substr(mystem.x,(backlastpos+1))
   call lineout name,"<tr><td><input type='radio' onclick='call checked' name='a' id='"htmlname||3"' value='"mystem.x"'>" lName"</input></td><td><input type='radio' onclick='call checked' name='b' id='"htmlname||4"' value='"mystem.x"'>" lName"</input></td></tr>"
   x=x+1
end

call lineout name,"</table>"
call lineout name,"</form>"

call lineout name,"</div>"
call lineout name,"<div id='footer1'>"
call lineout name,"<input type='button' onclick='call uncheckAll' id='uncheck' name='uncheck' value='uncheck'>"
call lineout name,"<input type='button' onclick='call arrange' id='arrange' name='arrange' value='descending'>"
call lineout name,"</div>"
call lineout name,"<div id='footer2'>"
call lineout name,"<input type='button' onclick='call compareLogs' id='compareLogs' name='compareLogs' value='compare logs'>"
call lineout name,"<input type='button' onclick='call showLogFile' id='showLog' name='showLog' value='show logfile'>"
call lineout name,"</div>"
call lineout name,"<p type='textarea' size='30' id='output' value="num">"
call lineout name,"</body>"
call lineout name,"</html>"

rc=stream(name,"C","close")      --to close "TeRA-compareLogs.hta"
address cmd name
