::class parser public
::method init
expose string matchstart matchend sectionstart sectionlength
use arg string

matchstart = 1;
matchend = 1;
sectionstart = 1;
sectionstart = 1
sectionlength = string~length

::method matchstart
expose matchstart
return matchstart

::method sectionstart
expose sectionstart
return sectionstart

::method sectionlength
expose sectionlength
return sectionlength

::method section
expose string sectionstart sectionlength
return string~substr(sectionstart, sectionlength)

::method sectionwords
section = self~section
count = section~words
wordlist = .array~new(count)

do i = 1 to count
   wordlist[i] = section~word(i)
end

return wordlist

::method remainder
expose string matchend
return string~substr(matchend)

::method match
expose string matchstart matchend sectionstart sectionlength
use arg needle

sectionstart = matchend

matchstart = string~pos(needle, matchend)

if matchstart == 0 then do
    matchstart = string~length + 1
    matchend = matchstart
    sectionlength = matchstart - sectionstart
    return .false
end
else do
    matchend = matchstart + needle~length
    sectionlength = matchstart - sectionstart
    return .true
end

::method move
expose string matchstart matchend sectionstart sectionlength
use arg delta

sectionstart = matchstart
matchstart = matchstart + delta

self~validateposition

::method moveTo
expose string matchstart matchend sectionstart sectionlength

sectionstart = matchstart
use arg matchstart

self~validateposition

::method validateposition private
expose string matchstart matchend sectionstart sectionlength

if matchstart < 1 then do
    matchstart = 1
end
else if matchstart > string~length then do
    matchstart = string~length + 1
end


if matchstart <= sectionstart then do
    sectionlength = string~length - sectionstart + 1
end
else do
    sectionlength = matchstart - sectionstart
end

matchend = matchstart





