#!/usr/bin/rexx
/*
	program:          testRgfSockets.rex
	type:             Open Object Rexx  (ooRexx)
   language level:   6.01 (ooRexx version 3.1.2 and up)

	purpose:          Tests the .Rgf.Socket class from the "rgf.sockets.cls" module
                     and demonstrates the effect of the different log levels.

	version:          1.0.0
   license:          Choice of  Apache License Version 2.0 or Common Public License 1.0
	date:             2007-04-11, ---rgf, released
	author:           Rony G. Flatscher, Wirtschaftsuniversit&auml;t Wien, Vienna, Austria, Europe
   changes:          ---

	needs:	         optionally the 'log4rexx' framework

	usage:            rexx testRgfSockets.rex wwwHostName
                        or
                     rexx testRgfSockets.rex wwwHostName [TRACE|DEBUG|INFO|WARN|ERROR|FATAL|OFF]

   comments:         it may be the case that the host is not found at the first attempt
                     to locate it; therefore repeat the command

	returns:          ---
*/


-- call log4rexx.cls       -- initialize the 'log4rexx' framework, will make a difference ;-)

parse arg host logLevel .
logLevels="TRACE DEBUG INFO WARN ERROR FATAL"

if host="" then
do
   parse source . . s
   sfn=filespec("N", s)
   say "no argument(s) given, aborting!"
   say  "usage:"
   say "  " sfn "wwwHostNameOrAddress"
end

if host="" | (loglevel<>"" & wordpos(logLevel~translate, logLevels)=0 ) then
do
   say "  " sfn "wwwHostNameOrAddress logLevel"
   say "       where logLevel is one of:" logLevels
   if logLevel<>"" then
   do
      say
      say "unknown loglevel supplied as an argument: [" loglevel "]"
   end
   exit -1
end

call rgf.sockets.cls                -- get access to the 'rgf.sockets.cls' classes

if logLevel<>"" then                -- if logLevel given, switch to it
do
   .rgf.sockets.logger~logLevel=logLevel  -- '.rgf.sockets.logger' is created by the 'rgf.sockets.cls' module
end

ip=.rgf.socket~getHostAddress(host) -- get the IP address

if .nil<>ip then                    -- got an IP address
do
   s=.rgf.socket~new                -- create a (stream) socket
   say "socket, before connection:"
   say "["s"]"
   say copies("-", 50)

   res=s~connect(ip, 80)            -- try to connect to wellknown http-server port
   say "socket, *after* connection:"
   say "["s"]"
   say copies("-", 50)

   if res<>-1 then
   do
      say "SUCCESS: could connect to ["host"], IP address: ["ip"]" "res:" res
   end
   else
   do
      say "error: could not connect to host, received:" res
      say "(you may want to retry the command)"
   end

   s~close                          -- close socket
end
else
do
  say "could not retrieve the IP address of given host: ["host"]"
  say "(you may want to retry the command, sometimes it takes two attempts to get to hosts)"
  exit -1
end

