
   -- determine the properties file to use; it defines three loggers
   -- named: 'rootLogger', 'one.two' and 'one.two.three.four'
propertiesFile="test-loggerSetup.properties"
.local~log4rexx.config.configFile=propertiesFile

-- .local~log4rexx.config.LogLog.debug=1
-- .local~log4rexx.config.LogLog.quietMode=.true

call load_log4rexx.rex        -- now let 'log4rexx' initialize, using the above properties file

logLevels=.array~of("TRACE", "DEBUG", "INFO", "WARN", "ERROR", "FATAL", "NONE")
loggers=.array~of(.LogManager~getLogger("rootLogger")         , -
                  .LogManager~getLogger("one.two")            , -
                  .LogManager~getLogger("one.two.three.four") )

exc=createException()         -- create an exception for testing purposes

do logger over loggerS
   say "working with logger" PP(logger~name)"..."
   say "working with logger" PP(logger)":"
   say
   do level over logLevelS
      .message~new(logger, level, "i", "an important" level "log message")~send
      if level="FATAL" then
         .message~new(logger, level, "i", "an important" level "log message", exc)~send
   end
   say "/\"~copies(20)
   say "\/"~copies(20)
   say
end

l=.list~of(.LogManager~loggerDir, .LogManager~appenderDir, -
           .LogManager~layoutDir, .LogManager~filterDir  )

do dir over l     -- iterate over directory
   say "-"~copies(50)
   stem.=sortByIndex(dir)
   do i=1 to stem.0
      say i "of" stem.0":" pp(dir~entry(stem.i))
      say
   end
end

say "-"~copies(50)
say ".log4rexx.config.LogLog.debug:" pp(.local~log4rexx.config.LogLog.debug)




::routine createException
  signal on any
  say 1/0
  return .nil

any:
  return condition("O")    -- return a condition object


